/* I2C-Demoprogramm zum Lesen eines einzelnen Datenbytes von einem Slave. 
 * Wenn der Master das Datenbyte = 0x03 liest, blinkt die grne LED.
 * Andernfalls blinkt die blaue LED. Die entsprechenden LEDs am Slave schalten 
 * ebenfalls um. Der Slave wird in LPM4 gehalten und mit der vom VLO-Timer 
 * festgelegten Rate abgefragt.
 * Der I2C-Takt wird vom Master geliefert. 
 * Dies ist der SLAVE-Code.
*/
#include <msp430.h> 
#include <stdio.h>
#include <stdint.h>
volatile uint8_t Data, NewData;

int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;   
    
    //Setzen Pins
    PM5CTL0 &= ~LOCKLPM5; 
    
    P1DIR |= BIT0; 
    P4DIR |= BIT7; 
    P1OUT &= ~BIT0; 
    P4OUT &= ~BIT7;
        
    P1SEL0 |= BIT2 + BIT3; //Setzen I2C pins
    
    //Setup I2C
    UCB0CTLW0 = UCSWRST;                      // Software reset 
    UCB0CTLW0 |= UCMODE_3 + UCSYNC;           
    UCB0I2COA0 = 0x77 | UCOAEN;               // Slave 0x77; 
    UCB0CTLW0 &= ~UCSWRST;                    // lschen Reset-Register

    _BIS_SR(GIE); 
    
    NewData = 0x03;
    UCB0IE |=UCTXIE0; 
    _NOP();
    while(1){
        LPM4; //Warten im  low-power mode auf Master-Interrupt
        // Wenn Master-Interrupt aufgetreten:
        // Senden einzelnes Datenbyte vom Slave an den Master.
        Data = NewData; 
        LPM0; //
        while (UCB0CTL1 & UCTXSTP); 
        
        if(NewData == 0x03){
            P4OUT |= BIT7;
            P1OUT &= ~BIT0;
            NewData = 0x04;
            }
        else{
            NewData = 0x03;
            P4OUT &= ~BIT7;
            P1OUT |= BIT0;
            }
        }
}

#pragma vector = USCI_B0_VECTOR
__interrupt void USCIB0_ISR(void)
{
  switch(__even_in_range(UCB0IV, USCI_I2C_UCBIT9IFG))
  {
    case USCI_NONE:        break;           // Vector 0: No interrupts
    case USCI_I2C_UCALIFG: break;           // Vector 2: ALIFG
    case USCI_I2C_UCNACKIFG: break;         // Vector 4: NACKIFG
    case USCI_I2C_UCSTTIFG: break;          // Vector 6: STTIFG
    case USCI_I2C_UCSTPIFG: break;          // Vector 8: STPIFG
    case USCI_I2C_UCRXIFG3: break;          // Vector 10: RXIFG3
    case USCI_I2C_UCTXIFG3: break;          // Vector 14: TXIFG3
    case USCI_I2C_UCRXIFG2: break;          // Vector 16: RXIFG2
    case USCI_I2C_UCTXIFG2: break;          // Vector 18: TXIFG2
    case USCI_I2C_UCRXIFG1: break;          // Vector 20: RXIFG1
    case USCI_I2C_UCTXIFG1: break;          // Vector 22: TXIFG1
    case USCI_I2C_UCRXIFG0: break;          // Vector 24: RXIFG0
    case USCI_I2C_UCTXIFG0:                 // Vector 26: TXIFG0
                            UCB0TXBUF = Data;
                            LPM4_EXIT;
                            break;
    case USCI_I2C_UCBCNTIFG: break;         // Vector 28: BCNTIFG
    case USCI_I2C_UCCLTOIFG: break;         // Vector 30: clock low timeout
    case USCI_I2C_UCBIT9IFG: break;         // Vector 32: 9th bit
    default: break;
  }
}


