/*
 * MSP430F5529_wdt_a.h
 */

#ifndef _MSP430F5529__WDT_A_H_
#define _MSP430F5529__WDT_A_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/*
 * WDTCTL Register, Page 459 TRM
 * -----------------------------------------------------------------------------
 * | 15  8 |    7    | 6     5 |     4    |     3    | 2   0 |
 * | WDTPW | WDTHOLD | WDTSSEL | WDTTMSEL | WDTCNTCL | WDTIS |
 * -----------------------------------------------------------------------------
 */
/*
 * WDTPW    :   Watchdog timer password. Always read as 069h. Must be written as
 *              5Ah; if any other value is written, a PUC is generated.
 */
/*
 * WDTHOLD  :   Watchdog timer hold. This bit stops the watchdog timer. Setting
 *              WDTHOLD = 1 when the WDT is not in use conserves power.
 *              0b = Watchdog timer is not stopped.
 *              1b = Watchdog timer is stopped.
 */
/*
 * WDTSSEL  :   Watchdog timer clock source select
 *              00b = SMCLK
 *              01b = ACLK
 *              10b = VLOCLK
 *              11b = X_CLK; VLOCLK in devices that do not support X_CLK
 */
/*
 * WDTTMSEL :   Watchdog timer mode select
 *              0b = Watchdog mode
 *              1b = Interval timer mode
 */
/*
 * WDTCNTCL     :  Watchdog timer counter clear. Setting WDTCNTCL = 1 clears the
 *                 count value to 0000h. WDTCNTCL is automatically reset.
 *                 0b = No action
 *                 1b = WDTCNT = 0000h
 */
/*
 * WDTIS    :   Watchdog timer interval select. These bits select the watchdog
 *              timer interval to set the WDTIFG flag and/or generate a PUC.
 *              000b = Watchdog clock source /(2^31) (18h:12m:16s at 32.768 kHz)
 *              001b = Watchdog clock source /(2^27) (01h:08m:16s at 32.768 kHz)
 *              010b = Watchdog clock source /(2^23) (00h:04m:16s at 32.768 kHz)
 *              011b = Watchdog clock source /(2^19) (00h:00m:16s at 32.768 kHz)
 *              100b = Watchdog clock source /(2^15) (1 s at 32.768 kHz)
 *              101b = Watchdog clock source /(2^13) (250 ms at 32.768 kHz)
 *              110b = Watchdog clock source /(2^9) (15.625 ms at 32.768 kHz)
 *              111b = Watchdog clock source /(2^6) (1.95 ms at 32.768 kHz)
 */
union WDTCTL_REG
{
    uint16_t all;

    struct
    {
        uint16_t WDTIS    : 3;
        uint16_t WDTCNTCL : 1;
        uint16_t WDTTMSEL : 1;
        uint16_t WDTSSEL  : 2;
        uint16_t WDTHOLD  : 1;
        uint16_t WDTPW    : 8;
    } bit;
};

struct WD_A_REGS
{
    union WDTCTL_REG    WDTCTL;
};

extern volatile struct WD_A_REGS WDARegs;

#define DisableWatchDog()         \
        WDARegs.WDTCTL.all = 0x5A80

#ifdef __cplusplus
}
#endif

#endif /* _MSP430F5529__WDT_A_H_ */
