#include <i2c.h>
#include "stdint.h"



uint8_t I2CMaster_writeBuffer(uint8_t *pData, uint8_t ui8Cnt)
{
    uint8_t count=0;
    while(UCB0STATW & UCBBUSY);
    UCB0CTLW0 |= UCSWRST;                     // Software reset enabled
    UCB0TBCNT = ui8Cnt;
    UCB0CTL1 &= ~UCSWRST;

    UCB0IFG = 0;
    UCB0CTLW0 |= UCTR | UCTXSTT;            // I2C TX, start condition

    while (count < ui8Cnt)
    {
        while (!(UCB0IFG & UCTXIFG0));
        UCB0IFG &= ~UCTXIFG0;
        UCB0TXBUF = *pData;
        pData++;
        count++;

    }
    return 1;
}

uint8_t I2CMaster_readBuffer(uint8_t *pData, uint8_t ui8Cnt)
{
    uint8_t count=0;
    while(UCB0STATW & UCBBUSY);
    UCB0CTLW0 |= UCSWRST;                     // Software reset enabled
    UCB0TBCNT = ui8Cnt;
    UCB0CTL1 &= ~UCSWRST;

    UCB0CTLW0 &= ~UCTR;
    UCB0IFG = 0;
    UCB0CTLW0 |= UCTXSTT;            // I2C TX, start condition
    while (count < ui8Cnt)
    {
        while (!(UCB0IFG & UCRXIFG0));
        UCB0IFG &= ~UCTXIFG0;
        *pData= UCB0RXBUF;
        pData++;
        count++;

    }
    return 1;
}
uint8_t Status_check(void)
{
    uint8_t res;
    uint8_t buf[1]={0xBB};
    I2CMaster_writeBuffer(buf, 1);
    __delay_cycles(2000);
    res = I2CMaster_readBuffer(buffer, 1);
    return buffer[0];
}

void Host_BSL_entry_software(void)
{
    uint8_t buf[1]={0xAA};
    I2CMaster_writeBuffer(buf, 1);
}
