/*
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 *
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device's power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/

//                MSP430FR59691
//             -----------------
//            |                 |--LFXTIN (32768Hz reqd.)
//        /|\ |                 |--LFXTOUT
//         |  |                 |
//          --|RST  P1.6/UCB0SDA|---->
//            |                 |
//            |     P1.7/UCB0SCL|<----
//            |                 |
//            |             P1.0|-->LED
//            |                 |
//******************************************************************************
//#define DEBUG   //Define it if use debug mode
#include <msp430.h>
#include "bsl_app.h"


unsigned char rx_data;
void main(void)
{   unsigned short i,j;
    WDTCTL = WDTPW | WDTHOLD;             // Stop watchdog timer
    *(unsigned char *) _jump_key = 0xAA;                     // Write key value
//    FRCTL0 = FRCTLPW | WPROT;    // Enable global FRAM memory protection as early as possible(This is used for devices have FRCTL_A like MSP430FR6047)
    for(i=RAM_Interrupt_Start,j=FRAM_Interrupt_Start;i<RAM_Interrupt_End;i++,j++)
        *(unsigned char *) i =*(unsigned char *) j;// Write the vector

  SYSCTL = SYSRIVECT;
  P1OUT =0;                         // Clear P1.0 output latch for a defined power-on state
  P1DIR |= BIT0;                          // Set P1.0 to output direction

  P1SEL1 |= BIT6 | BIT7;                    // I2C pins
  PM5CTL0 &= ~LOCKLPM5;                     // Disable the GPIO power-on default high-impedance mode

  // Startup clock system with max DCO setting ~8MHz
  CSCTL0_H = CSKEY_H;                     // Unlock CS registers
  CSCTL1 = DCOFSEL_3 | DCORSEL;           // Set DCO to 8MHz
  CSCTL2 = SELA__VLOCLK | SELS__DCOCLK | SELM__DCOCLK;
  CSCTL3 = DIVA__1 | DIVS__1 | DIVM__1;   // Set all dividers
  CSCTL0_H = 0;                           // Lock CS registers

  // Configure USCI_B0 for I2C mode
  UCB0CTLW0 = UCSWRST;                      // Software reset enabled
  UCB0CTLW0 |= UCMODE_3 | UCSYNC;           // I2C mode, sync mode
  UCB0I2COA0 = 0x48 | UCOAEN;               // own address is 0x48 + enable
  UCB0CTLW0 &= ~UCSWRST;                    // clear reset register
  UCB0IE |= UCRXIE0 |UCTXIE0 | UCSTPIE;              // transmit,stop interrupt enable

  __bis_SR_register(GIE);

  while(1)
  {
      P1OUT ^= BIT0;                      // Toggle P1.0 using exclusive-OR
      __delay_cycles(500000);             // Delay for 100000*(1/MCLK)=0.1s

  }

}



#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector = USCI_B0_VECTOR
__interrupt void USCI_B0_ISR(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(USCI_B0_VECTOR))) USCI_B0_ISR (void)
#else
#error Compiler not supported!
#endif
{
  switch(__even_in_range(UCB0IV, USCI_I2C_UCBIT9IFG))
  {
    case USCI_NONE:          break;         // Vector 0: No interrupts
    case USCI_I2C_UCALIFG:   break;         // Vector 2: ALIFG
    case USCI_I2C_UCNACKIFG: break;         // Vector 4: NACKIFG
    case USCI_I2C_UCSTTIFG:  break;         // Vector 6: STTIFG
    case USCI_I2C_UCSTPIFG:                 // Vector 8: STPIFG

      UCB0IFG &= ~UCSTPIFG;                 // Clear stop condition int flag
      break;
    case USCI_I2C_UCRXIFG3:  break;         // Vector 10: RXIFG3
    case USCI_I2C_UCTXIFG3:  break;         // Vector 12: TXIFG3
    case USCI_I2C_UCRXIFG2:  break;         // Vector 14: RXIFG2
    case USCI_I2C_UCTXIFG2:  break;         // Vector 16: TXIFG2
    case USCI_I2C_UCRXIFG1:  break;         // Vector 18: RXIFG1
    case USCI_I2C_UCTXIFG1:  break;         // Vector 20: TXIFG1
    case USCI_I2C_UCRXIFG0:
        rx_data = UCB0RXBUF;
        #ifndef DEBUG
        if(rx_data==0xAA)                    //Jump to BSL mode
        {
            __disable_interrupt();              // disable interrupts
            *(unsigned char *)_jump_key = 0xFF;// Write the jump key
            UCB0IE=0;
            ((void ( * )())0x1000)();    // jump to BSL
        }
        #endif
        break;         // Vector 22: RXIFG0
    case USCI_I2C_UCTXIFG0:                 // Vector 24: TXIFG0
        if(rx_data==0xAA)                    //Jump to BSL mode
        {
      #ifdef DEBUG
            UCB0TXBUF =  0x11;           //Response to host target in application mode
      #endif
        }else
        {
            if(rx_data==0xBB)            //Host check target status
                UCB0TXBUF =  0x22;       //Response to host target in application mode
        }
      break;
    case USCI_I2C_UCBCNTIFG: break;         // Vector 26: BCNTIFG
    case USCI_I2C_UCCLTOIFG: break;         // Vector 28: clock low timeout
    case USCI_I2C_UCBIT9IFG: break;         // Vector 30: 9th bit
    default: break;
  }
}

