/*
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 *
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device's power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/

//                MSP430FR5969
//             -----------------
//            |                 |--LFXTIN (32768Hz reqd.)
//        /|\ |                 |--LFXTOUT
//         |  |                 |
//          --|RST  P2.0/UCA0TXD|---->
//            |                 |
//            |     P2.1/UCA0RXD|<----
//            |                 |
//            |             P1.0|-->LED
//            |             P4.6|-->LED
//******************************************************************************
//#define DEBUG   //Define it if use debug mode
#include <msp430.h>
#include "bsl_app.h"



void main(void)
{   unsigned short i,j;
    WDTCTL = WDTPW | WDTHOLD;             // Stop watchdog timer
    *(unsigned char *) _jump_key = 0xAA;                     // Write key value
//    FRCTL0 = FRCTLPW | WPROT;    // Enable global FRAM memory protection as early as possible(This is used for devices have FRCTL_A like MSP430FR6047)
    for(i=RAM_Interrupt_Start,j=FRAM_Interrupt_Start;i<RAM_Interrupt_End;i++,j++)
        *(unsigned char *) i =*(unsigned char *) j;// Write the vector

  SYSCTL = SYSRIVECT;
  P1OUT =0;                         // Clear P1.0 output latch for a defined power-on state
  P1DIR |= BIT0;                          // Set P1.0 to output direction
  // Configure UART pins
  P2SEL0 &= ~(BIT0 | BIT1);
  P2SEL1 |= BIT0 | BIT1;                  // USCI_A0 UART operation
  PM5CTL0 &= ~LOCKLPM5;                     // Disable the GPIO power-on default high-impedance mode

  // Startup clock system with max DCO setting ~8MHz
  CSCTL0_H = CSKEY_H;                     // Unlock CS registers
  CSCTL1 = DCOFSEL_3 | DCORSEL;           // Set DCO to 8MHz
  CSCTL2 = SELA__VLOCLK | SELS__DCOCLK | SELM__DCOCLK;
  CSCTL3 = DIVA__1 | DIVS__1 | DIVM__1;   // Set all dividers
  CSCTL0_H = 0;                           // Lock CS registers

  // Configure USCI_A0 for UART mode
  UCA0CTLW0 = UCSWRST;                    // Put eUSCI in reset
  UCA0CTLW0 |= UCSSEL__SMCLK | UCPEN | UCPAR;             // CLK = SMCLK
  // Baud Rate calculation
  // 8000000/(16*9600) = 52.083
  // Fractional portion = 0.083
  // User's Guide Table 24-4: UCBRSx = 0x04
  // UCBRFx = int ( (52.083-52)*16) = 1
  UCA0BRW = 52;                           // 8000000/16/9600
  UCA0MCTLW |= UCOS16 | UCBRF_1 | 0x4900;
  UCA0CTLW0 &= ~UCSWRST;                  // Initialize eUSCI
  UCA0IE |= UCRXIE;                       // Enable USCI_A0 RX interrupt
  __bis_SR_register(GIE);

  while(1)
  {
      P1OUT ^= BIT0;                      // Toggle P1.0 using exclusive-OR
      __delay_cycles(500000);             // Delay for 100000*(1/MCLK)=0.1s

  }

}


#pragma vector=USCI_A0_VECTOR
__interrupt void USCI_A0_ISR(void)
{
    unsigned char rx_data;
    switch(__even_in_range(UCA0IV, USCI_UART_UCTXCPTIFG))
    {
        case USCI_NONE: break;
        case USCI_UART_UCRXIFG:
            while(!(UCA0IFG&UCTXIFG));
            rx_data=UCA0RXBUF;
            if(rx_data==0xAA)                    //Jump to BSL mode
            {
         #ifndef DEBUG
                __disable_interrupt();              // disable interrupts
                *(unsigned char *)_jump_key = 0xFF;// Write the jump key
                UCA0CTLW0 = UCSWRST;
                UCA0MCTLW = 0;
                UCA0IE=0;
                ((void ( * )())0x1000)();    // jump to BSL
         #else
                UCA0TXBUF =  0x11;           //Response to host target in application mode
         #endif

            }else
            {
                if(rx_data==0xBB)            //Host check target status
                    UCA0TXBUF =  0x22;       //Response to host target in application mode
            }
            __no_operation();
            break;
        case USCI_UART_UCTXIFG: break;
        case USCI_UART_UCSTTIFG: break;
        case USCI_UART_UCTXCPTIFG: break;
        default: break;
    }
}

