/******************************************************************************/
/* LINKER COMMAND FILE FOR MSPBoot BOOTLOADER USING msp430fr5969  */
/* File generated with MSPFRBSL_Linkergen.py on 2020-07-08 */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* The following definitions can be changed to customize the memory map for a different device
 *   or other adjustments
 *  Note that the changes should match the definitions used in MEMORY and SECTIONS
 *
 */
/* RAM Memory Addresses */

_jump_key = 0xFF3E;         //This the start of the FRAM address
_Appl_Reset_Vector = 0xFF3C;//Followd the jump key

MEMORY
{
    RAM                     : origin = 0x1c00, length = 0x7cc
    FRAM                    : origin = 0xFF40, length = 0x40
    JTAGSIGNATURE           : origin = 0xFF80, length = 0x0004, fill = 0xFFFF
    BSLSIGNATURE            : origin = 0xFF84, length = 0x0004, fill = 0xFFFF
    RESET                   : origin = 0xFFFE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    GROUP(ALL_FRAM)
    {
        GROUP(READ_WRITE_MEMORY)
        {
            .TI.persistent : {}                /* For #pragma persistent            */
        }

        GROUP(READ_ONLY_MEMORY)
        {
            .cinit      : {}                   /* Initialization tables             */
            .pinit      : {}                   /* C++ constructor tables            */
            .binit      : {}                   /* Boot-time Initialization tables   */
            .init_array : {}                   /* C++ constructor tables            */
            .mspabi.exidx : {}                 /* C++ constructor tables            */
            .mspabi.extab : {}                 /* C++ constructor tables            */
            .const      : {}                   /* Constant data                     */
        }

        GROUP(EXECUTABLE_MEMORY)
        {
            .text       : {}                   /* Code                              */
            .text:_isr  : {}                   /* Code ISRs                         */
        }
    } > FRAM

    #ifdef __TI_COMPILER_VERSION__
        #if __TI_COMPILER_VERSION__ >= 15009000
            .TI.ramfunc : {} load=FRAM, run=RAM, table(BINIT)
        #endif
    #endif

    .jtagsignature      : {} > JTAGSIGNATURE
    .bslsignature       : {} > BSLSIGNATURE

    .cio        : {} > RAM                  /* C I/O buffer                      */
    .sysmem     : {} > RAM                  /* Dynamic memory allocation area    */
    .bss        : {} > RAM                  /* Global & static vars              */
    .data       : {} > RAM                  /* Global & static vars              */
    .TI.noinit  : {} > RAM                  /* For #pragma noinit                */
    .stack      : {} > RAM (HIGH)           /* Software system stack             */

    /* MSP430 interrupt vectors */

    .reset       : {}               > RESET  /* MSP430 reset vector         */

}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/


-l msp430fr5969.cmd

