#include "uart.h"
#include "stdint.h"



uint8_t UART_writeBuffer( uint8_t *pData,  uint8_t ui8Cnt)
{
 uint8_t res;

 while(ui8Cnt--)
  {
     BSL_sendSingleByte(*pData);
     pData++;
    // __delay_cycles(10000);
  }
 res = BSL_getResponse();
 return res;
}

/* Reads one byte from BSL target */
uint8_t BSL_getResponse(void) {
    uint32_t timeout = TIMEOUT_COUNT;

    while ((!(UCA1IFG & UCRXIFG)) && (timeout-- > 0))
        ;

    if (!timeout)
        return 0xFF;
    else
        return UCA1RXBUF;

}

void UART_readBuffer( uint8_t *pData, uint8_t ui8Cnt)
{
 //   uint8_t res;
    while(ui8Cnt-->0)
     {
        *pData = BSL_getResponse();
        pData++;
     }

}

/* Sends single I2C Byte (start and stop included) */
void BSL_sendSingleByte(uint8_t ui8Byte) {
    uint32_t timeout = TIMEOUT_COUNT;
    while ((!(UCA1IFG & UCTXIFG)) && (timeout-- > 0))
        ;

    if (!timeout)
        return;
    else
        UCA1TXBUF = ui8Byte;
}

uint8_t Status_check(void)
{
    uint8_t res;
    BSL_sendSingleByte(0xBB);
    res = BSL_getResponse();
    return res;
}

void Host_BSL_entry_software(void)
{

    BSL_sendSingleByte(0xAA);

}
