#include <Serial_Cmd_Monitor.h>
UARTmon myMonitor;

//globals to 
int inByte = 0;         // incoming serial byte
volatile int toggleState=0;
volatile long waitCtr=0;

void setup() {
  // start serial port at 9600 bps:
  Serial.begin(9600);
  
  pinMode(RED_LED, OUTPUT);
}

void loop() {
  // put your main code here, to run repeatedly: 
    //allow host to control something visible;
    ToggleLed();

    //monitor processing
    if (Serial.available() > 0) {
        // get incoming byte:
        inByte = Serial.read();
        myMonitor.receivedDataCommand(inByte);
    }
}

void ToggleLed()
{
    //optimize a bit to skip pin setting if there is no change in toggleState variable controlled by the host.
    //optimize a bit to skip pin setting if there is no change in toggleState variable controlled by the host.
    if (waitCtr == 0){
        waitCtr = 0x40000;
        if (toggleState) {
            digitalWrite(RED_LED, LOW);   // set the LED on
        }
        else {
            digitalWrite(RED_LED, HIGH);    // set the LED off
        }
        toggleState = !toggleState;
    } else {
        waitCtr--;
    }
}
