@echo off
echo Prepare IAR outputs to C for MSP-EXP430F5438 Host

REM Convert all target devices (x)
set Target[0]=G2553_I2C
set Target[1]=G2452_I2C
set Target[2]=FR5739_I2C
REM Convert all Apps (y)
set App[0]=App1
set App[1]=App2
REM Build all configurations (z)
set Config[0]=Simple
set Config[1]=BSLBased
set Config[2]=SMBus
set Config[3]=BSLBased_DualImg

REM Memory Configuration. I.e. Mem[0][1] corresponds to G2553_I2C, BSLBased
REM CRC App1-2 G2553 Simple (boot at FE00, start at C000)
set Mem[0][0]=C003 FDFF C00
REM CRC App1-2 G2553 BSL (boot at FC00, start at C000)
set Mem[0][1]=C003 FBFF C00
REM CRC App1-2 G2553 SMBus (boot at FC00, start at C000)
set Mem[0][2]=C003 FBFF C00
REM CRC App1-2 G2553 BSL-Dual (boot at FC00, start at E000)
set Mem[0][3]=E003 FBFF E00
REM CRC App1-2 G2452 Simple (boot at FC00, start at E000)
set Mem[1][0]=E003 FBFF E00
REM CRC App1-2 G2452 BSL (boot at FA00, start at E000)
set Mem[1][1]=E003 F9FF E00
REM CRC App1-2 G2452 SMBus (boot at FA00, start at E000)
set Mem[1][2]=E003 F9FF E00
REM CRC App1-2 G2452 BSL-Dual (boot at FA00, start at EE00)
set Mem[1][3]=EE03 F9FF EE0
REM CRC App1-2 FR5739 Simple (boot at FC00, start at C200)
set Mem[2][0]=C203 FBFF C20
REM CRC App1-2 FR5739 BSL (boot at FA00, start at C200)
set Mem[2][1]=C203 F9FF C20
REM CRC App1-2 FR5739 SMBus (boot at FA00, start at C200)
set Mem[2][2]=C203 F9FF C20
REM CRC App1-2 FR5739 BSL-Dual (boot at FA00, start at DE00)
set Mem[2][3]=DE03 F9FF DE0


REM Loop to convert all projects, configurations and target devices
for %%x in (0,1,2) do (
    call echo:
    call echo ********** Copy and convert %%Target[%%x]%%  **********
    call echo:
    for %%y in (0,1) do (
        for %%z in (0,1,2,3) do (
            REM  1) Copy output files to the App_Output folder. I.e. 
            REM  copy /Y "..\Target\G2553_I2C\IAR\App1_MSPBoot\BSLBased\Exe\App1_MSPBoot.txt" 		                                App_Outputs\App1_G2553_I2C_BSLBased.txt
            call copy /Y "..\Target\%%Target[%%x]%%\IAR\%%App[%%y]%%_MSPBoot\%%Config[%%z]%%\Exe\%%App[%%y]%%_MSPBoot.txt" 		    App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%.txt
            REM  2) Calculate CRC for all output files. I.e.
            REM  CRCGen430.exe CRC16 App_Outputs\App1_FR5739_Simple.txt App_Outputs\temp.txt C203 FBFF C200
            REM  CRCGen430.exe CRC8  App_Outputs\temp.txt App_Outputs\App1_FR5739_Simple_CRC.txt C203 FBFF C202
            call echo **Test %%Mem[%%x][%%z]%%0 %%Mem[%%x][%%z]%%2**
            call CRCGen430.exe CRC16 App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%.txt App_Outputs\temp.txt %%Mem[%%x][%%z]%%0
            call CRCGen430.exe CRC8 App_Outputs\temp.txt App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%_CRC.txt %%Mem[%%x][%%z]%%2
            REM  3) Convert .txt to C array. I.e.
            REM 430txt2C.pl "App_Outputs\App1_G2553_Simple_CRC.txt" 	"App_Outputs\App1_G2553_Simple.c"   		App1_Simple
            call 430txt2C.pl App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%_CRC.txt App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%.c %%App[%%y]%%_%%Config[%%z]%%
            REM  4) Copy C output to F5438 Host TargetApps folder
            call copy /Y App_Outputs\%%App[%%y]%%_%%Target[%%x]%%_%%Config[%%z]%%.c ..\Host\MSP-EXP430F5438\Src\TargetApps
        )
    )
)


