/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
#ifndef DEVICESPECIFICS_H_
#define DEVICESPECIFICS_H_

//
// Include files
//
#include "msp430.h"
#include <stdint.h>

//
//  Definitions
//
#define SYSTEM_CLOCK    16000000                /*!  System Clock (16Mhz)    */
#define DELAY_MS        (SYSTEM_CLOCK/1000)     /*! Number of cycles for 1ms */

/*! SDA in P3.7, SCL in P5.4 for F5438A */
#define I2C_SDA_PORT_SEL    P3SEL       /*! PxSEL for SDA   */
#define I2C_SDA_REN         P3REN       /*! PxREN for SDA   */
#define I2C_SDA_POUT        P3OUT       /*! PxOUT for SDA   */
#define I2C_SDA_PIN         BIT7        /*! Bit for SDA pin */
#define I2C_SCL_PORT_SEL    P5SEL       /*! PxSEL for SCL   */
#define I2C_SCL_REN         P5REN       /*! PxREN for SCL  */
#define I2C_SCL_POUT        P5OUT       /*! PxOUT for SCL  */
#define I2C_SCL_PIN         BIT4        /*! Bit for SCL pin */

#endif /*DEVICESPECIFICS_H_*/
