/******************************************************************************/
/* LINKER COMMAND FILE FOR MSPBoot BOOTLOADER USING MSP430FR5739  */
/* File generated with MSPBootLinkerGen.pl on 02-10-2014 */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* The following definitions can be changed to customize the memory map for a different device
 *   or other adjustments
 *  Note that the changes should match the definitions used in MEMORY and SECTIONS
 *
 */
/* RAM Memory Addresses */
__RAM_Start = 0x1C00;                 /* RAM Start */
__RAM_End = 0x1FFF;                     /* RAM End */
    /* RAM shared between App and Bootloader, must be reserved */
    PassWd = 0x1C00;                 /* Password sent by App to force boot  mode */
    StatCtrl = 0x1C02;             /* Status and Control  byte used by Comm */
    CI_State_Machine = 0x1C03;         /*  State machine variable used by Comm */
    CI_Callback_ptr = 0x1C04;   /* Pointer to Comm callback structure */
    /* Unreserved RAM used for Bootloader or App purposes */
    _NonReserved_RAM_Start = 0x1C06; /* Non-reserved RAM */

/* Flash memory addresses */
__Flash_Start = 0xC200;             /* Start of Flash */
__Flash_End = 0xFFFF;                           /* End of Flash */
    /* Reserved Flash locations for Bootloader Area */
    __Boot_Start = 0xFC00;         /* Boot flash */
    __Boot_Reset = 0xFFFE;                          /* Boot reset vector */
    __Boot_VectorTable = 0xFF90;      /* Boot vector table */
    __Boot_SharedCallbacks_Len = 8; /* Length of shared callbacks (2 calls =4B(msp430) or 8B(msp430x) */
    __Boot_SharedCallbacks = 0xFF88; /* Start of Shared callbacks */
    /* Reserved Flash locations for Application Area */
    _AppChecksum = (__Flash_Start);                 /* CRC16 of Application */
    _AppChecksum_8 = (__Flash_Start+2);             /* CRC8 of Application */
    _App_Start = (__Flash_Start+3);                 /* Application Area */
    _App_End = (__Boot_Start-1);                    /* End of application area (before boot) */
    _CRC_Size = (_App_End - _App_Start +1);         /* Number of bytes calculated for CRC */
    _App_Reset_Vector = (__Boot_Start-2);           /* Address of Application reset vector */
    _App_Proxy_Vector_Start = 0xFB90; /* Proxy interrupt table */

/* MEMORY definition, adjust based on definitions above */
MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    // RAM from _NonReserved_RAM_Start - __RAM_End
    RAM                     : origin = 0x1C06, length = 0x3FA
    INFOBOOT                : origin = 0x1800, length = 0x100
    // Flash from __Boot_Start -( __Boot_SharedCallbacks or INT_VECTOR_TABLE)
    FLASH                   : origin = 0xFC00, length = 0x388
    // Shared callbacks from __Boot_SharedCallbacks + Len (when used)
    BOOT_SHARED_CALLBACKS   : origin = 0xFF88, length = 8
    // Boot vector Table from __Boot_VectorTable- __Boot_Reset
    INT_VECTOR_TABLE        : origin = 0xFF90, length = 0x6E
    // Boot reset from __Boot_Reset-__Flash_End
    RESET                   : origin = 0xFFFE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

    .text       : {} >> FLASH |INFOBOOT   /* CODE                 */
    .cinit      : {} >> FLASH |INFOBOOT   /* INITIALIZATION TABLES*/
    .const      : {} >> FLASH |INFOBOOT   /* CONSTANT DATA        */
    .cio        : {} > RAM                /* C I/O BUFFER                      */

    .BOOT_APP_VECTORS : {} > BOOT_SHARED_CALLBACKS
    /* MSP430 INTERRUPT VECTORS          */
    .BOOT_VECTOR_TABLE : {} > INT_VECTOR_TABLE
    .reset       : {}               > RESET  /* MSP430 RESET VECTOR         */ 
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l MSP430FR5739.cmd

