@echo off
REM ********** G2553_I2C **************
REM Linker file for G2553 using 1KB
REM Flash Start: 0xC000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 48 (12 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x3FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2553_I2C using 1KB
perl MSPBootLinkerGen.pl -file lnk_msp430G2553_I2C_1KB -dev MSP430G2553 -params 0xC000 0xFFE0 0xFC00 48 4 0x200 0x3FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
REM Linker file for G2553 using 512B
REM Flash Start: 0xC000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFE00 (512B)
REM Size of proxy table: 48 (12 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x3FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2553_I2C using 512B
perl MSPBootLinkerGen.pl -file lnk_msp430G2553_I2C_512B -dev MSP430G2553 -params 0xC000 0xFFE0 0xFE00 48 4 0x200 0x3FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
REM Linker file for G2553 using 1KB with dual support
REM Flash Start: 0xC000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 48 (12 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x3FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
REM Dual support with image size: 0x2000 (0xC000-0xDFFF, 0xE000-0xFFFF)
echo -----------------------------------------------------------------------------
echo Linker file for G2553_I2C using 1KB with dual support
perl MSPBootLinkerGen.pl -file lnk_msp430G2553_I2C_1KB_Dual -dev MSP430G2553 -dual 0x2000 -params 0xC000 0xFFE0 0xFC00 48 4 0x200 0x3FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
copy /Y output\lnk_msp430G2553_I2C*_Boot.xcl ..\Target\G2553_I2C\IAR\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_I2C*_App.xcl ..\Target\G2553_I2C\IAR\App1_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_I2C*_App.xcl ..\Target\G2553_I2C\IAR\App2_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_I2C*_Boot.cmd ..\Target\G2553_I2C\CCS\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_I2C*_App.cmd ..\Target\G2553_I2C\CCS\App1_MSPBoot\Config_App\
copy /Y output\lnk_msp430G2553_I2C*_App.cmd ..\Target\G2553_I2C\CCS\App2_MSPBoot\Config_App\

REM ********** G2452_I2C **************
REM Linker file for G2452 using 1KB
REM Flash Start: 0xE000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 36 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x2FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2452_I2C using 1KB
perl MSPBootLinkerGen.pl -file lnk_msp430G2452_I2C_1KB -dev MSP430G2452 -params 0xE000 0xFFE0 0xFC00 36 4 0x200 0x2FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------

REM Linker file for G2452 using 1.5KB
REM Flash Start: 0xE000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFA00 (1.5KB)
REM Size of proxy table: 36 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x2FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2452_I2C using 1.5KB
perl MSPBootLinkerGen.pl -file lnk_msp430G2452_I2C_1_5KB -dev MSP430G2452 -params 0xE000 0xFFE0 0xFA00 36 4 0x200 0x2FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
REM Linker file for G2452 using 1.5KB with dual support
REM Flash Start: 0xE000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFA00 (1.5KB)
REM Size of proxy table: 36 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x2=4
REM RAM Start: 0x200
REM RAM End: 0x2FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
REM Dual support with image size: 0xE00 (0xE000-0xEDFF, 0xEE00-0xF9FF)
echo -----------------------------------------------------------------------------
echo Linker file for G2452_I2C using 1.5KB with dual support
perl MSPBootLinkerGen.pl -file lnk_msp430G2452_I2C_1_5KB_Dual -dev MSP430G2452 -dual 0xE00 -params 0xE000 0xFFE0 0xFA00 36 4 0x200 0x2FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
copy /Y output\lnk_msp430G2452_I2C*_Boot.xcl ..\Target\G2452_I2C\IAR\MSPBoot\Config\
copy /Y output\lnk_msp430G2452_I2C*_App.xcl ..\Target\G2452_I2C\IAR\App1_MSPBoot\Config\
copy /Y output\lnk_msp430G2452_I2C*_App.xcl ..\Target\G2452_I2C\IAR\App2_MSPBoot\Config\
copy /Y output\lnk_msp430G2452_I2C*_Boot.cmd ..\Target\G2452_I2C\CCS\MSPBoot\Config\
copy /Y output\lnk_msp430G2452_I2C*_App.cmd ..\Target\G2452_I2C\CCS\App1_MSPBoot\Config_App\
copy /Y output\lnk_msp430G2452_I2C*_App.cmd ..\Target\G2452_I2C\CCS\App2_MSPBoot\Config_App\

REM ********** FR5739_I2C **************
REM Linker file for FR5739 using 1KB
REM Flash Start: 0xC200
REM Interrupt Vector start address: 0xFF90
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 110 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x4=8
REM RAM Start: 0x1C00
REM RAM End: 0x1FFF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1800
REM Info memory used by Bootloader End: 0x18FF
REM Use interrupt vectors from template_FR5739_vectors.tmpl instead of proxy table
echo -----------------------------------------------------------------------------
echo Linker file for FR5739_I2C using 1KB
perl MSPBootLinkerGen.pl -file lnk_msp430FR5739_I2C_1KB -dev MSP430FR5739 -i template_FR5739_vectors.tmpl -params 0xC200 0xFF90 0xFC00 110 8 0x1C00 0x1FFF 0x50 0x1800 0x18FF
echo -----------------------------------------------------------------------------

REM Linker file for FR5739 using 1.5KB
REM Flash Start: 0xC200
REM Interrupt Vector start address: 0xFF90
REM Bootloader start address: 0xFA00 (1.5KB)
REM Size of proxy table: 110 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x4=8
REM RAM Start: 0x1C00
REM RAM End: 0x1FFF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1800
REM Info memory used by Bootloader End: 0x18FF
REM Use interrupt vectors from template_FR5739_vectors.tmpl instead of proxy table
echo -----------------------------------------------------------------------------
echo Linker file for FR5739_I2C using 1.5KB
perl MSPBootLinkerGen.pl -file lnk_msp430FR5739_I2C_1_5KB -dev MSP430FR5739 -i template_FR5739_vectors.tmpl  -params 0xC200 0xFF90 0xFA00 110 8 0x1C00 0x1FFF 0x50 0x1800 0x18FF
echo -----------------------------------------------------------------------------
REM Linker file for FR5739 using 1.5KB with dual support
REM Flash Start: 0xC200
REM Interrupt Vector start address: 0xFF90
REM Bootloader start address: 0xFA00 (1.5KB)
REM Size of proxy table: 110 (9 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x4=8
REM RAM Start: 0x1C00
REM RAM End: 0x1FFF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1800
REM Info memory used by Bootloader End: 0x18FF
REM Dual support with image size: 0xE00 (0xE000-0xEDFF, 0xEE00-0xF9FF)
REM Use interrupt vectors from template_FR5739_vectors.tmpl instead of proxy table
echo -----------------------------------------------------------------------------
echo Linker file for FR5739_I2C using 1.5KB with dual support
perl MSPBootLinkerGen.pl -file lnk_msp430FR5739_I2C_1_5KB_Dual -dev MSP430FR5739 -dual 0x1C00 -i template_FR5739_vectors.tmpl  -params 0xC200 0xFF90 0xFA00 110 8 0x1C00 0x1FFF 0x50 0x1800 0x18FF
echo -----------------------------------------------------------------------------

copy /Y output\lnk_msp430fr5739_I2C*_Boot.xcl ..\Target\FR5739_I2C\IAR\MSPBoot\Config\
copy /Y output\lnk_msp430fr5739_I2C*_App.xcl ..\Target\FR5739_I2C\IAR\App1_MSPBoot\Config\
copy /Y output\lnk_msp430fr5739_I2C*_App.xcl ..\Target\FR5739_I2C\IAR\App2_MSPBoot\Config\
copy /Y output\lnk_msp430fr5739_I2C*_Boot.cmd ..\Target\fr5739_I2C\CCS\MSPBoot\Config\
copy /Y output\lnk_msp430fr5739_I2C*_App.cmd ..\Target\fr5739_I2C\CCS\App1_MSPBoot\Config_App\
copy /Y output\lnk_msp430fr5739_I2C*_App.cmd ..\Target\fr5739_I2C\CCS\App2_MSPBoot\Config_App\

REM ********** G2553 UART**************
REM Linker file for G2553_UART using 1KB
REM Flash Start: 0xC000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 48 (12 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x3=6
REM RAM Start: 0x200
REM RAM End: 0x3FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2553_UART using 1KB
perl MSPBootLinkerGen.pl -file lnk_msp430G2553_UART_1KB -dev MSP430G2553 -params 0xC000 0xFFE0 0xFC00 48 6 0x200 0x3FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
copy /Y output\lnk_msp430G2553_UART*_Boot.xcl ..\Target\G2553_UART\IAR\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_UART*_App.xcl ..\Target\G2553_UART\IAR\App1_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_UART*_App.xcl ..\Target\G2553_UART\IAR\App2_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_UART*_Boot.cmd ..\Target\G2553_UART\CCS\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_UART*_App.cmd ..\Target\G2553_UART\CCS\App1_MSPBoot\Config_App\
copy /Y output\lnk_msp430G2553_UART*_App.cmd ..\Target\G2553_UART\CCS\App2_MSPBoot\Config_App

REM ********** G2553 SPI**************
REM Linker file for G2553_SPI using 1KB
REM Flash Start: 0xC000
REM Interrupt Vector start address: 0xFFE0
REM Bootloader start address: 0xFC00 (1KB)
REM Size of proxy table: 48 (12 vectors x 4)
REM Size of vector functions shared between Boot/App : 2x3=6
REM RAM Start: 0x200
REM RAM End: 0x3FF
REM Stack Size: 0x50
REM Info memory used by Bootloader Start: 0x1000
REM Info memory used by Bootloader End: 0x10BF
echo -----------------------------------------------------------------------------
echo Linker file for G2553_SPI using 1KB
perl MSPBootLinkerGen.pl -file lnk_msp430G2553_SPI_1KB -dev MSP430G2553 -params 0xC000 0xFFE0 0xFC00 48 6 0x200 0x3FF 0x50 0x1000 0x10BF
echo -----------------------------------------------------------------------------
copy /Y output\lnk_msp430G2553_SPI*_Boot.xcl ..\Target\G2553_SPI\IAR\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_SPI*_App.xcl ..\Target\G2553_SPI\IAR\App1_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_SPI*_App.xcl ..\Target\G2553_SPI\IAR\App2_MSPBoot\Config\
copy /Y output\lnk_msp430G2553_SPI*_Boot.cmd ..\Target\G2553_SPI\CCS\MSPBoot\Config\
copy /Y output\lnk_msp430G2553_SPI*_App.cmd ..\Target\G2553_SPI\CCS\App1_MSPBoot\Config_App\
copy /Y output\lnk_msp430G2553_SPI*_App.cmd ..\Target\G2553_SPI\CCS\App2_MSPBoot\Config_App\