/* --COPYRIGHT--,BSD
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
/*
 * ======== hal.c ========
 *
 */
#include "msp430.h"

#include "driverlib.h"

#include "USB_API/USB_Common/device.h"
#include "USB_config/descriptors.h"

#include "hal.h"

#define GPIO_ALL        GPIO_PIN0 | GPIO_PIN1 | GPIO_PIN2 | GPIO_PIN3 | \
        GPIO_PIN4 | GPIO_PIN5 | GPIO_PIN6 | GPIO_PIN7



/*
 * This functions drives all the outputs low which may not be optimal for a
 * different board. This function needs to be modified as per the connections
 * to the GPIO pins.
 */
void USBHAL_initPorts(void)
{
#ifdef __MSP430_HAS_PORT1_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P1, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P1, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT2_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P2, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P2, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT3_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P3, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P3, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT4_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P4, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P4, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT5_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P5, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P5, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT6_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P6, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P6, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT7_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P7, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P7, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT8_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P8, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P8, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORT9_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_P9, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_P9, GPIO_ALL);
#endif

#ifdef __MSP430_HAS_PORTJ_R__
        GPIO_setOutputLowOnPin(GPIO_PORT_PJ, GPIO_ALL);
        GPIO_setAsOutputPin(GPIO_PORT_PJ, GPIO_ALL);
#endif
}

void USBHAL_initClocks(uint32_t mclkFreq)
{
        UCS_initClockSignal(
                UCS_FLLREF,
                UCS_REFOCLK_SELECT,
                UCS_CLOCK_DIVIDER_1);

        UCS_initClockSignal(
                UCS_ACLK,
                UCS_REFOCLK_SELECT,
                UCS_CLOCK_DIVIDER_1);

        UCS_initFLLSettle(
                mclkFreq / 1000,
                mclkFreq / 32768);
}
//Released_Version_5_20_06_03
