/******************************************************************************/
/* Vector Redirection FILE FOR MSPBoot BOOTLOADER USING MSP430F5659  */
/* File generated with MSPBootVecRedGen.pl on 02-19-2019 */
/*----------------------------------------------------------------------------*/

//
// Include files
//
#include <stdint.h>
#include "msp430.h"
#include "TI_MSPBoot_Common.h"
#include "TI_MSPBoot_AppMgr.h"

//
//  External variables from linker file
//
extern uint16_t _Appl_Proxy_Vector_Start[];  /* Proxy table address */

//
//  Macros and definitions
//
/* Value written to unused vectors */
#define UNUSED                  (0x3FFF)       
/*! Macro used to calculate address of vector in Application Proxy Table */
#define APP_PROXY_VECTOR(x)     ((uint16_t)&_Appl_Proxy_Vector_Start[x*2])

//
//  Constant table
//
/*! MSPBoot Vector Table: It's fixed since it can't be erased and modified.
 *  Points to a proxy vector table in Application area*/
#pragma DATA_SECTION(Vector_Table, ".BOOT_VECTOR_TABLE")
#pragma RETAIN(Vector_Table)
const uint16_t Vector_Table[] =
{
     UNUSED,                                     // FF80 = unused
     UNUSED,                                     // FF82 = unused
     UNUSED,                                     // FF84 = unused
     UNUSED,                                     // FF86 = unused
     UNUSED,                                     // FF88 = unused
     UNUSED,                                     // FF8A = unused
     UNUSED,                                     // FF8C = unused
     UNUSED,                                     // FF8E = unused
     UNUSED,                                     // FF90 = unused
     UNUSED,                                     // FF92 = unused
     UNUSED,                                     // FF94 = unused
     UNUSED,                                     // FF96 = unused
     UNUSED,                                     // FF98 = unused
     UNUSED,                                     // FF9A = unused
     UNUSED,                                     // FF9C = unused
     UNUSED,                                     // FF9E = unused
     UNUSED,                                     // FFA0 = unused
     UNUSED,                                     // FFA2 = unused
     UNUSED,                                     // FFA4 = unused
     UNUSED,                                     // FFA6 = unused
     UNUSED,                                     // FFA8 = unused
     UNUSED,                                     // FFAA = unused
     UNUSED,                                     // FFAC = unused
     UNUSED,                                     // FFAE = unused
     UNUSED,                                     // FFB0 = unused
     UNUSED,                                     // FFB2 = unused
     UNUSED,                                     // FFB4 = unused
     UNUSED,                                     // FFB6 = unused
     UNUSED,                                     // FFB8 = unused
     UNUSED,                                     // FFBA = unused
     UNUSED,                                     // FFBC = unused
     UNUSED,                                     // FFBE = unused
     UNUSED,                                     // FFC0 = unused
     UNUSED,                                     // FFC2 = unused
     UNUSED,                                     // FFC4 = unused
     APP_PROXY_VECTOR(0),                        // FFC6 =  USCI_B2     
     APP_PROXY_VECTOR(1),                        // FFC8 =  USCI_A2     
     APP_PROXY_VECTOR(2),                        // FFCA =  PORT4       
     APP_PROXY_VECTOR(3),                        // FFCC =  PORT3       
     APP_PROXY_VECTOR(4),                        // FFCE =  TIMER2_A1   
     APP_PROXY_VECTOR(5),                        // FFD0 =  TIMER2_A0   
     APP_PROXY_VECTOR(6),                        // FFD2 =  DAC12       
     APP_PROXY_VECTOR(7),                        // FFD4 =  RTC         
     UNUSED,                                     // FFD6 = unused
     APP_PROXY_VECTOR(8),                        // FFD8 =  PORT2       
     APP_PROXY_VECTOR(9),                        // FFDA =  USCI_B1     
     APP_PROXY_VECTOR(10),                        // FFDC =  USCI_A1     
     APP_PROXY_VECTOR(11),                        // FFDE =  PORT1       
     APP_PROXY_VECTOR(12),                        // FFE0 =  TIMER1_A1   
     APP_PROXY_VECTOR(13),                        // FFE2 =  TIMER1_A0   
     APP_PROXY_VECTOR(14),                        // FFE4 =  DMA         
     APP_PROXY_VECTOR(15),                        // FFE6 =  USB_UBM     
     APP_PROXY_VECTOR(16),                        // FFE8 =  TIMER0_A1   
     APP_PROXY_VECTOR(17),                        // FFEA =  TIMER0_A0   
     APP_PROXY_VECTOR(18),                        // FFEC =  ADC12       
     APP_PROXY_VECTOR(19),                        // FFEE =  USCI_B0     
     APP_PROXY_VECTOR(20),                        // FFF0 =  USCI_A0     
     APP_PROXY_VECTOR(21),                        // FFF2 =  WDT         
     APP_PROXY_VECTOR(22),                        // FFF4 =  TIMER0_B1   
     APP_PROXY_VECTOR(23),                        // FFF6 =  TIMER0_B0   
     APP_PROXY_VECTOR(24),                        // FFF8 =  COMP_B      
     APP_PROXY_VECTOR(25),                        // FFFA =  UNMI        
     APP_PROXY_VECTOR(26),                        // FFFC =  SYSNMI      
};
