//    // SDI-12 interface
//    GPIO_setAsOutputPin (GPIO_PORT_P3, GPIO_PIN7);
//    GPIO_setOutputHighOnPin ( GPIO_PORT_P3, GPIO_PIN7 );    //Apagado a valor alto
//
//    // Flash Memory
//    GPIO_setAsOutputPin (GPIO_PORT_P5, GPIO_PIN3);
//    GPIO_setOutputHighOnPin ( GPIO_PORT_P5, GPIO_PIN3 );    //Apagado a valor alto
/*
 *  ======== fatsd.c ========
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

//Para reconocer cosas del fichero .cfg
#include <xdc/cfg/global.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/SDSPI.h>
#include <ti/drivers/UART.h>

/* Example/Board Header files */
#include "Board.h"

#include <driverlib.h>

#define GPRS_RST_BEGIN   0
#define GPRS_RST_END     1

uint8_t indexgprs;
uint8_t bytes[60];
uint8_t anterior;
uint8_t n;

Void taskFxn()
{
    static uint8_t gprsStatus = GPRS_RST_BEGIN;

    while(1)
    {
        Semaphore_pend(LogDataSem, 10000);

        switch(gprsStatus){
            case GPRS_RST_BEGIN:
                indexgprs = n = anterior = 0;
                memset(bytes, 0, 60);

                System_printf("Init GPRS\n");
                System_printf("RST begin\n");
                System_flush();

                //Reset the GPRS module
                GPIO_setOutputLowOnPin ( GPIO_PORT_P4, GPIO_PIN7 );
                Semaphore_pend(LogDataSem, 200);
                GPIO_setOutputHighOnPin ( GPIO_PORT_P4, GPIO_PIN7 );
                //Semaphore_pend(LogDataSem, BIOS_WAIT_FOREVER);
                Semaphore_pend(LogDataSem, 5000);

                //System_printf("3 responses received\n");
                System_printf("Timeout ends\n");
                System_flush();

                //I write a separator character in the terminal
                EUSCI_A_UART_transmitData(EUSCI_A3_BASE, '*');
                EUSCI_A_UART_transmitData(EUSCI_A3_BASE, '\r');
                EUSCI_A_UART_transmitData(EUSCI_A3_BASE, '\n');

                //Printing the response
                uint8_t i;
                for(i=0;i<indexgprs;i++){
                    EUSCI_A_UART_transmitData(EUSCI_A3_BASE, bytes[i]);
                }
                while(EUSCI_A_UART_queryStatusFlags(EUSCI_A3_BASE, EUSCI_A_UART_BUSY));

                indexgprs = n = anterior = 0;
                memset(bytes, 0, 60);
                break;
        }
    }
}

/*
 *  ======== main ========
 */
int main()
{
    /* Call MSP-EXP430FR5994 board init functions */
    //Board_initGeneral();
    Board_initGPIO();

    /* Turn off user LEDs */
    GPIO_write(Board_LED0, Board_LED_OFF);
    GPIO_write(Board_LED1, Board_LED_OFF);

    //GPRS SIM 800 begin
    //RST PIN GPRS
    GPIO_setAsOutputPin (GPIO_PORT_P4, GPIO_PIN7);
    GPIO_setOutputHighOnPin ( GPIO_PORT_P4, GPIO_PIN7 );

    //UART for interchanging data with the GPRS
    GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P2, GPIO_PIN0, GPIO_SECONDARY_MODULE_FUNCTION);
    GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P2, GPIO_PIN1, GPIO_SECONDARY_MODULE_FUNCTION);

    //UART for sending data to the computer...reception is not used
    GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P6, GPIO_PIN0, GPIO_PRIMARY_MODULE_FUNCTION);
    GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P6, GPIO_PIN1, GPIO_PRIMARY_MODULE_FUNCTION);

    Board_initGeneral();

    EUSCI_A_UART_initParam param = {0};
    param.selectClockSource = EUSCI_A_UART_CLOCKSOURCE_SMCLK;
    param.clockPrescalar = 52;
    param.firstModReg = 1;
    param.secondModReg = 0x49;
    param.parity = EUSCI_A_UART_NO_PARITY;
    param.msborLsbFirst = EUSCI_A_UART_LSB_FIRST;
    param.numberofStopBits = EUSCI_A_UART_ONE_STOP_BIT;
    param.uartMode = EUSCI_A_UART_MODE;
    param.overSampling = EUSCI_A_UART_OVERSAMPLING_BAUDRATE_GENERATION;

    if(STATUS_FAIL == EUSCI_A_UART_init(EUSCI_A0_BASE, &param)){
        System_abort("EUSCI_A0_BASE error\0");
    }

    EUSCI_A_UART_enable(EUSCI_A0_BASE);

    EUSCI_A_UART_clearInterrupt(EUSCI_A0_BASE,
                                    EUSCI_A_UART_RECEIVE_INTERRUPT);
    // Enable USCI_A0 RX interrupt
    EUSCI_A_UART_enableInterrupt(EUSCI_A0_BASE,
                                     EUSCI_A_UART_RECEIVE_INTERRUPT); // Enable interrupt

    if(STATUS_FAIL == EUSCI_A_UART_init(EUSCI_A3_BASE, &param)){
        System_abort("EUSCI_A3_BASE error\0");
    }

    EUSCI_A_UART_enable(EUSCI_A3_BASE);
    //GPRS SIM 800 end

    System_printf("Starting the datalogger example\n");
    System_flush();

    /* Start BIOS */
    BIOS_start();

    return (0);
}

//ISR for receiving char of the EUSCI_A0, where the GPRS is connected
void GPRS_ISR()
{
    uint8_t caracter;
    uint16_t isrStatus = EUSCI_A_UART_getInterruptStatus(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
    EUSCI_A_UART_clearInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);

    if(isrStatus & EUSCI_A_UART_RECEIVE_INTERRUPT){
        caracter = EUSCI_A_UART_receiveData(EUSCI_A0_BASE);
        //Echo the received character to the computer
        EUSCI_A_UART_transmitData(EUSCI_A3_BASE, caracter);
        bytes[indexgprs] = caracter;
        indexgprs++;
        //GPRS responses start and end with \r\n
// This part have been commented because it fails many times
//        if((anterior == '\r') && (caracter == '\n')){
//            n++;
//            //After reset the module 3 responses are received.
//            if(n == 6){
//                Semaphore_post(LogDataSem);
//            }
//        }
//        anterior = caracter;
    }
}
