/*
 * ======== Standard MSP430 includes ========
 */
#include <msp430.h>

/*
 * ======== Grace related includes ========
 */
#include <ti/mcu/msp430/Grace.h>

unsigned long Frequency = 16000;
unsigned long prevFrequency = 0;
unsigned long DutyCycle = 8000;
unsigned long prevDutyCycle = 0;

/*
 *  ======== main ========
 */
void main(void)
{
    Grace_init();                   // Activate Grace-generated configuration
    
    while(1)
    {
		if( prevFrequency != Frequency )
		{
			TA0CCR0 = Frequency;	// TA0CCR0, Timer_A Capture/Compare Register 0
			prevFrequency = Frequency;
		}

		if( prevDutyCycle != DutyCycle )
		{
			TA0CCR1 = DutyCycle;	// TA0CCR1, Timer_A Capture/Compare Register 1
			prevDutyCycle = DutyCycle;
		}
    }
}
