#include <msp430.h>
#include <driverlib.h>
#include <spi.h>

#define CALADC_15V_30C  *((unsigned int *)0x1A1A)                 // Temperature Sensor Calibration-30 C
                                                                  // See device datasheet for TLV table memory mapping
#define CALADC_15V_85C  *((unsigned int *)0x1A1C)                 // Temperature Sensor Calibration-85 C

volatile float temp;
volatile float IntDegC;

unsigned int ref30 = 0;
unsigned int ref85 = 0;

#pragma PERSISTENT(FRAMval)
unsigned char FRAMval[2] = {0x55, 0x66};

unsigned char val1[2] = {0x11, 0x22};
unsigned char val2[2] = {0x33, 0x44};
unsigned char val3[1] = {0x55};
unsigned char val4[4] = {0x66, 0x77, 0x88, 0x99};
unsigned char val5[3] = {0x11, 0x22, 0x33};
unsigned char val6[1] = {0x44};
unsigned char val7[1] = {0x55};

unsigned char payload1[4] = {0x11, 0x11, 0x11, 0x11};
unsigned char payload2[4] = {0x11, 0x11, 0x11, 0x11};
unsigned char payload3[4] = {0x11, 0x11, 0x11, 0x11};
unsigned char payload4[4] = {0x11, 0x11, 0x11, 0x11};

unsigned char *payload_ptr;

int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;               // Stop watchdog timer

    CSCTL1 &= ~(DCORSEL0 | DCORSEL1 | DCORSEL2);
    CSCTL1 |= (DCORSEL1 | DCORSEL2);

    CSCTL2 &= ~(FLLD | FLLD_0);
    CSCTL2 |= FLLN;

    CSCTL3 |= SELREF0;

    CSCTL5 |= DIVS_1;

    PMMCTL0_H = PMMPW_H;
    PMMCTL0_L &= ~(SVSHE);
    PMMCTL0_H = 0;

    P1OUT &= ~BIT0;
    P1DIR |= BIT0;

    P1OUT &= ~BIT1;
    P1DIR |= BIT1;

    P1DIR &= ~BIT2;

    P1IES &= ~BIT3;
    P1IE  |= BIT3;
    P1IFG &= ~BIT3;

    P1OUT &= ~BIT4;
    P1DIR |= BIT4;

    initSPI();

    P2DIR &= ~(BIT0 | BIT1);

    P2OUT &= ~(BIT2 | BIT3 | BIT4 | BIT5 | BIT6 | BIT7);
    P2DIR |= (BIT2 | BIT3 | BIT4 | BIT5 | BIT6 | BIT7);

    PM5CTL0 &= ~LOCKLPM5;

    if((P1IN & BIT2) == BIT2)
    {
        ref30 = CALADC_15V_30C;
        ref85 = CALADC_15V_85C;
    }

    P1DIR |= BIT2;
    P1OUT |= BIT2;

    switch(P2IN & 0x03)
    {
        case 0x01:  payload_ptr = payload1;
                    break;
        case 0x02:  payload_ptr = payload2;
                    break;
        case 0x03:  payload_ptr = payload3;
                    break;
        default:    payload_ptr = payload4;
                    break;
    }

    P1OUT |= BIT4;

    SPIWriteReg(0x11, val1[0]);
    SPIWriteReg(0x11, val1[1]);
    SPIWriteReg(0x11, 0x01);
    SPIWriteRegN(2, 0x11, FRAMval);
    SPIWriteReg(0x11, 0x00);

    SPIWriteRegN(2, 0x11, val2);
    SPIWriteReg(0x11, val3[0]);
    SPIWriteRegN(4, 0x11, val4);
    SPIWriteRegN(3, 0x11, val5);
    SPIWriteReg(0x11, val6[0]);
    SPIWriteRegN(4, 0x11, payload_ptr);
    SPIWriteReg(0x11, val6[0]);

    P1OUT &= ~BIT4;

    P1OUT &= ~BIT0;

    P1SEL0 &= ~BIT7;
    P1OUT &= ~BIT7;

    P1OUT &= ~BIT2;

    while(1);
}


// Port 1 interrupt service routine
#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector=PORT1_VECTOR
__interrupt void Port_1(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(PORT1_VECTOR))) Port_1 (void)
#else
#error Compiler not supported!
#endif
{
    P1IFG &= ~BIT3;                         // Clear P1.3 IFG
    __bic_SR_register_on_exit(LPM4_bits);   // Exit LPM4

}

