#include "spi.h"

void initSPI(void)
{
    P1SEL0 |= BIT5 | BIT6 | BIT7;

    UCA0CTLW0 |= UCSWRST;

    UCA0CTLW0 |= UCMST|UCSYNC|UCCKPH|UCMSB;

    UCA0CTLW0 |= UCSSEL__SMCLK;
    UCA0BR0 = 0x00;
    UCA0BR1 = 0;
    UCA0MCTLW = 0;

    UCA0CTLW0 &= ~UCSWRST;
}


void SPIWriteRegN (unsigned char number, unsigned char addr, unsigned char *data)
{
    unsigned char i = 0;

    P1OUT &= ~BIT0;

    UCA0TXBUF = addr;
    while((UCA0STATW & UCBUSY));

    for(i=number; i>0; i--)
    {
        UCA0TXBUF = data[number-i];
        while((UCA0STATW & UCBUSY));
    }

    P1OUT |= BIT0;
}

void SPIWriteReg (unsigned char addr, unsigned char data)
{
    P1OUT &= ~BIT0;

    UCA0TXBUF = addr;
    while((UCA0STATW & UCBUSY));

    UCA0TXBUF = data;
    while((UCA0STATW & UCBUSY));

    P1OUT |= BIT0;
}

unsigned char SPIReadReg (unsigned char addr)
{
    unsigned char i = 0;

    P1OUT &= ~BIT0;

    UCA0TXBUF = addr | 0x80;
    while(UCA0STATW & UCBUSY);

    UCA0TXBUF = 0x00;
    while(UCA0STATW & UCBUSY);

    P1OUT |= BIT0;

    return UCA0RXBUF;
}
