#include <msp430.h>
#include <stdint.h>
#include <string.h>

#include "timermgr.h"

struct BlinkLEDData
{
    struct TimerMgr* timermgr;
    uint16_t delay_counter;
};


void BlinkLED( void* Data )
{
    struct BlinkLEDData* data = ( struct BlinkLEDData* ) Data;

    P1OUT ^= BIT2;

    //increase the delay a short bit
//    data->delay_counter += 100;
    uint16_t temp = data->delay_counter;
    temp = temp + 100;
    data->delay_counter = temp;

    //Blink again after one second
    InsertTimerTask( data->timermgr, BlinkLED, data->timermgr, temp /* data->delay_counter */ );
}



/**
 * main.c
 */
int main(void)
{
    struct BlinkLEDData data = {0};

    WDTCTL = WDTPW + WDTHOLD;                 // Stop WDT
    P1DIR |= BIT2;                            // P1.2 output
    CCTL0 = CCIE;                             // CCR0 interrupt enabled
    CCR0 = 100;                             // approx. 1 uS Period
    TACTL = TASSEL_2 + MC_2;                  // SMCLK, up mode

    data.timermgr = InitTimerMgr( 1100000 );
    data.delay_counter = 100;

    InsertTimerTask( data.timermgr, BlinkLED, &data, 10 );

    __bis_SR_register( GIE );       // Enter interrupt

    while(1)
    {
        DoTick( data.timermgr );
        DoTimer( data.timermgr );

        __bis_SR_register( LPM0_bits );       // Enter LPM0 (w/ interrupt set above)
    }
}



// Timer A0 interrupt service routine
#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector=TIMER0_A0_VECTOR
__interrupt void Timer_A (void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(TIMER0_A0_VECTOR))) Timer_A (void)
#else
#error Compiler not supported!
#endif
{
    TACTL &= ~MC_2;                       //Stop the timer
    TA0R = 0;                             //Reset the timer count
    TACTL |= MC_2;                        //Restart the timer
    __bic_SR_register_on_exit( LPM0_bits );       // Exit LPM0
    TACTL &= ~TAIFG;
}
