/* --COPYRIGHT--,BSD
 * Copyright (c) 2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

//#############################################################################
//
//! \file   emReactivePowerIIRCoeff.h
//!
//! \brief  This file contains EM Reactive Power Coefficients
//!         
//
//!  Group:          MSP Embedded Software Development
//!  Target Device:  MSP430F67791A
//
//  (C) Copyright 2017, Texas Instruments, Inc.
//#############################################################################
// TI Release: MSP430_ENERGY_MEASUREMENT 
// Release Date: 29Jul2020
//#############################################################################

#ifndef _EMREACTIVEPOWERIIRCOEFF_H_
#define _EMREACTIVEPOWERIIRCOEFF_H_
// IIR G Constant Table
// Samp. Freq=4096Hz, Min Freq=48Hz, Max Freq=52Hz, Resolution=0.04Hz
#define	IIR_COEFF_MIN_FREQ		4800
#define	IIR_COEFF_MAX_FREQ		5200
#define	IIR_COEFF_TABLE_LEN		101
#define	IIR_COEFF_SHIFT			2

const _iq30 G_CONSTANT[IIR_COEFF_TABLE_LEN] ={
	0xC48C0AED, /* Freq 48.00 */
	0xC48CFAA5, /* Freq 48.04 */
	0xC48DEA59, /* Freq 48.08 */
	0xC48EDA0A, /* Freq 48.12 */
	0xC48FC9B7, /* Freq 48.16 */
	0xC490B960, /* Freq 48.20 */
	0xC491A907, /* Freq 48.24 */
	0xC49298A9, /* Freq 48.28 */
	0xC4938848, /* Freq 48.32 */
	0xC49477E4, /* Freq 48.36 */
	0xC495677C, /* Freq 48.40 */
	0xC4965711, /* Freq 48.44 */
	0xC49746A2, /* Freq 48.48 */
	0xC4983630, /* Freq 48.52 */
	0xC49925BA, /* Freq 48.56 */
	0xC49A1540, /* Freq 48.60 */
	0xC49B04C4, /* Freq 48.64 */
	0xC49BF443, /* Freq 48.68 */
	0xC49CE3C0, /* Freq 48.72 */
	0xC49DD338, /* Freq 48.76 */
	0xC49EC2AE, /* Freq 48.80 */
	0xC49FB21F, /* Freq 48.84 */
	0xC4A0A18E, /* Freq 48.88 */
	0xC4A190F8, /* Freq 48.92 */
	0xC4A28060, /* Freq 48.96 */
	0xC4A36FC3, /* Freq 49.00 */
	0xC4A45F24, /* Freq 49.04 */
	0xC4A54E80, /* Freq 49.08 */
	0xC4A63DDA, /* Freq 49.12 */
	0xC4A72D30, /* Freq 49.16 */
	0xC4A81C82, /* Freq 49.20 */
	0xC4A90BD1, /* Freq 49.24 */
	0xC4A9FB1C, /* Freq 49.28 */
	0xC4AAEA64, /* Freq 49.32 */
	0xC4ABD9A9, /* Freq 49.36 */
	0xC4ACC8E9, /* Freq 49.40 */
	0xC4ADB827, /* Freq 49.44 */
	0xC4AEA761, /* Freq 49.48 */
	0xC4AF9697, /* Freq 49.52 */
	0xC4B085CA, /* Freq 49.56 */
	0xC4B174FA, /* Freq 49.60 */
	0xC4B26426, /* Freq 49.64 */
	0xC4B3534E, /* Freq 49.68 */
	0xC4B44273, /* Freq 49.72 */
	0xC4B53195, /* Freq 49.76 */
	0xC4B620B3, /* Freq 49.80 */
	0xC4B70FCE, /* Freq 49.84 */
	0xC4B7FEE5, /* Freq 49.88 */
	0xC4B8EDF9, /* Freq 49.92 */
	0xC4B9DD09, /* Freq 49.96 */
	0xC4BACC16, /* Freq 50.00 */
	0xC4BBBB1F, /* Freq 50.04 */
	0xC4BCAA25, /* Freq 50.08 */
	0xC4BD9927, /* Freq 50.12 */
	0xC4BE8826, /* Freq 50.16 */
	0xC4BF7721, /* Freq 50.20 */
	0xC4C06619, /* Freq 50.24 */
	0xC4C1550D, /* Freq 50.28 */
	0xC4C243FE, /* Freq 50.32 */
	0xC4C332EC, /* Freq 50.36 */
	0xC4C421D6, /* Freq 50.40 */
	0xC4C510BC, /* Freq 50.44 */
	0xC4C5FF9F, /* Freq 50.48 */
	0xC4C6EE7F, /* Freq 50.52 */
	0xC4C7DD5B, /* Freq 50.56 */
	0xC4C8CC33, /* Freq 50.60 */
	0xC4C9BB08, /* Freq 50.64 */
	0xC4CAA9DA, /* Freq 50.68 */
	0xC4CB98A8, /* Freq 50.72 */
	0xC4CC8773, /* Freq 50.76 */
	0xC4CD763A, /* Freq 50.80 */
	0xC4CE64FE, /* Freq 50.84 */
	0xC4CF53BE, /* Freq 50.88 */
	0xC4D0427B, /* Freq 50.92 */
	0xC4D13134, /* Freq 50.96 */
	0xC4D21FEA, /* Freq 51.00 */
	0xC4D30E9D, /* Freq 51.04 */
	0xC4D3FD4C, /* Freq 51.08 */
	0xC4D4EBF7, /* Freq 51.12 */
	0xC4D5DA9F, /* Freq 51.16 */
	0xC4D6C944, /* Freq 51.20 */
	0xC4D7B7E5, /* Freq 51.24 */
	0xC4D8A683, /* Freq 51.28 */
	0xC4D9951D, /* Freq 51.32 */
	0xC4DA83B4, /* Freq 51.36 */
	0xC4DB7247, /* Freq 51.40 */
	0xC4DC60D7, /* Freq 51.44 */
	0xC4DD4F63, /* Freq 51.48 */
	0xC4DE3DEC, /* Freq 51.52 */
	0xC4DF2C71, /* Freq 51.56 */
	0xC4E01AF3, /* Freq 51.60 */
	0xC4E10972, /* Freq 51.64 */
	0xC4E1F7ED, /* Freq 51.68 */
	0xC4E2E664, /* Freq 51.72 */
	0xC4E3D4D8, /* Freq 51.76 */
	0xC4E4C349, /* Freq 51.80 */
	0xC4E5B1B6, /* Freq 51.84 */
	0xC4E6A020, /* Freq 51.88 */
	0xC4E78E86, /* Freq 51.92 */
	0xC4E87CE9, /* Freq 51.96 */
	0xC4E96B48, /* Freq 52.00 */
};
#endif
