/* --COPYRIGHT--,BSD
 * Copyright (c) 2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

//#############################################################################
//
//! \file   main.c
//!
//! \brief  Energy Measurement demo
//!
//!  Group:          MSP Embedded Software Development
//!  Target Device:  MSP430F67791A
//!
//!  (C) Copyright 2017, Texas Instruments, Inc.
//#############################################################################
// TI Release: MSP430_ENERGY_MEASUREMENT 
// Release Date: 29Jul2020
//#############################################################################

#include <stdint.h>
#include "hal.h"
#include "hmi.h"
#include "EMLibGUIApp.h"
#include "EM_userConfig.h"

void display_number(char display_no, long valuea);
void display_char(char display_no, char char_1, char char_2, char char_3,
                  char char_4);
void display_scan();
unsigned char reverse(unsigned char b);
static void MSP_GUI_System_setup(void);

#define CHAR_BITS  8
#define INT_BITS  ( sizeof(int) * CHAR_BITS)



unsigned char dis_tab[] = { 0xc0, //code for 0         add 0x00        00111111b
        0xf9,  //code for 1         add 0x01        00000110b
        0xa4,  //code for 2         add 0x02        01011011b
        0xb0,  //code for 3         add 0x03        01001111b
        0x99,  //code for 4         add 0x04        01100110b
        0x92,  //code for 5         add 0x05        01101101b
        0x82,  //code for 6         add 0x06        01111101b
        0xf8,  //code for 7         add 0x07        00000111b
        0x80,  //code for 8         add 0x08        01111111b
        0x90,  //code for 9         add 0x09        01101111b
        0xab,  //code for n         add 0x0a        01010100b
        0x86,  //code for E         add 0x0b        01111001b
        0x8c,  //code for P         add 0x0c        01110011b
        0x83,  //code for b         add 0x0d        01111100b
        0xaf,  //code for r         add 0x0e        01010000b
        0xaa,  //code for m         add 0x0f        01010100b
        0xff,  //code for blank     add 0x10        00000000b
        0xbf,  //code for -         add 0x11        01000000b
        0x88,  //code for A         add 0x12        01110111b
        0xc7,  //code for L         add 0x13        00111000b
        0xc1,  //code for U         add 0x14        00111110b
        0xa1,  //code for d         add 0x15        01011110b
        0xc6,  //code for C         add 0x16        00111001b
        0x87,  //code for t         add 0x17        01111000b
        0x89,  //code for H         add 0x18        01110110b
        0x91,  //code for y         add 0x19        01101110b
        0x8e,  //code for f         add 0x1a        00000000b
        0xa3,  //code for o         add 0x1b        00000000b
        ~(0x3d), //code for G         add 0x1c        00000000b
        /* ~(0x1c)*/0xc1,  //code for v         add 0x1d        00000000b
        ~(0x30), //code for i         add 0x1e        00000000b
        0x8d,  //code for k         add 0x1f        00000000b
        0x40,  //code for 0.        add 0x20        00111111b
        0x79,  //code for 1.        add 0x21        00000110b
        0x24,  //code for 2.        add 0x22        01011011b
        0x30,  //code for 3.        add 0x23        01001111b
        0x19,  //code for 4.        add 0x24        01100110b
        0x12,  //code for 5.        add 0x25        01101101b
        0x02,  //code for 6.        add 0x26        01111101b
        0x78,  //code for 7.        add 0x27        00000111b
        0x00,  //code for 8.        add 0x28        01111111b
        0x10,  //code for 9.        add 0x29        01101111b
        0x3b,  //code for h         add 0x2a        00101110b
        0x8f,  //code for |-        add 0x2b
        0x98,  //code for q         add 0x2c
        0XE2,   //code for w        add 0x2d
        0xE1,  //CODE FOR J         add 0x2e        00011111b
        0x07,  //code for t.        add 0x2f       01111000b
        0x7F,   //code for BLANK_DP add 0x30
        };

unsigned int dispaly_scan = 0, dispaly_select = 0;
#define h 100
char disp_char_1[12] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char disp_char_2[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };
long a = 123;

/*** FUNCTIONS ***/
static void MSP_GUI_System_setup(void);

//*****************************************************************************
//
//! In this software main will call a few initialization routines and then it
//!  will jump to the main loop for the Energy Measurement Library.
//!
//! \return none
//
// *****************************************************************************
void main(void)
{
	MSP_GUI_System_setup();
	
	// Initialize the EM Lib to default settings and start conversions
	EMLibGUIApp_Init();
	
	// This is the Design Centers Main Loop
	EMLibGUIApp_Engine();
}

//*****************************************************************************
//
//! This Function Initializes all the ports on the MCU 
//!
//! \return none
//
// *****************************************************************************
static void MSP_GUI_System_setup(void)
{
	// Stop WDT
    WDTCTL = WDTPW + WDTHOLD;
	
    P2DIR |= 0xff;
            P6DIR |= 0xff;
            P4DIR |= 0xff;
            P5DIR |= 0x00;

            // Setup TA0
            TA0CCTL0 = CCIE;                        // CCR0 interrupt enabled
            TA0CCR0 = 1200;
            TA0CTL = TASSEL_2 | MC_1 | TACLR;       // SMCLK, upmode, clear TAR

            //        // Setup TA0
            //        TA1CCTL0 = CCIE;                        // CCR0 interrupt enabled
            //        TA1CCR0 = 10000;
            //        TA1CTL = TASSEL_2 | MC_1 | TACLR;       // SMCLK, upmode, clear TAR

    // Initializes the basic functionality of the system
    hal_system_Init();

    // Initialize interfaces to user including GUI
    HMI_Init();
}


// Timer0_A0 interrupt service routine
#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector=TIMER0_A0_VECTOR
__interrupt void TIMER0_A0_ISR(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(TIMER0_A0_VECTOR))) TIMER0_A0_ISR (void)
#else
#error Compiler not supported!
#endif
{
    display_scan();

}

//// Timer0_A0 interrupt service routine
//#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
//#pragma vector=TIMER1_A0_VECTOR
//__interrupt void TIMER1_A0_ISR(void)
//#elif defined(__GNUC__)
//void __attribute__ ((interrupt(TIMER1_A0_VECTOR))) TIMER1_A0_ISR (void)
//#else
//#error Compiler not supported!
//#endif
//{
//
//}

void display_scan()
{
    //    P6OUT = 0x00;

    if (++dispaly_scan >= 8)
    {
        dispaly_scan = 0;
        //        dispaly_select = 2;
        if (++dispaly_select >= 2)
            dispaly_select = 0;
    }
    P4OUT = 0xff;
    P2OUT = 0xff;
    switch (dispaly_select)
    {
    case 0:
        P6OUT |= BIT5;
        P6OUT &= ~BIT4;
        P6OUT |= BIT3;
        break;
    case 1:
        P6OUT &= ~BIT5;
        P6OUT |= BIT4;
        P6OUT &= ~BIT3;
        break;
    }

    switch (dispaly_scan)
    {
    case 0:
        P6OUT &= ~BIT2;
        P6OUT &= ~BIT1;
        P6OUT &= ~BIT0;
        break;
    case 1:
        P6OUT &= ~BIT2;
        P6OUT &= ~BIT1;
        P6OUT |= BIT0;
        break;
    case 2:
        P6OUT &= ~BIT2;
        P6OUT |= BIT1;
        P6OUT &= ~BIT0;
        break;
    case 3:
        P6OUT &= ~BIT2;
        P6OUT |= BIT1;
        P6OUT |= BIT0;
        break;

    case 4:
        P6OUT |= BIT2;
        P6OUT &= ~BIT1;
        P6OUT &= ~BIT0;
        break;
    case 5:
        P6OUT |= BIT2;
        P6OUT &= ~BIT1;
        P6OUT |= BIT0;
        break;
    case 6:
        P6OUT |= BIT2;
        P6OUT |= BIT1;
        P6OUT &= ~BIT0;
        break;
    case 7:
        P6OUT |= BIT2;
        P6OUT |= BIT1;
        P6OUT |= BIT0;
        break;
    }

    if ((dispaly_select == 0) || (dispaly_select == 2) && (dispaly_scan > 3))
    {
        P2OUT = reverse(dis_tab[disp_char_1[dispaly_scan]]);
        P4OUT = dis_tab[disp_char_2[dispaly_scan]];
    }
    else if (dispaly_select == 1 && (dispaly_scan == 0))
    {
        P4OUT = dis_tab[disp_char_2[dispaly_scan]];
    }
    else if ((dispaly_select == 1) && (dispaly_scan < 5))
    {
        P2OUT = reverse(dis_tab[disp_char_1[dispaly_scan + 7]]);
    }
    else if (dispaly_select == 1)
    {
        P4OUT = dis_tab[disp_char_2[dispaly_scan - 4]];
    }
}

unsigned char reverse(unsigned char b)
{
    b = (b & 0xF0) >> 4 | (b & 0x0F) << 4;
    b = (b & 0xCC) >> 2 | (b & 0x33) << 2;
    b = (b & 0xAA) >> 1 | (b & 0x55) << 1;
    return b;
}

char nagative_value=0;
void display_number(char display_no, long value)
{
//    long value = 1111;
    nagative_value=0;

    if(value<0)
    {
        value=value*-1;
        nagative_value=1;
    }

    if (display_no == 1)
    {
        disp_char_1[7] = value % 10;
        value /= 10;
        disp_char_1[6] = value % 10;
        value /= 10;
        disp_char_1[5] = value % 10;
        value /= 10;
        disp_char_1[4] = value % 10;
        value /= 10;
        disp_char_1[0] = value % 10;
        value /= 10;
        disp_char_1[3] = value % 10;
        value /= 10;
        disp_char_1[2] = value % 10;
        value /= 10;
        if(nagative_value==1)disp_char_1[1]=0x11;
        else disp_char_1[1] = value % 10;
        value /= 10;


    }


    if (display_no == 2)
    {
        disp_char_1[11] = value % 10;
        value /= 10;
        disp_char_1[10] = value % 10;
        value /= 10;
        disp_char_1[9] = value % 10;
        value /= 10;
        if(nagative_value==1)disp_char_1[8]=0x11;
        else disp_char_1[8] = value % 10;
    }
    if (display_no == 3)
    {
        disp_char_2[0] = value % 10;
        value /= 10;
        disp_char_2[1] = value % 10;
        value /= 10;
        disp_char_2[3] = value % 10;
        value /= 10;
        if(nagative_value==1)disp_char_2[2]=0x11;
        else disp_char_2[2] = value % 10;
    }
    if (display_no == 4)
    {
        disp_char_2[7] = value % 10;
        value /= 10;
        disp_char_2[6] = value % 10;
        value /= 10;
        disp_char_2[5] = value % 10;
        value /= 10;
        if(nagative_value==1)disp_char_2[4]=0x11;
        else disp_char_2[4] = value % 10;
    }
}

void display_char(char display_no, char char_1, char char_2, char char_3,
                  char char_4)
{
    if (display_no == 1)
    {
        disp_char_1[0] = char_4;
        disp_char_1[3] = char_3;
        disp_char_1[2] = char_2;
        disp_char_1[1] = char_1;
    }
    if (display_no == 2)
    {
        disp_char_1[7] = char_4;
        disp_char_1[6] = char_3;
        disp_char_1[5] = char_2;
        disp_char_1[4] = char_1;

    }
    if (display_no == 3)
    {
        disp_char_1[11] = char_4;
        disp_char_1[10] = char_3;
        disp_char_1[9] = char_2;
        disp_char_1[8] = char_1;

    }
    if (display_no == 4)
    {
        disp_char_2[0] = char_4;
        disp_char_2[1] = char_3;
        disp_char_2[3] = char_2;
        disp_char_2[2] = char_1;

    }
    if (display_no == 5)
    {
        disp_char_2[7] = char_4;
        disp_char_2[6] = char_3;
        disp_char_2[5] = char_2;
        disp_char_2[4] = char_1;

    }

}
