/*
 * WISE_USW.c
 *
 *  Created on: 23 jun. 2017
 *      Author: juanantonio
 */

#include "WISE_DEBUG.h"
#include <driverlib.h>
#include <string.h>

//******************************************************
// Configuring the UART for debugging
// EUSCI_A1. Tx: P2.5. 115200bps
//******************************************************
int WISE_DebugInit(void){
    int ret = 1;
    GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P2, GPIO_PIN5, GPIO_SECONDARY_MODULE_FUNCTION);

    EUSCI_A_UART_initParam param = {0};
    param.selectClockSource = EUSCI_A_UART_CLOCKSOURCE_SMCLK;
    //param.clockPrescalar = 4;
    //param.firstModReg = 5;
    //param.secondModReg = 85;
    param.clockPrescalar = 52;
    param.firstModReg = 1;
    param.secondModReg = 0X49;

    param.parity = EUSCI_A_UART_NO_PARITY;
    param.msborLsbFirst = EUSCI_A_UART_LSB_FIRST;
    param.numberofStopBits = EUSCI_A_UART_ONE_STOP_BIT;
    param.uartMode = EUSCI_A_UART_MODE;
    param.overSampling = EUSCI_A_UART_OVERSAMPLING_BAUDRATE_GENERATION;
    //param.overSampling = EUSCI_A_UART_LOW_FREQUENCY_BAUDRATE_GENERATION;
    if (STATUS_FAIL == EUSCI_A_UART_init(EUSCI_A1_BASE, &param)){
        ret = -1;
    }

    EUSCI_A_UART_enable(EUSCI_A1_BASE);
    // Enable USCI A0 RX interrupt
    EUSCI_A_UART_disableInterrupt(EUSCI_A1_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
    EUSCI_A_UART_clearInterrupt(EUSCI_A1_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);

    return ret;
}

//******************************************************
// Sending a String which should end with \0
//******************************************************
void WISE_DebugString(unsigned char * str){
    unsigned char i;
    unsigned char len = (unsigned char)strlen((const char *)str);
    for(i=0;i<len;i++){
        EUSCI_A_UART_transmitData(EUSCI_A1_BASE, str[i]);
    }
    while(EUSCI_A_UART_queryStatusFlags(EUSCI_A1_BASE, EUSCI_A_UART_BUSY));
}
