//    // SDI-12 interface
//    GPIO_setAsOutputPin (GPIO_PORT_P3, GPIO_PIN7);
//    GPIO_setOutputHighOnPin ( GPIO_PORT_P3, GPIO_PIN7 );    //Apagado a valor alto
//
//    // Flash Memory
//    GPIO_setAsOutputPin (GPIO_PORT_P5, GPIO_PIN3);
//    GPIO_setOutputHighOnPin ( GPIO_PORT_P5, GPIO_PIN3 );    //Apagado a valor alto
/*
 *  ======== fatsd.c ========
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

/* XDCtools Header files */
#include <xdc/std.h>
//#include <xdc/runtime/System.h>
//#include <xdc/runtime/Log.h>

//Para reconocer cosas del fichero .cfg
#include <xdc/cfg/global.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/SDSPI.h>
#include <ti/drivers/UART.h>

/* Example/Board Header files */
#include "Board.h"

#include <driverlib.h>


#include "WISE_DEBUG.h"

//GPRS
void GPRSWrite(uint8_t * cmd, uint8_t len);

#define GPRS_RST_BEGIN   0

uint8_t t[3][30];
uint8_t c = 0;


//Void taskFxn(UArg arg0, UArg arg1)
Void taskFxn()
{
    while(1)
    {
        Semaphore_pend(LogDataSem, 10000);

        //clear de pointer to the matrix which stores the 3 simulated responses from the GPRS
        c = 0;
        GPIO_write(Board_LED0, Board_LED_ON);
        WISE_DebugString("\nTRYING\n");
        EUSCI_A_UART_enableInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
        EUSCI_A_UART_clearInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);

        //Reset the GPRS module
        GPIO_setOutputLowOnPin ( GPIO_PORT_P4, GPIO_PIN7 );
        Semaphore_pend(LogDataSem, 200);
        GPIO_setOutputHighOnPin ( GPIO_PORT_P4, GPIO_PIN7 );

        //Waiting 5 seconds and printing the responses
        Semaphore_pend(LogDataSem, 5000);
        WISE_DebugString(t[0]);
        WISE_DebugString(t[1]);
        WISE_DebugString(t[2]);
        memset(t[0], 0, 30);
        memset(t[1], 0, 30);
        memset(t[2], 0, 30);

        GPIO_write(Board_LED0, Board_LED_OFF);
    }
}

/*
 *  ======== main ========
 */
int main()
{
    /* Call MSP-EXP430FR5994 board init functions */
    Board_initGeneral();
    Board_initGPIO();

    /* Turn off user LEDs */
    GPIO_write(Board_LED0, Board_LED_OFF);
    GPIO_write(Board_LED1, Board_LED_OFF);

    //For sending data to the computer using P2.5 pin
    WISE_DebugInit();


    //GPRS SIM 800 begin
    //Pins configuration
    GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P2,
            GPIO_PIN0, GPIO_SECONDARY_MODULE_FUNCTION);
    GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P2,
            GPIO_PIN1, GPIO_SECONDARY_MODULE_FUNCTION);

    //RESET line
    GPIO_setAsOutputPin (GPIO_PORT_P4, GPIO_PIN7);
    GPIO_setOutputHighOnPin ( GPIO_PORT_P4, GPIO_PIN7 );

    //Configuring UART for GPRS at 9600 bps
    EUSCI_A_UART_initParam param = {0};
    param.selectClockSource = EUSCI_A_UART_CLOCKSOURCE_SMCLK;
    param.clockPrescalar = 52;
    param.firstModReg = 1;
    param.secondModReg = 0x49;
    param.parity = EUSCI_A_UART_NO_PARITY;
    param.msborLsbFirst = EUSCI_A_UART_LSB_FIRST;
    param.numberofStopBits = EUSCI_A_UART_ONE_STOP_BIT;
    param.uartMode = EUSCI_A_UART_MODE;
    param.overSampling = EUSCI_A_UART_OVERSAMPLING_BAUDRATE_GENERATION;
    if (STATUS_FAIL == EUSCI_A_UART_init(EUSCI_A0_BASE, &param)){
        WISE_DebugString("Error init UART for GPRS\n");
    }

    EUSCI_A_UART_enable(EUSCI_A0_BASE);
    // Enable USCI A0 RX interrupt
    EUSCI_A_UART_disableInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
    EUSCI_A_UART_clearInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);

    WISE_DebugString("Starting the example\n");

    /* Start BIOS */
    BIOS_start();

    return (0);
}


void GPRS_ISR(){
    static uint8_t trama[30];
    static bool tramaComenzo = false;
    static uint8_t ac = 0;
    static uint8_t anterior = 0;

    uint16_t isrStatus = EUSCI_A_UART_getInterruptStatus(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
    EUSCI_A_UART_clearInterrupt(EUSCI_A0_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);

    if(isrStatus & EUSCI_A_UART_RECEIVE_INTERRUPT){
        uint8_t caracter = EUSCI_A_UART_receiveData(EUSCI_A0_BASE);
        if((anterior == '\r') && (caracter == '\n')){
            if(ac == 0){    //Frame start
                tramaComenzo = true;
                memset(&trama[0], 0, 30);
                trama[0] = '\r';
                ac = 1;
            }
            else{       //Frame end
                trama[ac] = caracter;
                ac++;
                trama[ac] = '\0';
                strcpy((char*)(t[c]), (char*)trama);
                c++;
                if(c == 3){
                    c = 0;
                    //Semaphore_post(LogDataSem);
                }
                anterior = ac = 0;
                tramaComenzo = false;
            }
        }
        if(tramaComenzo){
            trama[ac] = caracter;
            ac++;
        }
        anterior = caracter;
    }
}
