#!/usr/bin/env bash

set -e
set -x

configure_args_common='--target=msp430-elf --enable-languages=c,c++ --disable-nls --enable-initfini-array --prefix=/opt/msp430'
# Note: binutils doesn't build without warnings on macOS
# https://sourceware.org/ml/binutils/2013-12/msg00051.html
configure_args_binutils=$(echo --disable-{sim,gdb,werror})

# Create directories
rm -rf build install
mkdir -p build/{binutils,gcc,gdb} install

# Build binutils
pushd build/binutils
  ../../binutils/configure $configure_args_common $configure_args_binutils --with-pkgversion="${pkg_version-$USER}"
  make
  make install DESTDIR=$PWD/../../install
popd
