#!/usr/bin/env bash

set -e
set -x

configure_args_common='--target=msp430-elf --enable-languages=c,c++ --disable-nls --enable-initfini-array --prefix=/opt/msp430'
configure_args_gcc=$(echo --enable-target-optspace --enable-newlib-nano-formatted-io)

pushd gcc
  # Download sources for gcc prerequisites (gmp, mpfr, mpc, and isl)
  (
    # download_prerequisites requires wget which isn't on macOS
    wget() {
      curl -O "$@"
    }
    source ./contrib/download_prerequisites
  )

  # Create a single source tree for gcc and newlib
  for dir in libgloss newlib; do
    ln -fns ../newlib/$dir $dir
  done
popd

# Create directories
#rm -rf build install
#mkdir -p build/{binutils,gcc,gdb} install

# Build gcc and newlib
pushd build/gcc
  (
    export PATH=$PWD/../../install/usr/local/bin:$PATH
    ../../gcc/configure $configure_args_common $configure_args_gcc --with-pkgversion="${pkg_version-$USER}"
    make
    make install DESTDIR=$PWD/../../install
  )
popd

