#!/usr/bin/env bash

set -e
set -x

configure_args_common='--target=msp430-elf --enable-languages=c,c++ --disable-nls --enable-initfini-array --prefix=/opt/msp430'
#configure_args_gdb=$(echo --disable-{binutils,gas,ld,gprof,etc} --without-{mpfr,lzma} --with-python=no)
configure_args_gdb=$(echo --without-{mpfr,lzma} --with-python=yes --enable-targets=all --enable-tui --with-curses )

# Build gdb
pushd build/gdb
  ../../gdb/configure $configure_args_common $configure_args_gdb --with-pkgversion="${pkg_version-$USER}"
  make
  make install DESTDIR=$PWD/../../install
popd

