//******************************************************************************
//  MSP430F2013 LPM3 - Basic Clock, LPM3 Using WDT ISR, VLO ACLK on the
//                     Experimenter's board
//
//  Description:
//  Demo for measuring LPM3 current.

//  This program operates MSP430 normally in LPM3, pulsing P1.0
//  ~ 6 second intervals.
//  > WDT ISR used to wake-up system.
//  > All I/O configured as low outputs to eliminate floating inputs.
//  > Current consumption does increase when LED is powered on P1.0.
//  > ACLK = VLO/2
//  > MCLK = SMCLK = default DCO
//******************************************************************************
//   MSP430F2013 on the Experimenter's Board
//         ---------------
//     /|\|            XIN|-
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  Built with IAR Embedded Workbench Version: 3.42A
//
//  K. Chen
//  Texas Instruments Inc.
//  Ver 2.00 - March 2012
//  Built with IAR Embedded Workbench Version: 5.40.3 & Code Composer Studio V5.1
//******************************************************************************

#include <msp430x20x3.h>

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;                 // Stop watchdog timer
  P1DIR |= 0x01;                            // Set P1.0 to output direction

  while(1)
  {
    int i;
    P1OUT |= 0x01;                          // Set P1.0 LED on
    for (i = 10000; i>0; i--);              // Delay
    P1OUT &= ~0x01;                         // Reset P1.0 LED off
  }
  return 0;
}
