// DriverLib Includes
#include "driverlib.h"
#include "printf.h"

// Standard Includes
#include <stdint.h>
#include <stdbool.h>
#include <math.h>

const eUSCI_UART_Config uartConfig =
{
	EUSCI_A_UART_CLOCKSOURCE_SMCLK,               // SMCLK Clock Source
	78,                                           // BRDIV = 78
	2,                                            // UCxBRF = 2
	0,                                            // UCxBRS = 0
	EUSCI_A_UART_NO_PARITY,                       // No Parity
	EUSCI_A_UART_LSB_FIRST,                       // MSB First
	EUSCI_A_UART_ONE_STOP_BIT,                    // One stop bit
	EUSCI_A_UART_MODE,                            // UART mode
	EUSCI_A_UART_OVERSAMPLING_BAUDRATE_GENERATION // Oversampling
};

void PrintFloatUART(float x);

static volatile uint8_t rxByte = 0, txByte = 0;
static uint32_t timerVal = 0;
static float echoTime = 0;
static int echoFlag = 0;
static int butFlag = 0;
static int i = 0;

void main(void)
{

	//  Stop watchdog timer
    MAP_WDT_A_holdTimer();

    // Set LED 2.1 as output
    MAP_GPIO_setAsOutputPin(GPIO_PORT_P2, GPIO_PIN1);

    //	Set DCO frequency to 30 MHz

    MAP_CS_setDCOFrequency(30000000);

    // UART setup
    MAP_GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P3, GPIO_PIN2 | GPIO_PIN3, GPIO_PRIMARY_MODULE_FUNCTION);
	MAP_UART_initModule(EUSCI_A2_BASE, &uartConfig);
	MAP_UART_enableModule(EUSCI_A2_BASE);
	MAP_UART_enableInterrupt(EUSCI_A2_BASE, EUSCI_A_UART_RECEIVE_INTERRUPT);
	MAP_Interrupt_enableInterrupt(INT_EUSCIA2);

	//	Timer 32 setup
	MAP_Timer32_initModule(TIMER32_0_BASE, TIMER32_PRESCALER_256, TIMER32_32BIT, TIMER32_FREE_RUN_MODE);

	//	Configuring P1.1
	MAP_GPIO_setAsInputPinWithPullUpResistor(GPIO_PORT_P1, GPIO_PIN1);
	MAP_GPIO_clearInterruptFlag(GPIO_PORT_P1, GPIO_PIN1);
	MAP_GPIO_enableInterrupt(GPIO_PORT_P1, GPIO_PIN1);

    MAP_Interrupt_enableMaster();

    i = 0;

    while (1)
    {
    	if(butFlag) {

			for( i = 0; i < 8; i++ ) {

				echoFlag = 0;

				txByte++;

				MAP_Timer32_setCount(TIMER32_0_BASE, 0xFFFFFFFF);
				MAP_Timer32_startTimer(TIMER32_0_BASE, false);

				MAP_UART_transmitData(EUSCI_A2_BASE, txByte);

				while(!echoFlag);

			}

    	}

    }

}

//	Start Interrupt of Port 1 to send 8 packets of data
void PORT1_IRQHandler(void)
{
    uint32_t status = MAP_GPIO_getEnabledInterruptStatus(GPIO_PORT_P1);
    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P1, status);

    if (status & GPIO_PIN1)
    	butFlag = 1;

}

// UART Receive Interrupt handler
void EUSCIA2_IRQHandler(void)
{
	uint32_t status = MAP_UART_getEnabledInterruptStatus(EUSCI_A2_BASE);
	UART_clearInterruptFlag(EUSCI_A2_BASE, status);

	if(status & EUSCI_A_UART_RECEIVE_INTERRUPT_FLAG)
		rxByte = MAP_UART_receiveData(EUSCI_A2_BASE);

	switch (rxByte)	{

		case 'B':

			MAP_UART_transmitData(EUSCI_A2_BASE, rxByte);
		    MAP_Interrupt_enableInterrupt(INT_PORT1);
		    MAP_GPIO_setOutputHighOnPin(GPIO_PORT_P2, GPIO_PIN1);
		    butFlag = 0;

			break;

		case 'S':

			MAP_Interrupt_disableInterrupt(INT_PORT1);
			MAP_GPIO_setOutputLowOnPin(GPIO_PORT_P2, GPIO_PIN1);
			butFlag = 0;

			break;

		case '1':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '1');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '2':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '2');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '3':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, 3);
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '4':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '4');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '5':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '5');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '6':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '6');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '7':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '7');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

		case '8':

			echoFlag = 1;
			MAP_Timer32_haltTimer(TIMER32_0_BASE);
			timerVal = 0xFFFFFFFF - MAP_Timer32_getValue(TIMER32_0_BASE);
			echoTime = timerVal * 0.00000853333;
			MAP_UART_transmitData(EUSCI_A2_BASE, '8');
			printf(EUSCI_A2_BASE, ";");
			PrintFloatUART(echoTime);

			break;

	}

}

//Print floating point values to UART
void PrintFloatUART(float x)
{
	int i = 0;
	float fract = x - floor(x);
	int dec = x - fract;
	printf(EUSCI_A2_BASE, "%i", dec);
	printf(EUSCI_A2_BASE, ".");
	for(i = 0; i < 10; i++ )
	{

		x = fract * 10;
		fract = x - floor(x);
		dec = x - fract;
		printf(EUSCI_A2_BASE, "%i", dec);

	}

	printf(EUSCI_A2_BASE, "\r\n");

}
