## Example Summary

Sample application to demonstrate I2C Master and I2C Slave communication

## Peripherals Exercised

* This example requires 2 MSP432P401R LaunchPads. MASTER (i2cmasterexample1.c) is run on one board and SLAVE (i2cslaveexample1.c) is run on the other
* Board_I2CSLAVE0 - I2C Slave instance used at the slave end

## Resources & Jumper Settings

If you're using an IDE (such as CCS or IAR), please refer to Board.html in your project
directory for resources used and board-specific jumper settings. Otherwise, you can find
Board.html in the directory &lt;SDK_INSTALL_DIR&gt;/source/ti/boards/&lt;BOARD&gt;.

__Master__ `P6.4` __-->__ 10k __-->__ `P1.6` __Slave__
__Master__ `P6.5` __-->__ 10k __-->__ `P1.7` __Slave__

__Master__ `GND` __-->__ `GND` __Slave__

## Example Usage

The counterpart of this example at the I2C master end is i2cmasterexample1.c


1. Download the i2cslaveexample1.c one the first board(SLAVE). Unplug the first board.


2.  Download the i2cmasterexample1.c on the second board(MASTER). Pause the code in main.

3.  Plug the first board(SLAVE) in another usb port so that the slave application is now running and waiting on the master.


4.  Run the second board(MASTER)


5.  Open a serial session (e.g. [`PuTTY`](http://www.putty.org/ "PuTTY's Homepage"), etc.) to the appropriate COM port.
    The COM port can be determined via Device Manager in Windows or via `ls /dev/tty*` in Linux.

The connection will have the following settings:
```
    Baud-rate:     115200
    Data bits:          8
    Stop bits:          1
    Parity:          None
    Flow Control:    None
```
The expected value is
```
I2C Initialized!

Master: x Hello this is master

I2C master/slave transfer complete

Slave: o Hello this is slave

I2C closed!
```
## Application Design Details

* This application uses one task, 'mainThread', which performs the following actions:
    * Opens and initializes I2C object.
    * Uses the I2CSlave driver to communicate with the I2CMaster.

* The following commands are defined by the application code on top of I2C operations:
    * GETSTATUS Cmd from master - command[0] = 0x01
    * SETSTATUS Cmd from master - command[0] = 0x02
    * READBLOCK Cmd from master - command[0] = 0x03
    * WRITEBLOCK Cmd from master - command[0] = 0x04

mirrorRegister is the memory block that is used to store sent/received data
mirrorRegister[0] holds the status byte that GETSTATUS and SETSTATUS point to.
* Master mirrorRegister begins with "x Hello this is master"
* Slave mirrorRegister begins with "x "
* Print out contents of Master mirrorRegister to serial session
* GETSTATUS, expecting "x" status byte, will print an ERROR otherwise
* SETSTATUS, should overwrite slave status byte from "x" to "o"
* WRITEBLOCK, should fill in the rest of the slave mirrorRegister with "Hello this is slave"
* READBLOCK, read the entire Slave mirrorRegister and replace Master's mirrorRegister
* Print the Master full mirrorRegister which should now contain "o Hello this is slave"

TI-RTOS:

* When building in Code Composer Studio, the kernel configuration project will be imported along with the example. The kernel configuration project is referenced by the example, so it will be built first. The "release" kernel configuration is the default project used. It has many debug features disabled. These feature include assert checking, logging and runtime stack checks. For a detailed difference between the "release" and "debug" kernel configurations and how to switch between them, please refer to the SimpleLink MCU SDK User's Guide. The "release" and "debug" kernel configuration projects can be found under &lt;SDK_INSTALL_DIR&gt;/kernel/tirtos/builds/&lt;BOARD&gt;/(release|debug)/(ccs|gcc).

FreeRTOS:

* Please view the `FreeRTOSConfig.h` header file for example configuration
information.
