/******************************************************************************/
/* LINKER COMMAND FILE FOR MSPBoot BOOTLOADER USING MSP430FR5969  */
/* File generated with MSPBootLinkerGen.pl on 06-17-2015 */
/*----------------------------------------------------------------------------*/


/****************************************************************************/
/* SPECIFY THE SYSTEM MEMORY MAP                                            */
/****************************************************************************/
/* The following definitions can be changed to customize the memory map for a different device
 *   or other adjustments
 *  Note that the changes should match the definitions used in MEMORY and SECTIONS
 *
 */
/* RAM Memory Addresses */
__RAM_Start = 0x1C00;                 /* RAM Start */
__RAM_End = 0x23FF;                     /* RAM End */
    /* RAM shared between App and Bootloader, must be reserved */
    PassWd = 0x1C00;                 /* Password sent by App to force boot  mode */
    StatCtrl = 0x1C02;             /* Status and Control  byte used by Comm */
    CI_State_Machine = 0x1C03;         /*  State machine variable used by Comm */
    CI_Callback_ptr = 0x1C04;   /* Pointer to Comm callback structure */
    /* Unreserved RAM used for Bootloader or App purposes */
    _NonReserved_RAM_Start = 0x1C06; /* Non-reserved RAM */

/* Flash memory addresses */
/* Download area: 4400-5FFF*/
/* App area     : 6000-139FF*/
/* Boot area    : 13A00-FFFF*/
_FLASHDOWN_START = 0x4400; /* Start if download area */
__Flash_Start = 0x6000;             /* Start of Flash */
__Flash_End = 0xFFFF;                           /* End of Flash */
    /* Reserved Flash locations for Bootloader Area */
    __Boot_Start = 0x13A00;         /* Boot flash */
    __Boot_Reset = 0xFFFE;                          /* Boot reset vector */
    __Boot_VectorTable = 0x13F90;      /* Boot vector table */
    __Boot_SharedCallbacks_Len = 8; /* Length of shared callbacks (2 calls =4B(msp430) or 8B(msp430x) */
    __Boot_SharedCallbacks = 0x13F88; /* Start of Shared callbacks */
    _BOOT_APPVECTOR = __Boot_SharedCallbacks;       /* Definition for application table             */
    /* Reserved Flash locations for Application Area */
    _AppChecksum = (__Flash_Start);                 /* CRC16 of Application                         */
    _AppChecksum_8 = (__Flash_Start+2);             /* CRC8 of Application                          */
    _App_Start = (__Flash_Start+3);                 /* Application Area                             */
    _App_End = (__Boot_Start-1);                    /* End of application area (before boot)        */
    _CRC_Size = (_App_End - _App_Start +1);         /* Number of bytes calculated for CRC           */
    _App_Reset_Vector = (__Boot_Start-2);           /* Address of Application reset vector */
    _App_Proxy_Vector_Start = 0x13990; /* Proxy interrupt table */

/* MEMORY definition, adjust based on definitions above */
MEMORY
{
    SFR                     : origin = 0x0000, length = 0x0010
    PERIPHERALS_8BIT        : origin = 0x0010, length = 0x00F0
    PERIPHERALS_16BIT       : origin = 0x0100, length = 0x0100
    // RAM from _NonReserved_RAM_Start - __RAM_End
    RAM                     : origin = 0x1C06, length = 0x7FA
    INFOBOOT                : origin = 0x1800, length = 0x200
    // Flash from _App_Start -> (APP_PROXY_VECTORS-1)
    FLASH                   : origin = 0x6003, length = 0xD98D
    // Interrupt Proxy table from  _App_Proxy_Vector_Start->(RESET-1)
    INT00            : origin = 0x13990, length = 0x0002
    INT01            : origin = 0x13992, length = 0x0002
    INT02            : origin = 0x13994, length = 0x0002
    INT03            : origin = 0x13996, length = 0x0002
    INT04            : origin = 0x13998, length = 0x0002
    INT05            : origin = 0x1399A, length = 0x0002
    INT06            : origin = 0x1399C, length = 0x0002
    INT07            : origin = 0x1399E, length = 0x0002
    INT08            : origin = 0x139A0, length = 0x0002
    INT09            : origin = 0x139A2, length = 0x0002
    INT10            : origin = 0x139A4, length = 0x0002
    INT11            : origin = 0x139A6, length = 0x0002
    INT12            : origin = 0x139A8, length = 0x0002
    INT13            : origin = 0x139AA, length = 0x0002
    INT14            : origin = 0x139AC, length = 0x0002
    INT15            : origin = 0x139AE, length = 0x0002
    INT16            : origin = 0x139B0, length = 0x0002
    INT17            : origin = 0x139B2, length = 0x0002
    INT18            : origin = 0x139B4, length = 0x0002
    INT19            : origin = 0x139B6, length = 0x0002
    INT20            : origin = 0x139B8, length = 0x0002
    INT21            : origin = 0x139BA, length = 0x0002
    INT22            : origin = 0x139BC, length = 0x0002
    INT23            : origin = 0x139BE, length = 0x0002
    INT24            : origin = 0x139C0, length = 0x0002
    INT25            : origin = 0x139C2, length = 0x0002
    INT26            : origin = 0x139C4, length = 0x0002
    INT27            : origin = 0x139C6, length = 0x0002
    INT28            : origin = 0x139C8, length = 0x0002
    INT29            : origin = 0x139CA, length = 0x0002
    INT30            : origin = 0x139CC, length = 0x0002
    INT31            : origin = 0x139CE, length = 0x0002
    INT32            : origin = 0x139D0, length = 0x0002
    INT33            : origin = 0x139D2, length = 0x0002
    INT34            : origin = 0x139D4, length = 0x0002
    INT35            : origin = 0x139D6, length = 0x0002
    INT36            : origin = 0x139D8, length = 0x0002
    INT37            : origin = 0x139DA, length = 0x0002
    INT38            : origin = 0x139DC, length = 0x0002
    INT39            : origin = 0x139DE, length = 0x0002
    INT40            : origin = 0x139E0, length = 0x0002
    INT41            : origin = 0x139E2, length = 0x0002
    INT42            : origin = 0x139E4, length = 0x0002
    INT43            : origin = 0x139E6, length = 0x0002
    INT44            : origin = 0x139E8, length = 0x0002
    INT45            : origin = 0x139EA, length = 0x0002
    INT46            : origin = 0x139EC, length = 0x0002
    INT47            : origin = 0x139EE, length = 0x0002
    INT48            : origin = 0x139F0, length = 0x0002
    INT49            : origin = 0x139F2, length = 0x0002
    INT50            : origin = 0x139F4, length = 0x0002
    INT51            : origin = 0x139F6, length = 0x0002
    INT52            : origin = 0x139F8, length = 0x0002
    INT53            : origin = 0x139FA, length = 0x0002
    INT54            : origin = 0x139FC, length = 0x0002
    
    // App reset from _App_Reset_Vector
    RESET                   : origin = 0x139FE, length = 0x0002
}

/****************************************************************************/
/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY                              */
/****************************************************************************/

SECTIONS
{
    .bss        : {} > RAM                /* GLOBAL & STATIC VARS              */
    .data       : {} > RAM                /* GLOBAL & STATIC VARS              */
    .sysmem     : {} > RAM                /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack      : {} > RAM (HIGH)         /* SOFTWARE SYSTEM STACK             */

    .text       : {} >> FLASH |INFOBOOT   /* CODE                 */
    .cinit      : {} > FLASH |INFOBOOT   /* INITIALIZATION TABLES*/
    .const      : {} >> FLASH |INFOBOOT   /* CONSTANT DATA        */
    .cio        : {} > RAM                /* C I/O BUFFER                      */

       /* MSP430 INTERRUPT VECTORS          */
    .int00       : {}               > INT00
    .int01       : {}               > INT01
    .int02       : {}               > INT02
    .int03       : {}               > INT03
    .int04       : {}               > INT04
    .int05       : {}               > INT05
    .int06       : {}               > INT06
    .int07       : {}               > INT07
    .int08       : {}               > INT08
    .int09       : {}               > INT09
    .int10       : {}               > INT10
    .int11       : {}               > INT11
    .int12       : {}               > INT12
    .int13       : {}               > INT13
    .int14       : {}               > INT14
    .int15       : {}               > INT15
    .int16       : {}               > INT16
    .int17       : {}               > INT17
    .int18       : {}               > INT18
    .int19       : {}               > INT19
    .int20       : {}               > INT20
    .int21       : {}               > INT21
    .int22       : {}               > INT22
    .int23       : {}               > INT23
    .int24       : {}               > INT24
    .int25       : {}               > INT25
    .int26       : {}               > INT26
    .int27       : {}               > INT27
    .int28       : {}               > INT28
    .int29       : {}               > INT29
    .int30       : {}               > INT30
    RTC          : { * ( .int31 ) } > INT31 type = VECT_INIT
    PORT4        : { * ( .int32 ) } > INT32 type = VECT_INIT
    PORT3        : { * ( .int33 ) } > INT33 type = VECT_INIT
    TIMER2_B1    : { * ( .int34 ) } > INT34 type = VECT_INIT
    TIMER2_B0    : { * ( .int35 ) } > INT35 type = VECT_INIT
    PORT2        : { * ( .int36 ) } > INT36 type = VECT_INIT
    TIMER1_B1    : { * ( .int37 ) } > INT37 type = VECT_INIT
    TIMER1_B0    : { * ( .int38 ) } > INT38 type = VECT_INIT
    PORT1        : { * ( .int39 ) } > INT39 type = VECT_INIT
    TIMER1_A1    : { * ( .int40 ) } > INT40 type = VECT_INIT
    TIMER1_A0    : { * ( .int41 ) } > INT41 type = VECT_INIT
    DMA          : { * ( .int42 ) } > INT42 type = VECT_INIT
    USCI_A1      : { * ( .int43 ) } > INT43 type = VECT_INIT
    TIMER0_A1    : { * ( .int44 ) } > INT44 type = VECT_INIT
    TIMER0_A0    : { * ( .int45 ) } > INT45 type = VECT_INIT
    ADC10        : { * ( .int46 ) } > INT46 type = VECT_INIT
    USCI_B0      : { * ( .int47 ) } > INT47 type = VECT_INIT
    USCI_A0      : { * ( .int48 ) } > INT48 type = VECT_INIT
    WDT          : { * ( .int49 ) } > INT49 type = VECT_INIT
    TIMER0_B1    : { * ( .int50 ) } > INT50 type = VECT_INIT
    TIMER0_B0    : { * ( .int51 ) } > INT51 type = VECT_INIT
    COMP_D       : { * ( .int52 ) } > INT52 type = VECT_INIT
    UNMI         : { * ( .int53 ) } > INT53 type = VECT_INIT
    SYSNMI       : { * ( .int54 ) } > INT54 type = VECT_INIT

    .reset       : {}               > RESET  /* MSP430 RESET VECTOR                 */
}

/****************************************************************************/
/* INCLUDE PERIPHERALS MEMORY MAP                                           */
/****************************************************************************/

-l MSP430FR5969.cmd

