/* DriverLib Includes */
#include <ti/devices/msp432p4xx/driverlib/driverlib.h>

#include <stdio.h>

extern volatile bool framTxFlag, framRxFlag;

/**
 * @brief This is the EUSCI_B0 interrupt vector service routine.
 *
 * @param data - Write data buffer:
 *               - first byte is the chip select number;
 *               - from the second byte onwards are located data bytes to write.
 * @param bytesNumber - Number of bytes to write.
 *
 * @return Number of written bytes.
**/
void EUSCIA1_IRQHandler(void)
{
    unsigned int status;
    status = MAP_SPI_getEnabledInterruptStatus(EUSCI_A1_BASE);
    MAP_SPI_clearInterruptFlag(EUSCI_A1_BASE, status);
    if (status & EUSCI_A_SPI_TRANSMIT_INTERRUPT)
    {
        framTxFlag = true;
    }
    if (status & EUSCI_A_SPI_RECEIVE_INTERRUPT)
    {
        framRxFlag = true;
    }
    MAP_Interrupt_disableSleepOnIsrExit();
}
