#include <msp430.h> 

/*
 * main.c
 */

void Blink(unsigned char ucColor, unsigned char ucTimes);

int main(void) {
	const char GREEN = 0x40;  // Green Led on pin P1.6
	const char RED = 0x01;    // Red Led on pin P1.0

    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer

    P1IE = 0x00;	// Each pin in P1 has its interrupt capability disabled
    P1SEL  = 0x00;  // All pins of P1 configured
    P1SEL2 = 0x00;  // as I/O function
    P1REN = 0x00;   // Pullup/pulldown resistors and disable for each P1 pin
    P1DIR = 0x41;	// P1.0 and P1.6 configured as output, the others in input

    P1OUT =0x00;
    while (1)
    {
    	Blink(RED,3);
    	Blink(GREEN,6);
    	Blink(RED,3);
    	Blink(GREEN,1);
    }
}

void Blink(unsigned char ucColor, unsigned char ucTimes)
{
	unsigned int uiDuration,i;

	while (ucTimes > 0)
	{
		P1OUT |= ucColor;
		for (i=40000;i>0;i--)
		{
			for (uiDuration=40000; uiDuration > 0; uiDuration--) { }
		}
		P1OUT ^= ucColor;
		for (i=40000;i>0;i--)
				{
					for (uiDuration=40000; uiDuration > 0; uiDuration--) { }
				}

	    ucTimes--;
	}
}
