#include <msp430.h> 
#include <stdint.h>
#include <driverlib.h>


uint16_t volatile resetReason = 0;
int main()
{
  resetReason = SYSRSTIV;
  resetReason = 0;

  WDTCTL = WDTPW | WDTHOLD; // Stop the watchdog timer

  // To enable LFXT, the PSEL bits associated with the crystal pins must be set.   - RM 3.2
  // Setting the PSEL bit causes the LFXIN and LFXOUT ports to be configured for LFXT operation.
  // LFXIN = PJ.4
  PJSEL0 |= BIT4 | BIT5;    // Set bits 4 and 5 in PJSEL0 to enable primary function
  PJSEL1 &= ~(BIT4 | BIT5); // Clear bits 4 and 5 in PJSEL1 to select primary function

  // Unlock CS registers
  CSCTL0 = 0xA500; // Password to unlock clock system registers
  // Set DCO to 8 MHz
  CSCTL1 = 0x000C;
  // Configure clock sources
  CSCTL2 = SELM__DCOCLK | SELS__DCOCLK | SELA__LFXTCLK;
  // MCLK = DCOCLK, SMCLK = DCOCLK, ACLK = LFXTCLK
  // Set dividers for MCLK, SMCLK, and ACLK
  CSCTL3 = DIVM__1 | DIVS__1 | DIVA__1;
  // MCLK = DCO / 1, SMCLK = DCO / 1, ACLK = LFXT / 1
  // Enable LFXT with drive strength 3
  CSCTL4 &= ~LFXTOFF;    // Enable LFXT
  CSCTL4 |= LFXTDRIVE_3; // Set LFXT drive strength to 3
  // Clear fault flags and wait for LFXT to stabilize
  do
  {
    CSCTL5 &= ~LFXTOFFG; // Clear LFXT fault flag
    SFRIFG1 &= ~OFIFG;   // Clear oscillator fault flag
  } while (SFRIFG1 & OFIFG);
  // Lock CS registers
  CSCTL0_H = 0x01; // Lock clock system registers

  PM5CTL0 &= ~LOCKLPM5; // Clear the LOCKLPM5 bit to enable GPIO functionality
/*
  uint16_t length = 0xFFFF;
  DMA_initParam cfg = {
      DMA_CHANNEL_0,            // channelSelect
      DMA_TRANSFER_BLOCK,       // transferModeSelect
      length,                   // transferSize
      DMA_TRIGGERSOURCE_0,      // triggerSourceSelect
      DMA_SIZE_SRCBYTE_DSTBYTE, // transferUnitSelect
      DMA_TRIGGER_RISINGEDGE    // triggerTypeSelect
  };

  uintptr_t src = (uintptr_t)(0x10000);
  uintptr_t dst = (uintptr_t)(&CRC32DIRBB0);

  DMA_init(&cfg);

  HWREG16(DMA_BASE + DMA_CHANNEL_0 + OFS_DMA0CTL) &= ~(DMASRCINCR | DMADSTINCR);
  HWREG16(DMA_BASE + DMA_CHANNEL_0 + OFS_DMA0CTL) |= DMASRCINCR_3;

  __data20_write_long((uintptr_t)&DMA0SA, src);
  __data20_write_long((uintptr_t)&DMA0DA, dst);

  DMA0CTL &= ~DMAIFG;
  DMA_enableTransfers(DMA_CHANNEL_0);

  DMA0CTL |= DMAREQ;


  // Add timeout to debug
  uint32_t timeout = 10000;
  while (!(DMA0CTL & DMAIFG) && --timeout)
  {
    __no_operation();
  }
*/
  while (1)
  {
  };
}
