#include <msp430.h> 
#include "aes_tm.h"
#include "aes256.h"
/*
 * main.c
 */

uint8_t test[16];
uint8_t out[16];

int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer
    // Disable the GPIO power-on default high-impedance mode to activate
    // previously configured port settings
    PM5CTL0 &= ~LOCKLPM5;

    AES_DataSet();
    AES_KeySet();

    AES256_setCipherKey( AES256_BASE  , AES_Key, AES256_KEYLENGTH_128BIT );
    AES256_encryptData(  AES256_BASE  , AES_DataEnc, test );
    AES256_setDecipherKey( AES256_BASE, AES_Key, AES256_KEYLENGTH_128BIT );
    AES256_decryptData(  AES256_BASE  , test, out );

    __no_operation();

    while(1){}


}
