#ifndef EMV_FW_UPDATE
#define EMV_FW_UPDATE
//=============================================================================
// Header: JT808 firmware field update definition
// Date Time: 8/24/2010 1:57 PM
// Author: Xuedong Liu
//
// Copyright (c) 2013  NewGate Instrument 
//=============================================================================

// BSL CMD Code part 1 of 2
#define HOST_SYNC_CMD       0x80
// BSL CMD Code part 2 of 2, increase process speed, sort by CMD code
enum {
  RX_DATA_BLOCK = 0x10,//0x10
  RX_PASSWORD,         //0x11
  ERASE_SEGMENT,       //0x12
  TOGGLE_INFO,         //0x13
  ERASE_BLOCK,         //0x14
  MASS_ERASE,          //0x15
  CRC_CHECK,           //0x16
  LOAD_PC,             //0x17
  TX_DATA_BLOCK,       //0x18
  TX_BSL_VERSION,      //0x19
  TX_BUFFER_SIZE,      //0x1A
  RX_DATA_BLOCK_FAST,  //0x1B
  RX_NEXT_BLOCK,       //0x1C
  RX_END_FILE,         //0x1D
  SPACE_ONE,           //0x1E
  BSL_TXSECTION_INFO,  //0x1F
  FLASH_TO_MSP,        //0x20
  CANCEL_FLASH_TO_MSP, //0x21
  ERASE_STATUS_CHECK,  //0x22
};

// use MSP internal code flash
#define FLASH_BLOCK_5438A      2

#define ERASE_FLASH_HOLD_TIME  32000      // ACLK = 922000Hz, (1/ACLK) * 32000 = 34.78ms  spec need 32ms @P65 of data sheet

// locat BSL response element into standard Modbus messaage
enum {
  //MD_BSL_RSP_ADDR_AT,   // 0 response buffer where saved unit address, define in CMD, not repeat here
  //MD_BSL_ID_AT,         // 1 response buffer where saved BSL function ID, define in CMD, not repeat here
  //MD_BSL_LENGTH_AT,     // 2 response buffer where saved BSL command length, define in CMD, not repeat here
  MD_BSL_RSP_ID_AT = BSL_RSP_PROTO_LENGTH,   // 3 response buffer where saved EMV response ID code
  MD_BSL_RSP_CODE_AT,     // 4 response buffer where saved EMV response code.
  MD_BSL_RSP_DATA_ST,     // 5 response buffer where saved EMV response data start position
};

typedef struct _BSLCMD
{
 tU8 u8CmdLength;
 tU8 u8CmdCode;
 tU8 *u8CmdDataPtr;
} BSL_HOST_CMD;

typedef struct _BSLResponse
{
 tU8 u8BslRspLength;
 tU8 u8BslRspID;
 tU8 u8BslRspCode;
 tU8 *u8BslRspDataPtr;
} EMV_BSL_RESPONSE;

// locat BSL CMD element out from standard Modbus messaage
enum {
  MD_BSL_ADDRESS_AT,    // 0 request buffer where saved unit address
  MD_BSL_ID_AT,         // 1 request buffer where saved BSL function ID
  MD_BSL_LENGTH_AT,     // 2 request buffer where saved BSL command length
  MD_BSL_CMD_AT,        // 3 request buffer where saved BSL command code
  MD_BSL_CMD_DATA_ST,   // 4 request buffer where saved data start, it may not have data
};

// BSL function call
typedef tReturnStatus (*BslFunc)(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);

typedef struct {
  tU8     u8BslCmdCode;
  BslFunc BslFuncPtr;
} BSL_FUNC_PROCESS;

typedef struct _flashSection
{
 tU32 sectionStartAddr[TOTAL_FLASH_SECTION];
 tU32 sectionSize[TOTAL_FLASH_SECTION];
 MSG_CRC16  sectionCRC[TOTAL_FLASH_SECTION];
 tU8 evenModifier[TOTAL_FLASH_SECTION];
 tU8 totalSection;
 tU8 newFwInStatus;
} FLASH_SECTION;
#define PROG_INFOR_SIZE sizeof (FLASH_SECTION) // 236Bytes total, < 255 = 0xFF u8Size

typedef struct _emv_pw
{
  char HwBoardId;
  char ProductCode;
}  EMV_PASSWORD;
#define PASSWORD_SIZE sizeof (EMV_PASSWORD)

typedef struct _emvID_infor
{
  EMV_PASSWORD HwProdectCode;
  char FwMajorCode;
  char FwMinorCode;
  char FwBetaCode;
}  PRODUCT_ID;
#define EMV_ID_SIZE sizeof(PRODUCT_ID)


#endif  //EMV_FW_UPDATE
