#ifndef JT808_RAM_FILE
#define JT808_RAM_FILE
//#pragma pack(1)
// 2 MSPs information exchange
#define DATA_BUF_SIZE         128       // each block can define read/write number Bytes data

typedef struct
{
    tU8         u8NumUsedBytes;         // less or equal to 8 for this revision
    tU8         u8CtrlBits;             // see definition info exchange u89CtrlBits
    tU8         u8VarData[DATA_BUF_SIZE];
} __INFO_EXCHANG__;
// definition info exchange u8CtrlBits same as u8Type

// chart recorder
#define RECORD_VAR        4             // chart record up to 4 variables
typedef struct
{
    tU32     u32SysAddrRecord;          // record systemBuffer address
    tU8      u8SysType;                 // byte -> 1 = float, 2 = int, 3 = u32(high to low) 4 = time,
    tU8      u8NumBytes;                // number bytes for this varibale
} chartRecInfo;

typedef struct
{
    Calendar  startTime;                // record start from this time, if no time in record, each record is distance at minutesPerRecord
    Calendar  endTime;                  // last record end at this time
    tU32      u32StartPtr;              // where record start, 128K RAM need 3 bytes, give 4 Bytes, byte3 is not used
    tU32      u32EndPtr;                // where record end
    tU32      u32MaxRecords;            // 128K RAM can hold how many record, record can loop over write, this is the limit not loop over
    tU32      u32WriteIdx;              // number records recorded
    tU32      u32ReadIdx;               // number records be read out, or memory is free.
    chartRecInfo varInfo[RECORD_VAR];   // at this revision set to 4, up to 4 element set up as one records.
    tU8       u8BitStatus;              // bit0 = record on/Off, bit1 = roundBuffWt, bit2 = recordHasTime
    tU8       u8BytesPerRecord;         // reference to itemInfo = 4 * 4(float) = 16 bytes, 3 * 4(float) + 8(Calender) = 20
    tU8       u8MinutesPerRecord;       // if records no time, each record distance from this
    tU8       u8EvenGap1_Fill;          // make the structure even address
} __CHART_RECORD__;

typedef union 
{
    tU16      u16DaTime[2];             // [0] = HA_AI ADC count.  [1] = Time count
    tU32      u32HsAiDT;                // return data as a u32 data
} __HSAI_DT__;

typedef struct
{
    tF32      f32MspCalValueIn;         // use this for MSP calibration ADC, the input value
 __HSAI_DT__  hsAi[6];                  // plunger hit water 6 data convertion data and time count
    tU32      u32FallPlngStrT;          // plunger fall start time count
    tU32      u32RisePlngStrT;          // plunger rise start time count
    tU32      u32ArrivePlngT;           // plunger arriver switch change the state time count
} __API1_PLUNGER__;
#define PLNG_VAR_SIZE     sizeof(__API1_PLUNGER__) // plunger lift application variable used buffer side

// PT or RTD varaibles
typedef struct
{
    tF32  f32RtdLeakageCnt;
    tU32  u32RtdA4A5Cnt;
    tU32  u32RtdA3A4Cnt;
    tU32  u32RtdA0A1Cnt;
    tF32  f32RtdCalcOhms;
    tF32  f32PtUndampUntrim;
    tF32  f32PtLive;
    tF32  f32PtLRL;
    tF32  f32PtURL;
    tU8  u8PtOldUnits;
    tU8  u8CtrlPtDef;
} __RAM_PT__;

// calibration
typedef struct
{
    tF32  f32CalSetVal;
    tU16  u16ExecuteCal;
    tU16  u16SetCalType;
} __CAL__;

// diagnostice
typedef struct
{
    tU16  u16CrcErrCnt;
    tU16  u16FramingErr;
    tU16  u16GoodMsgCnt;
    tU16  u16NoiseErr;
    tU16  u16OverrunErr;
    tU16  u16XmitBusyCnt;
    tU16  u16XmtStatus[6];
    tU8   u8DiagStatus[4];
    tU8   u8ChgeItem[CHG_MAX_ITEMS];
    tU8   u8Idx;
} __DIAG__;

// system status or power control
typedef struct
{
    tF32      f32FbdTemp;
    tF32      f32BatVolt;
    tF32      f32SolarVolt;
    tS16      s16AnalogInCnt[2];
    tU16      u16AcPressure[2];
} __RAM_XMT__;

// Sensor 1 and 2 DP varibles
typedef struct
{
    tF32  f32DpUndampUntrim;
    tS32  s32RawBrVolts;
    tS32  s32RawDPVal;
    tS32  s32RawVzero;
    tS32  s32RawVref;
    tF32  f32DpLive;
    tF32  f32ReverseDp;
    tF32  f32DpLRL;
    tF32  f32DpURL;
    tU8  u8CtrlDpDef;
    tU8  u8DpOldUnits;
} __RAM_DP__;

// Sensor 1 and 2 SP varibles
typedef struct
{
    tF32  f32SpUndampUntrim;
    tS32  s32RawSpVal;
    tF32  f32SpLive;
    tF32  f32SpLRL;
    tF32  f32SpURL;
    tU8  u8CtrlSpDef;
    tU8  u8SpOldUnits;
} __RAM_SP__;

// sensor 1 and 2 ST variables
typedef struct
{
    tF32  f32StLive;
    tU8  u8RawStCnt[4];
    tU8  u8StOldUnits;
    tU8  snsStGapEvenAddr;
} __RAM_ST__;

// coil in modbus or 3095FB, system level reset and test
typedef struct
{
    tU8  u8CtrlMappingDef;
    tU8  u8CtrlLcdDef;
    tU8  u8SelfTest;
    tU8  u8ModbusCal;
    tU8  u8CtrlSec1Def;
    tU8  u8CtrlSec2Def;
    tU8  u8CtrlSensorDef;
    tU8  u8CtrlTrimDef;
    tU8  u8MasterReset;
    tU8  ctrGapEvenAddr;
} __RAM_CTRL__;

typedef struct
{
  tU8  u8optDo;
  tU8  u8FrmLen;
  tU8  u8ToLen;
}RAM_DATA_PROC;
typedef tU8 (*rtWtRam)(RAM_DATA_PROC *rwVarInfo);
#define RAM_FUNC  rtWtRam

// define the options
#define NOTHING_TO_DO   0
#define CPY_SNS1_4LCD   BIT1
#define CPY_SNS2_4LCD   BIT2
#define WT_INFOA        BIT3
#define WT_INFOB        BIT4
#define WT_INFOC        BIT5
#define WT_INFOD        BIT6

// SPI access stucture
typedef struct
{
    tU32 u32RamAddr;       // start address
    tU8  *u8DataAddr;      // where to get data
    tU8  u8cnt;            // number bytes total to exchange, not over 255 bytes
    tU8  u8Type;           // what type of exchange, same as u8cmd, same as, u8CtrlBits
    tU8  u8Opt;            // option to do any additional porcess or not
    RAM_FUNC procFunc;      // what process need to do.
} RAM_SPI_ACCESS;

#define RAM_ACCESS_SIZE    sizeof(RAM_SPI_ACCESS)

// 5638 RAM data
typedef struct
{
    tU32 u32HsCnts;                  // HSC counter
    tF32 f32SolarV;               // solar power voltage
    tF32 f32BatV;                 // battery voltage
    tU32 u32Op5638Status;               //Msp5638 operation status
} __F5638_PVS__;

typedef struct
{
    tF32  f32DpLive;
    tF32  f32SpLive;
    tF32  f32StLive;
    tF32  f32PtLive;
} __F5438A_PVs__;


#endif  // JT808_RAM_FILE
