#ifndef BASICS_TYPE_DEF
#define BASICS_TYPE_DEF
//=============================================================================
// Header: Basics type definition
// Date Time: 1/26/2013 2:46 PM
// Author: Xuedong Liu
//
//=============================================================================
// pragmas
#pragma language = extended

// #includes
// Not Apply

// debug trace use variable u8Temp
#define TRACE_BUFFER_SIZE   64
#define WTVALUE(x) u8DebugTrace[TracePtr++] = (x); TracePtr &= TRACE_BUFFER_SIZE - 1    // debug

// constant definitions
// hardware revision
//#define HW_REV2 1  // tracking the changes from HW rev1 to HW rev 2
// generaic for all
#define PACKED_ASCII_SPACE (tU8)0x20 // write space to make size right to legacy host format.
#ifndef IAR_TOOLS
#define  BUILDDAY    5
#define  BUILDMNTH   10
#define  BUILDYEARH  20
#define  BUILDYEARL  11
#define  BUILDMAJOR  (tU8)0x00
#define  BUILDMINOR  (tU8)0x01
#define  BUILDBETA   (tU8)0x01
#endif

#define  DLE  (tU8)0x10
#define SOH     (tU8)0x01
#define  STX  (tU8)0x02
#define  ETX  (tU8)0x03

/************************************************************
* STANDARD BITS
************************************************************/
#ifndef MASTER5638_INCLUDE

// other way to use A to F
#define BIT10               (tU16)0x400
#define BIT11               (tU16)0x800
#define BIT12               (tU16)0x1000
#define BIT13               (tU16)0x2000
#define BIT14               (tU16)0x4000
#define BIT15               (tU16)0x8000
#endif

#define SHIFT_8BITS         8
#define SHIFT_1BIT          1  // times or divided by 2
#define SHIFT_4BITS         4
#define ODD_MASK            (tU16)1  // test a number is even or odd

#define NUL                 '\0'      // TEXT ASCII NUL.
#define OFF                 0
#define ON                  (tBoolean)1

#ifndef FALSE
#define FALSE               (tBoolean)0
#define TRUE                (tBoolean)1
#endif

#define NO                  0
#define YES                 1
#define PASSED              0
#define FAILED              1
#define  FOREVER        for (;;)    // Loop forever, or until break.  */

#define TU24_MASK           0x00FFFFFF  // lower 24 bits used
#define lengthof(X)         (sizeof (X)/sizeof (X)[0])

#define NUM_U16_UP_LIMIT    (tU16)65535
// this define for hart standard types as following
#define MakeByteEnum(e) /*lint -save -e944 */        (((e) <= 127) ? (e) : ((e) - 256))  /*lint -restore */

// field update firmware protocol user defined function code
#define MD_CMD_FC65    (tU8)0x65  // Modbus field update firmware user defined function code
#define MD_CMD_FC66    (tU8)0x66  // Modbus access sensor coefficients user defined function code
#define WRONG_WDTPW            0x5000

// hart Protocol and Standards
#define HART_PREAMBLE     (tU8)0xff    // Preamble character
#define THIS_DEV_PVS_NUM  (tU8)4
/* The following defines are indexes into the top and bottom sensorStrings */
#define PV_IDX                           (tU8) 0     // default is DP
#define SVAP_IDX                         (tU8) 1     // default is SP
#define SVGP_IDX                         (tU8) 2     // default is SP
#define TV_IDX                           (tU8) 3     // default is PT
#define QV_IDX                           (tU8) 4     // default is ST

typedef enum
{
  TP_RESERVED = 0,
  TP_lower = 1,           // HART defined lower trim point
  TP_upper = 2,           // HART defined upper trim point
  TP_upper_and_lower = 3  // HART defined upper and lower trim point, it may be a point between lower an dupper
} tTrimPoint;

enum
{
  sysCalPtZero, // = 0;     // calibrate point zero
  sysCalPtMid1, // = 1;     // calibrate mid point 1
  sysCalPtMid2, // = 2;     // calibrate mid point 2
  sysCalPtMid3, // = 3;     // calibrate mid point 3
  sysCalPtSpan, // = 4;     // calibrate span
};

enum
{
  sysCalTypeDp, // = 0;     // calibrate type DP = differential pressure
  sysCalTypeSp, // = 1;     // calibrate type SP = static pressure
  sysCalTypePt, // = 2;     // calibrate type PT = RTD process temperature
  sysCalTypeR0, // = 3;     // calibrate type R0 = RTD feature board R0
  sysCalTypeSt, // = 4;     // calibrate type ST = Sensor temperature, not implement
};

typedef enum
{
   RS_good = 0,
   SUCCESSFUL_OPERATION = 0,
   RS_canTimeout = 0,
   RS_firstEntry = 1,
   RS_RDB_VERSION_UNMATCH = 1,
   MEMORY_WRITE_CHECK_FAILED = 1,
   MEMORY_READ_CHECK_FAILED = 1,
   RS_rtd_error = 2,
   RS_invalidSelection = 2,
   RS_lcdFull = 2,
   RS_pollAddrUnknown = 2,
   RS_paramTooLarge = 3,
   VOLTAGE_CHANGE_DURING_PROGRAM = 3,
   RS_lcdNotPresent = 3,
   RS_slaveCommand = 3,
   RS_753Command = 4,
   RS_paramTooSmall = 4,
   RS_canFail = 4,
   BSL_LOCKED = 4,
   RS_incorrectByteCount = 5,
   BSL_PASSWORD_ERROR = 5,
   RS_inWriteProtectMode = 7,
   RS_setToNearest = 8,
   RS_warningUpdateFailure = 8,
   RS_warningEngrUnitsChanged = 8,
   RS_appliedProcessTooLarge = 9,
   RS_invalidAlertNumber = 9,
   RS_databaseEmpty = 9,
   RS_eventExpTimeTooSmall = 9,
   RS_invalidSensorType = 9,
   RS_LRVtooHigh = 9,
   RS_invalidPowerMode = 9,
   EARSE_FLASH_DONE = 9,
   ERASE_FLASH_ONWAITE = 10,
   RS_appliedProcessTooSmall = 10,
   RS_invalidAlertVariableAssignment = 10,
   RS_endOfDatabase = 10,
   RS_storageBroken = 70,
   RS_eventExpTimeTooLarge = 10,
   RS_invalidSensorConnection = 10,
   RS_LRVtooLow = 10,
   RS_invalidLcdMode = 10,
   ERASE_FLASH_DONE_ONESEC = 11,
   RS_databaseReadErr = 11,
   RS_excessCorrection = 11,
   RS_invalidXmtrVarCode = 11,
   RS_invalidHartAddress = 11,
   RS_invalidAlertMode = 11,
   RS_storageChecksumError = 11,
   RS_URVtooHigh = 11,
   RS_databaseSearchErr = 12,
   RS_invalidUnitsCode = 12,
   RS_illegalAddress = 12,
   RS_readingIntervalTooSmall = 12,
   RS_invalidAssignment = 12,
   RS_URVtooLow = 12,
   RS_InvalidSensorTrimCalibrationTypeCode = 12,
   RS_byteCountTooLarge = 13,
   RS_readingIntervalTooLarge = 13,
   RS_invalidDeadBand = 13,
   RS_invalidMode = 13,
   RS_URVandLRVoutOfLimits = 13,
   CMD_FAILED = 0x0d,
   RS_spanTooSmall = 14,
   RS_lowerPushedUpperBeyondLimit = 14,
   RS_alertWinBeyondLimits = 15,
   RS_accessRestricted = 16,
   RS_invalidXmtrVarTrimCode = 17,
   RS_invalidVariableUnitsCode = 18,
   RS_xmtrVarCodeNotAllowed = 19,
   RS_invalidAlertDirection = 28,
   RS_busy = 32,
   RS_cmdNotImplemented = 64,
   RS_fault = 70,
   RS_invalidCanKey = 71,
   RS_nimExecutionErr = 71,
   RS_insufficentBuffer = 72,
   RS_nimInvalidParamErr = 72,
   RS_canCommError = 73,
   RS_undefined_3051smv = 112,
   RS_undefined1_3051smv = 80,
   RER_INVALID_VERSION = 0x20,
   RER_ERROR           = 0x80,
   RER_INVALID_FUNCTION= 0x40,
   RER_NO_MATCH        = 0x10,
   RER_SIGNAL_MISMATCH = 0x08,
   RER_NO_NAME         = 0x04,
   RER_RO_ARRAY        = 0x08,
   RER_INVALID_ARRAY   = 0x04,
   RER_ARRAY_EXCEEDED  = 0x02,
   RER_MORE_DATA       = 0x01,
   RER_SUCCESSFUL_END  = 0x00,
   RER_NO_MORE_DATA    = 0xfe,                  // RER = no more data available
   RS_canSetToNeareastValue = MakeByteEnum(132)
} tReturnStatus;
#define STATUS_SUCCESS  0x01
#define STATUS_FAIL     0x00

//typedef enum
enum  // Hart or can sensor unit code system
{
   U_inH2OAt68F      = 1,
   U_inHgAt0C        = 2,
   U_ftH20At68F      = 3,
   U_mmH20At68F      = 4,
   U_mmHgAt0C        = 5,
   U_psi             = 6,
   U_bars            = 7,
   U_milliBars       = 8,
   U_gramPerSqCm     = 9,
   U_kiloGramPerSqCm = 10,
   U_pascals         = 11,
   U_kiloPascals     = 12,
   U_torr            = 13,
   U_atm             = 14,
   U_userUnit        = 21,
   U_celsius         = 32,
   U_fahrenheit      = 33,
   U_rankine         = 34,
   U_kelvin          = 35,
   U_millivolts      = 36,
   U_ohms            = 37,
   U_volts           = 58,
   U_inH2OAt60F      = 145,
   U_megaPascals     = 237,
   U_inH20At4C       = 238,
   U_mmH20At4C       = 239,
   U_dpCustonUnit    = 240, // new EMV, verify
   U_spCustonUnit    = 241, // new EMV, verify
   U_ptCustonUnit    = 242, // new EMV, verify
   U_None            = 250,
}; // use to be this type, tUnitsCodes; remove it reduce conversion,

enum
{
  MT_reserved = 0,
  MT_DP,
  MT_SP_AP,
  MT_SP_GP,
  MT_ST,
}; // tMeasureTypeCodes;

enum
{
  ACCESS_reserved = 0,
  WAITE_ALLOW_USE_FLASH_SPI,
  ALLOW_USE_FLASH_SPI,
  WAITE_ALLOW_USE_RAM_SPI,
  ALLOW_USE_RAM_SPI,
}; // two MSP share the SPI bus for FLash and RAM

#define __flash const

// template definitions

// type definitions
typedef char                tS8;       // 8 bits, signed, 8 bits,  range -128 to 127
typedef signed int          tS16;      // Two-byte signed int, 16 bits. range -32768 to 32767
typedef signed long         tS32;      // Four-byte signed long, 32 bits, range -2^31 to 2^31 - 1
//typedef  signed long long    tS64;      // 64 bits, range -2^63 to 2^63 - 1
typedef float               tF32;      // 4-byte IEEE
typedef double              tS64;      // 64 bits, range -2^63 to 2^63 - 1

typedef unsigned char       tBoolean;  // 8 bits,  range 0 to 1, YES/NO, TRUE/FALSE, ON/OFF.
typedef unsigned int        tChecksum;

typedef unsigned char       tU8;       // 8 bits, unsigned, 8 bits,  range 0 to 255
typedef unsigned int        tU16;      // Two-byte unsigned int, 16 bits, range 0 to 65535
typedef unsigned long       tU32;      // Four-byte unsigned long, 32 bits, range 0 to 2^32 - 1
typedef unsigned long long  tU64;      // 64 bits, range 0 to 2^64 - 1

#define SIZEOF_U8           (tU8) 1
#define SIZEOF_U16          (tU8) 2
#define SIZEOF_U24          (tU8) 3           //We use a 3 byte array since we don't have a 3 byte tU24
#define SIZEOF_STRING32     (tU8) 32
#define SIZEOF_STRING24     (tU8) 24          //We use a byte array for our strings
#define SIZEOF_STRING20     (tU8) 20          //We use a byte array for our strings
#define SIZEOF_STRING15     (tU8) 15          //We use a byte array for our strings
#define SIZEOF_STRING16     (tU8) 16
#define SIZEOF_STRING12     (tU8) 12          //We use a byte array for our strings
#define SIZEOF_STRING8      (tU8) 8
#define SIZEOF_STRING6      (tU8) 6           //We use a byte array for our strings
#define SIZEOF_STRING5      (tU8) 5
#define SIZEOF_FLOAT        (tU8) sizeof(tF32)
#define SIZEOF_INT          (tU8) sizeof(tS16)
#define SIZEOF_U32          (tU8) 4           //We use a 4 bytes array for tU32
#define SIZEOF_B10          (tU8) 10          //10 bytes data
typedef struct
{
 tU8 u8VerDay;
 tU8 u8VerMonth;
 tU8 u8verYearH;
 tU8 u8verYearL;
 tU8 u8ProductID[3];
 tU8 u8VerMajor;
 tU8 u8VerMinor;
 tU8 u8VerBeta;
 tU8 u8ProductIDCode;
 tU8 u8EvenAddr;      // unused
} FWVersionInfor;

// define error bits and flags
// variable = u32DiagStatus1; Modbus FPreg address=7404 or 0407 or Holding reg address=119 0r coil address=50 to 65
//     using 16bits register u16XmtStatus[0] because define is in bit0 to bit15
#define  CAL_PASS_FLAG        (tU16)BIT15  //Calibration pass Flag, set/release when time passed
#define  CAL_FAIL_FLAG        (tU16)BIT14  //Calibration pass Flag, set/release when time passed
#define  PV_OUT_LIMITS        (tU16)BIT13  //PVs > specification, set/release when time passed
#define  DP_ABOVE10URL        (tU16)BIT12  //DP signal above Upper Range Limit + 10%
#define  DP_ABOVEURL          (tU16)BIT11  //DP signal above Upper Range Limit
#define  DP_ABOVEURV          (tU16)BIT10  //DP signal above Upper Operating Limit
#define  DP_BELOWLRV          (tU16)BIT9   //DP signal below Lower Operating Limit
#define  DP_BELOWLRL          (tU16)BIT8   //DP signal below Lower Range Limit
#define  DP_BELOW10LRL        (tU16)BIT7   //DP signal below Lower Range Limit - 10%
#define  SP_ABOVE10URL        (tU16)BIT6   //SP signal above Upper Range Limit + 10%
#define  SP_ABOVEURL          (tU16)BIT5   //SP signal above Upper Range Limit
#define  SP_ABOVEURV          (tU16)BIT4   //SP signal above Upper Operating Limit
#define  SP_BELOWLRV          (tU16)BIT3   //SP signal below Lower Operating Limit
#define  SP_BELOWLRL          (tU16)BIT2   //SP signal below Lower Range Limit
#define  SP_BELOW10LRL        (tU16)BIT1   //SP signal below Lower Range Limit - 10%
#define  SNS1_UNINSTALLED     (tU16)BIT0   //sensor 1 did not install
// variable = u32DiagStatus1; Modbus FPreg address=7404 or 0408 or Holding reg address=120 0r coil address=66 to 75
//     using 16bits register u16XmtStatus[1] because define is in bit0 to bit15
#define  SNS2_UNINSTALLED     (tU16)BIT15  //sensor 2 did not install
#define  PT_ABOVE10URL        (tU16)BIT14  //PT signal above Upper Range Limit + 10%
#define  PT_ABOVEURL          (tU16)BIT13  //PT signal above Upper Range Limit
#define  PT_ABOVEURV          (tU16)BIT12  //PT signal above Upper Operating Limit
#define  PT_BELOWLRV          (tU16)BIT11  //PT signal below Lower Operating Limit
#define  PT_BELOWLRL          (tU16)BIT10  //PT signal below Lower Range Limit
#define  PT_BELOW10LRL        (tU16)BIT9   //PT signal below Lower Range Limit - 10%
#define  RTD_DISCONNECT       (tU16)BIT8   //RTD is disconnected
#define  ST_ABOVEURL          (tU16)BIT7   //ST signal is above Upper Internal Limit
#define  ST_BELOWLRL          (tU16)BIT6   //ST signal is below Lower Internal Limi
#define  DP_TRIM2MFG_DEF      (tU16)BIT5   //DP trims set to factory default
#define  SP_TRIM2MFG_DEF      (tU16)BIT4   //SP trims set to factory default
#define  RTD_TRIM2MFG_DEF     (tU16)BIT3   //DRTD trims set to factory default
#define  UPDATE_FW_ONLY_DO    (tU16)BIT2   //when do the update firmware only do these tasks, speed up
#define  RTD_FAIL_USE_LAST_V  (tU16)BIT1   //when set this bit = 1 RTD fail, use last good number, if bit = 0, use used define the number, keep the user define number unchange
#define  HSC_USE_FILTER       (tU16)BIT0   //when = 1 HSC filter enable,  = 0 HSC filter disable
// variable = u32DiagStatus2; Modbus FPreg address=7405 or 0409 or Holding reg address=121 0r coil address not allocate
//     using 16bits register u16XmtStatus[2] because define is in bit0 to bit15
#define  SNR_DAC_UPDATE       BIT15        // sensor DAC updates = 1 error = 0
#define  DP_ZERO_CALED        BIT14        // DP Zero calibration done = 1, reset factory = 0 
#define  DP_SPAN_CALED        BIT13        // DP Span calibration done = 1, reset factory = 0
#define  SP_ZERO_CALED        BIT12        // SP Zero calibration done = 1, reset factory = 0
#define  SP_SPAN_CALED        BIT11        // SP Span calibration done = 1, reset factory = 0
#define  RTD_ZERO_CALED       BIT10        // RTD Span calibration done = 1, reset factory = 0
#define  RTD_SPAN_CALED       BIT9         // RTD Span calibration done = 1, reset factory = 0
#define  MSP_AI0_CALED        BIT8         // MSP A0 input calibration done = 1
#define  MSP_AI1_CALED        BIT7         // MSP A1 input calibration done = 1
#define  MSP_VCC_CALED        BIT6         // MSP VCC calibration done = 1
#define  MSP_TEMP_CALED       BIT5         // MSP Temp calibreation done = 1
#define  RTD_2WIRE_ON         BIT4         // 2Wire RTD connected = 1, other = 0
#define  RTD_3WIRE_ON         BIT3         // 3wire RTD connected = 1, other = 0
#define  SNS_EST_TEMP80C      BIT2         // sensor estimate temperature greater than 80C = 1, less = 0
#define  FB_WT_PROTECT        BIT1         //Write Protect Status
#define  SNS_EST_TEMP40C      BIT0         // sensor estimate temperature less than -40C = 1, greater = 0
// variable = u32DiagStatus2; Modbus FPreg address=7405 or 0410 or Holding reg address=122 0r coil address not allocate
//     using 16bits register u16XmtStatus[3] because define is in bit0 to bit15
#define  FB_REV_UNKNOW        (tU16)BIT15  //new, Hardware version is unkown
#define  WT_FLASH_ON          (tU16)BIT14  //new, write to flash in progress, do not do it again 
#define  ADC5638_START_ON     (tU16)BIT13  //used in mutiple place  
#define  RS485_SPLW_LOOK      (tU16)BIT12  //new, RS485 char look speed slower then Rx speed
#define  RS485_PRO_SLOW       (tU16)BIT11  //new, process slower than RTS timer
#define  ADS_DIAG_FAILED      (tU16)BIT10  //new, ADS1243 diagnotice walk 1 and walk 0 failed
#define  RESET_SOLV_CALDEF    (tU16)BIT9   //reset solar volt calibration offset to default 
#define  RESET_R0_CAl_DEF     (tU16)BIT8   //Reset R0 calibration to default
#define  RESET_BAT_CAL_DEF    (tU16)BIT7   //reset baterry calibation offset to default
#define  RESET_MSPT_CAL_DEF   (tU16)BIT6   //Reset MSP T C calibration offset to default
#define  RESTART_MSP_FW       (tU16)BIT5   //changed address, make MSP resetart, keep power On
#define  RESET_AI0_CAl_DEF    (tU16)BIT4   //Reset AI0 calibration offset to default
#define  RESET_AI1_CAL_DEF    (tU16)BIT3   //Reset AI1 calibration offset to default
#define  CAL_RTC_START        (tU16)BIT2   //calibration RTC start, enable the ACLK output
#define  CAL_BOARD_RO         (tU16)BIT1   //unused, new
#define  CAL_MSP_TEMPERATURE  (tU16)BIT0   //unused, new

// variable = u32DiagStatus3; Modbus FPreg address=7406 or 0411 or Holding reg address=123 0r coil address not allocate
//     using 16bits register u16XmtStatus[4] because define is in bit0 to bit15
#define RESET_DP_SPAN_TRIM   (tU16)BIT15  //new, reset DP trim to fatory default
#define RESET_SP_SPAN_TRIM   (tU16)BIT14  //new, reset SP trim to fatory default
#define HAS_GOOD_PT          (tU16)BIT13  //new, define the RTD ADC is good
#define RESET_RTD_SPAN_TRIM  (tU16)BIT12  //new, reset RTD trim to fatory default
#define RESET_TRIMS_4CAL     (tU16)BIT11  //new, reset alll trims to factory default
#define SYS_NORMAL_START     (tU16)BIT10  //new, system normal start or restart
#define DP_USER_UNITS_ENABLE (tU16)BIT9   //new, enable user unit, has information does not means in use
//#define PT_SAMPLE_DONE       (tU16)BIT8   //New, RTD Sampleing once done, can start next sample
#define SP_USER_UNITS_ENABLE (tU16)BIT7   //new, enable user unit, has information does not means in use
#define RESET_RTD_AB_NUM     (tU16)BIT6   //new, RTD conefficient reset to factory default
#define RESET_xRV2LIMITS     (tU16)BIT5   //new, operation limit reset to limits
#define RESET_ALL_DAMPING    (tU16)BIT4   //new, reset dampling to 4 second
#define CTRL_12V_ON          (tU16)BIT3   //new, 1 == 12 v on, 0 = 12v off
#define RESET_DP_ZERO_TRIM   (tU16)BIT2   //new
#define RESET_SP_ZERO_TRIM   (tU16)BIT1   //new
#define RESET_PT_ZERO_TRIM   (tU16)BIT0   //new

//calibration battery
#define DONE_SET_CAL_NUM      0
#define CAL_BAT_OFFSET        1
#define CAL_BAT_SLOP          2

#define  HAS_GOOD_ALL_PVS     (HAS_GOOD_DP + HAS_GOOD_SP + HAS_GOOD_PT + HAS_GOOD_ST) //new, all process varibales good data is aviable
// variable = u32DiagStatus3; Modbus FPreg address=7406 or 0411 or Holding reg address=123 0r coil address not allocate
//     using 16bits register u16XmtStatus[5] because define is in bit0 to bit15
// f32DiagStatus3 has 32 bits free

//define u16RTDfailToSt bits
#define FAIL_TO_USER_DEFINED_V    BIT0
#define HEC_ENABLED               BIT1
#define RESET_RTD_INITIAL_V       BIT2

// SupperModule CAN Sensor status defines
// u8CanDetailStatus[1]
#define  DP_INACCURACY_LO     BIT15 //dp Measurement Inaccuracy Warning Lo
#define  DP_INACCURACY_HI     BIT14 //dp Measurement Inaccuracy Warning Hi
#define  SP_INACCURACY_LO     BIT13 //sp Measurement Inaccuracy Warning Lo
#define  SP_INACCURACY_HI     BIT12 //sp Measurement Inaccuracy Warning Hi
#define  STDP_INACCURACY_LO   BIT11 //stdp Measurement Inaccuracy Warning Lo
#define  STDP_INACCURACY_HI   BIT10 //stdp Measurement Inaccuracy Warning Hi
#define  STSP_INACCURACY_LO   BIT9  //stsp Measurement Inaccuracy Warning Lo
#define  STSP_INACCURACY_HI   BIT8  //stsp Measurement Inaccuracy Warning Hi
// u8CanDetailStatus[0]
#define  DP_CLIP_LO           BIT7  //dp Measurement Clip Warning Lo
#define  DP_CLIP_HI           BIT6  //dp Measurement Clip Warning Hi
#define  SP_CLIP_LO           BIT5  //sp Measurement Clip Warning Lo
#define  SP_CLIP_HI           BIT4  //sp Measurement Clip Warning Hi
#define  STDP_CLIP_LO         BIT3  //stdp Measurement Clip Warning Lo
#define  STDP_CLIP_HI         BIT2  //stdp Measurement Clip Warning Hi
#define  STSP_CLIP_LO         BIT1  //stsp Measurement Clip Warning Lo
#define  STSP_CLIP_HI         BIT0  //stsp Measurement Clip Warning Hi
// u8CanDetailStatus[3]
#define  DP_IN_CLIP_LO        BIT15 //dp Input Clipped Warning Lo
#define  DP_IN_CLIP_HI        BIT14 //dp Input Clipped Warning Hi
#define  SP_IN_CLIP_LO        BIT13 //sp Input Clipped Warning Lo
#define  SP_IN_CLIP_HI        BIT12 //sp Input Clipped Warning Hi
#define  STDP_IN_CLIP_LO      BIT11 //stdp Input Clipped Warning Lo
#define  STDP_IN_CLIP_HI      BIT10 //stdp Input Clipped Warning Hi
#define  STSP_IN_CLIP_LO      BIT9  //stsp Input Clipped Warning Lo
#define  STSP_IN_CLIP_HI      BIT8  //stsp Input Clipped Warning Hi
// u8CanDetailStatus[2]
#define  DP_IN_ASC_REDUN      BIT7  //dp Input ASIC Redundancy Failure
#define  SP_IN_ASC_REDUN      BIT6  //sp Input ASIC Redundancy Failure
#define  STDP_IN_ASC_REDUN    BIT5  //stdp Input ASIC Redundancy Failure
#define  STSP_IN_ASC_REDUN    BIT4  //stsp Input ASIC Redundancy Failure
#define  DP_IN_UPDATE_MISSING BIT3  //dp Input ASIC Update Missing
#define  SP_IN_UPDATE_MISSING BIT2  //sp Input ASIC Update Missing
#define  STDP_IN_UPDATE_MISSING  BIT1  //stdp Input ASIC Update Missing
#define  STSP_IN_UPDATE_MISSING  BIT0  //stsp Input ASIC Update Missing
// u8CanDetailStatus[5]
#define  SM_NV_CORRUP_W       BIT15  //nv Corrupt warning
#define  DP_POTEN_RING_OPEN   BIT14  //dp Potential Open Sensor Ring
#define  DP_OVERFLOW          BIT13  //dp Input ASIC Overflow
#define  SP_OVERFLOW          BIT12  //sp Input ASIC Overflow
#define  STDP_OVERFLOW        BIT11  //stdp Input ASIC Overflow
#define  STSP_OVERFLOW        BIT10  //stsp Input ASIC Overflow
#define  SM_UNUSED            BIT9   //Unused
#define  SM_FACTORY_ENABLE    BIT8   //Factory mode
// u8CanDetailStatus[4]
#define  SM_RAM_CORRUP        BIT7  //ram Data Corrupt Failure
#define  SM_FW_DATA_CORRUP    BIT6  //program Data Corrupt Failure
#define  SM_STACK_OVERFLOW    BIT5  //stack OverFlow Failure
#define  SM_REGISTER_FAIL     BIT4  //processor Register Failure
#define  SM_ALU_FAIL          BIT3  //processor ALU failure
#define  DP_ACTUAL_RING_OPEN  BIT2  //dp Actual Open Sensor Ring Failure
#define  SP_OPENED            BIT1  //sp Open Sensor Failure
#define  SM_NV_CORRUP_FAIL    BIT0  //nv Corrupt Failure
// u16SensorStatus; u8CanSensorStatus
#define  SM_BAD_SEN_NOT_LMT   16    //BAD, Sensor Failure, Not Limited
#define  SM_BAD_SEN_LO        17    //BAD, Sensor Failure, LO Limited
#define  SM_BAD_SEN_HI        18    //BAD, Sensor Failure, HI Limited
#define  SM_BAD_SEN_CONT      19    //BAD, Sensor Failure, Constant
#define  SM_UNCERTN_NOT_LMT   80    //UNCERTAIN, Sensor Conversion not accurate, Not Limited
#define  SM_UNCERTN_LO        81    //UNCERTAIN, Sensor Conversion not accurate, Lo Limited
#define  SM_UNCERTN_HI        82    //UNCERTAIN, Sensor Conversion not accurate, Hi Limited
#define  SM_UNCERTN_NORM      88    //UNCERTAIN, Sub-normal, Not Limited
#define  SM_GOOD_NOT_LTM      128   //GOOD, Non-Specific, Not Limited

// process, interface, exceptional interfacetion flag definitions
// Process flags register u8Layer2TaskScheduler definitions
#define  NOT_USE_BIT0           BIT0
#define  NOT_USE_BIT1           BIT1
#define  NOT_USE_BIT2           BIT2
#define  NOT_USE_BIT3           BIT3
#define  NOT_USE_BIT4           BIT4
#define  NOT_USE_BIT5           BIT5
#define  NOT_USE_BIT6           BIT6
#define  NOT_USE_BIT7           BIT7

// MSP430F5638  flag u8Layer2TaskScheduler defines
#define  TX_RAM_DATA       BIT0
#define  PRO_LCD_UPDATE_REQ     BIT1  // LCD Update Request
#define  CHARGE_BAT_HS_AI       BIT2  // does battery charge decision, calculate HS AI
#define  SEND_DATA_2RADIO       BIT3  // Radio send data message once, or setup Radio
#define  RD_RAM_DATA_DONE       BIT4  // MSP430F5438A done read the RAM data
#define  USB_MD_REQ_READY       BIT5  // start to process the MD request & create the response
//#define  RX_RD_RAM_DATA         BIT6  // start to read and Process RAM DATA MSP430F5438A and 5638 same
#define  DONE_TX_RADIO_MSG      BIT7  // Radio done tx entrie message, sleep radio.

// MSP430F5638 flag u8Layer1TaskScheduler defines
#define  USB_RECEIVED_CHARS     BIT0  // USB port has received the chars
#define  RS485_BASP_REQ_READY   BIT1  // for BSAP protocal
#define  START_MSP_ADC          BIT2  // start to convert the AIs, MSP-temp, Battery-V
#define  READ_OTHER_RAM_DATA    BIT3
#define  INTERF_SEND_LCD_CTRL1  BIT4  // Send data to LCD CTR1 Start
#define  RADIO_CHAR_TIMEOUT     BIT5  // check pluger application driver, run one take once
#define  RADIO_RECEIVED_CHARS   BIT6  // radio port has received the chars
//#define  TIMEOUT_RETRY_TX       BIT7  // MSP430F5438A send ACK to the request SPI RAM BUS        

// Interface flags register u8OtherTaskScheduler definitions
#define  DYNAMIC_WT_IMFOA       BIT4  // dynamic write data to MSP infoA flash
#define  DYNAMIC_WT_IMFOB       BIT5  // dynamic write data to MSP infoB flash
#define  DYNAMIC_WT_IMFOC       BIT6  // dynamic write data to MSP infoC flash
#define  DYNAMIC_WT_IMFOD       BIT7  // dynamic write data to MSP infoD flash

// bit5 to 7 are free
// Interface flags register u8DoDiagErrorProcess definitions
#define CALIB_PROCESS_ON        BIT0  // excute calibration -> DP, SP, PT; points -> zero, mid1, mid2, mid3, span
#define CHECK_CHART_RECORD      BIT1  // chech the chart record function, do average, writ eto RAM
#define RS485_CHAR_TIMEOUT      BIT2  // RS485 Port Chat Time expired
#define RS232_CHAR_TIMEOUT      BIT3  // RS232 Port Chat Time expired
#define ERASE_FLASH_CAN_START   BIT4  // Erase more flash memory can start
#define CHART_WRITE_RAM_OP      BIT5  // chart record write to RAM operation
#define FLASH_WT_ERASE_CK       BIT6  // do Flash operation
#define UPDATE_FW_PAGE_PROG     BIT7  // page may not program to flash yet
#define RESET_USB_MSP           BIT7  // page may not program to flash yet

#define ALL_FLAGS_ZERO          0x00  // put all flag in initial state
#define USB_PORTID              0x00  // MSP430F5638 use as USB
#define RS232_PORTID            0x01  // MSP430F5438A use as RS232, MSP430F5638 use as Radio
#define FSK_PORTID              0x02  // MSP430F5438A use as FASK,  MSP430F5638 use as USB temp
#define EMV_NUM_COMM            0x03  // on 5638 side USB, Radio, one use temp buffer, it is usefull for USB
#define USB_PORTIN              0x00  // MSP430F5638 use as USB prot
#define RADIO_PORTID            0x01  // MSP430F5638 use as wireless port
// u16UsedPort defines
//#define USE_USB_PORT          BIT0  //
#define USE_RS232_PORT          BIT1  // use the MSP430F5438A RS232
#define USE_FSK_PORT            BIT2  // use the MSP430F5438A FASK
#define USE_USB_PORT            BIT3  // use the MSP430F5638 USB prot
#define USE_RADIO_PORT          BIT4  // use the MSP430F5638 wireless port
// u16UsedPort[Layer Define]
#define LAYER_1ST               0     // use array element 1, as the port use flage
#define LAYER_2ND               1     // use array element 2, as the port uss flage
#define TOTAL_FLAGE_ARRAY       2     // total elements array to indicate the port use flage

//define u8DiagStatus bits
#define CLEAR_CALA_DONE                     BIT1

typedef struct {
  tU8   u8LookUnit;         // look defined pressure unit code
  tF32  f32Factor2Std;      // factor bring live from look unit to standard PSI unit
} P_UNIT_CONVERT_TABLE;

typedef struct {
  tU8   u8LookUnit;         // look defined temperature unit code
  tF32  f32Numer2Std;       // numerator convert from look unit to standard C unit
  tF32  f32Denomin2Std;     // denominator convert from look unit to standard C unit
  tF32  f32Offset2Std;      // offset convert from look unit to standard C unit
} PT_UNIT_CONVERT_TABLE;

// FSK port switch protocoll when see consective error chars
#define FSK_ERR_xCHARS_SWITCH  1       // error count start from 0, when see two consective error chars, switch protocol

typedef struct {
  tU8 u8PortID;                   // USB u8PortID = 0; FSK u8PortID = 1;
  tU8 u8TxStatus;                 // Tx status, status are MD_RTU, MD_ASBII, HART, BASP, READ
  tU8 u8IncomePtr;                // index of saveing next received char.
  tU8 u8LookCharPtr;              // index of drivers looking char.
  tU8 u8DriverStatus;             // status which driver looked received char, what standard message received
  tU8 u8RxCharTimeOutStatus;      // Rx start inter char timeout, inter char time happen or not.
  tU8 u8SetUSBAt;
  tU8 u8TargetPwmHiCnts;          // defined in MSP5438A side 
  tU8 u8TargetPwmLowCnts;         // defined in MSP5438A side 
  tU8 u8EvenAddr;                 // unused
} COMM_ENV;                       // communication port process resource or environments

typedef struct {
  void *eepVarAddr;               // which veriable to read or write
  COMM_ENV *portEnv;              // port information -> USB
  tU8 u8RspBufPtr;                // location start with put data in read or take data in write
  tU8 u8FuncCode;                 // function is read or write
  tU16 attrib_ctrl;               // what is control byte set at
  tU8 u8NewUnitCode;              // change to this unit code, if 3808, map to the system unit code  
  tU8 u8evenAddr;                 // unused
} ACCESS_VER_INFO;

typedef struct {
  tU16  u16CanProtoRev;           // put CAN protocol revision
  tU8   *u8DataPtr;               // data buff pointer
  tU8   u8CanState;               // CAN state number
} CAN_REQ_RESP_CTL;

typedef void (*canReqResp)(CAN_REQ_RESP_CTL *inOutInfo);
typedef tU8 (*rtWtVar)(ACCESS_VER_INFO *rwVarInfo);
#define tMDFunc  rtWtVar
typedef void (*dmaTxFunc)(tU8 *bufPtr, tU16 msgSize);
typedef struct {
  tU8 u8ProtId;
  tU8 U8EvenAddr;         // unused
  dmaTxFunc damTxDrv;
} COMM_DAM_TX;

typedef void (*startRtsTm)(void);
typedef struct {
  tU8 u8ProtId;
  startRtsTm StRtsTm;
} COMM_RTS_TIMER_FUNC;
// CAN sensor Request/response structure
typedef struct {
  tU8 u8CanCommState;             // communicate with CAN sensor states
  canReqResp initFunc;            // process request/response function
} SENSOR_INIT;

typedef struct {
  tU8  u8AttrIdx;                 // remember attributrs index, define in mcp2515.h
  tU8  u8Sidl;                    // MCP2515 SIDL register data
  tU8  u8Eid8;                    // MCP2515 EID8 register data
  tU8  u8Eid0;                    // MCP2515 EIDO register data
  canReqResp reqSnrFunc;          // request function
  canReqResp respSnrFunc;         // response function
  tU8  u8Option;                  // option,
  tU8  u8UnserGap;
} ACCESS_ATTRIBUTE;               // SuperModule Read, write and publish,  request and response structure

typedef struct {
  tF32 f32DampTime;               // B -> damping Time value
  tF32 f32OldValue;               // y(n-1) -> damped value
  tF32 f32NewValue;               // x(n) -> current sample value, dampling function is y(n) = B*x(n) + (1-B)*y(n-1)
  tF32 f32TrimOffset;             // PV trim offset, b, calculate offset when in the limit
  tF32 f32TrimSlop;               // PV trim slop, a, calculate slop when in the limit
  tF32 f32TrimTarget;             // to get trim, user enter target, trim function is y(n) = a*x(n) + b
  tF32 f32ErrBandLow;             // PV measure to target error band, lower limit, x(n) - target > lower limit
  tF32 f32ErrBandHi;              // PV measure to target error band, high limit, x(n) - target < upper limit
  tF32 f32PvUrl;                  // Pv Upper range limit
  tF32 f32PvLrl;                  // Pv Lower range limit
  tF32 f32UnitsCnvtF;             // in unit and out unit convert factor
  tF32 f32SampingTime;            // PV sampling time in seconds -> in what sec to get a data point
  tU16 u16FullScaleY2;            // PV = URV at Y2 counts
  tU16 u16ScaleSlope;             // PV scale to operating value, slope
  tU16 u16ScaleOffset;            // PV scale to operating value, offset
  tU8  u8InUnit;                  // PV use this unit in live reading before converting function
  tU8  u8OutUnit;                 // PV use this unit in live reading after conversting function
} CAL_PV_STRUC;                   // apply PV deamping and trim, or calculate trims

#define CALI_ZERO_LOW_LIMIT    -9.0f   // -150% from target
#define CALI_ZERO_HI_LIMIT      9.0f   // +150% from target
#define SP_CALI_ZERO_LOW_LIMIT  -20.0f  // -150% from target
#define SP_CALI_ZERO_HI_LIMIT   20.0f   // +150% from target
#define CALI_SPAN_LOW_LIMIT    -0.05f  // -5% from target
#define CALI_SPAN_HI_LIMIT      0.05f  // +5% from target
#define RTD_SPAN_HI_LIMIT       20.0f // from target
#define RTD_ZERO_HI_LIMIT       3.0f  // from target
#define CALI_NON_SPAN_REQ       0.0f   // no minimum span required
#define CALI_MIN_SPAN_SET       2.0f   // minimum span set at 2.0 for reset cal points
#define CALI_REPEAT_TIMES       10
#define AFTER_CAL_ACCURACY      0.05f
#define DEF3095FULL_SCALE       0xffff // default full scale is 65535
#define MFG_DEFAULT_ZERO_TRIM   0.0f   // Set factory default zero trim to 0
#define MFG_DEF_ALLSPAN_TRIM    1.0f   // set all other span trim (mid1, 2, 3) to 1
#define RTD_CVDC_C_VALUE        -0.000000000004183f
#define DEFAULT_ZERO_OFFSET     (tF32)0.0f
#define DEFAULT_SPAN_TRIM       (tF32)1.0f

#define RTD_SAMPLE_INTERVAL     1
#define SNS1_SAMPLE_INTERVAL    2
#define SNS2_SAMPLE_INTERVAL    2
// when change clock, look this again
#define LCD_BASE_HOLD           5
#define LCD_UPDATE_INTERVAL     16  // 0.125Sec/interrupt 16 -> 2Seconds, count is 3sec
#define DATA_EXCHANGE_INTERVAL  LCD_UPDATE_INTERVAL
#define ADC_START_INTERVAL      80

// host send coefficients
#define HOST_SEND_COEF      42  // host send total coefficients size is 42 bytes
enum
{
    WT_TOP_SNS_1PAGE,  //=0
    WT_TOP_SNS_2PAGE,
    WT_TOP_SNS_3PAGE,
    WT_TOP_SNS_4PAGE,
    WT_BOT_SNS_1PAGE,
    WT_BOT_SNS_2PAGE,
    WT_BOT_SNS_3PAGE,
    WT_BOT_SNS_4PAGE,
    RD_TOP_SNS_1PAGE,  //=8
    RD_TOP_SNS_2PAGE,
    RD_TOP_SNS_3PAGE,
    RD_TOP_SNS_4PAGE,
    RD_BOT_SNS_1PAGE,
    RD_BOT_SNS_2PAGE,
    RD_BOT_SNS_3PAGE,
    RD_BOT_SNS_4PAGE,
    VERIFY_TOP_COEF,
    VERIFY_BOT_COEF,
};

#define MFG_ZERO_TRIM   0.0f
#define MFG_SPAN_TRIM   1.0f

// both MSP use them for data exchange
#define CHG_MAX_ITEMS    10     // each time do use interface change upto 10 items
#define UNUSED_ITEM_FILL 0xff   // unused item fill in this, when process end this 

#endif //BASICS_TYPE_DEF
