#ifndef _DEFINE_MODBUS
#define _DEFINE_MODBUS
//=============================================================================
// Header: Define Modbus
// Date Time: 4/19/2013 1:35 PM 
// Author: Xuedong Liu
//
// Copyright (c) 2013  NewGate Instrument
// All rights reserved.
//
//=============================================================================
// constant definitions
// Definition of Modbus message Functions
#define MD_CMD_FC01    (tU8)0x01  // read boolean or Read Output (Coil) Status
#define MD_CMD_FC02    (tU8)0x02  // read boolean or Read Input Status
#define MD_CMD_FC03    (tU8)0x03  // in MVS205, and MVT3808 3095FB, read numerics or Read Output (Holding) Registers
#define MD_CMD_FC04    (tU8)0x04  // Read Input Registers
#define MD_CMD_FC05    (tU8)0x05  // Force Single Coil
#define MD_CMD_FC06    (tU8)0x06  // Preset Single Register
#define MD_CMD_FC08    (tU8)0x08  // only in 3095FB or Loopback Test
#define MD_CMD_FC15    (tU8)0x0F  // only in MVT3808 or Force Multiple Coils
#define MD_CMD_FC16    (tU8)0x10  // in MVS205, and MVT3808 3095FB or Preset Multiple Registers
#define MD_CMD_FC69    (tU8)0x45  // only in 3095FB
#define MD_CMD_FC70    (tU8)0x46  // only in 3095FB

// define attrib_ctrl 16bits 
#define EEP_WT_D        BIT0      // when this set, modbus need to do MSP430 write EEPRON section D   
#define NO_ADDIN_PRO       0      // no additional process need to do 
#define WP_SET          BIT2      // check write-protection fisrt, write or not write, this may be free
#define NDT_WT          BIT3      // when this bit is set, don't direct write to veraible, write varibale by a function
#define NDT_RD          BIT4      // when this bit is set, don't direct read  to veraible, read  varibale by a function
// write MSP5438A eepron A, B, C, D, need change write protection switch. it is enable to write.
#define EEP_WT_A        BIT5      // when this set, modbus need to do MSP430 write EEPRON section A           
#define EEP_WT_B        BIT6      // when this set, modbus need to do MSP430 write EEPRON section B   
#define EEP_WT_C        BIT7      // when this set, modbus need to do MSP430 write EEPRON section C   
#define M5438A_EEP_WRITE  EEP_WT_A | EEP_WT_B | EEP_WT_C | EEP_WT_D   // mask for MSP430F5438A saved Flash data
// write MSP5638 eepron A, B, C, D, need change write protection switch. it is enable to write.
#define EEP_WT56_A      BIT8      // when this set, modbus need to do MSP430 write EEPRON section A           
#define EEP_WT56_B      BIT9      // when this set, modbus need to do MSP430 write EEPRON section B   
#define EEP_WT56_C      BIT10     // when this set, modbus need to do MSP430 write EEPRON section C   
#define EEP_WT56_D      BIT11     // it is free   
#define M5638_EEP_WRITE EEP_WT56_A | EEP_WT56_B | EEP_WT56_C | EEP_WT56_D   // mask for MSP430F5638 saved Flash data

#define ERRBIT         (tU8)0x80

// type definitions
typedef struct _emv_str_regs
{
  void    *eepAddr;         // which eeprom veriable save this value
  tU16    u16MDRegAdd;      // modbus regsiter address
  tU8     u8lenB;           // string length in bytes
  tMDFunc rdWtVariable;     // attribute are bit0 = 1 -> RD, bit1 = 1 -> WD, bit2 = 1 -> WP
  tU16     attrib_ctrl;
} STRING_MD_REGS;// write to this veraible function
       
#define EMV_MD3095_INT_REG_SIZE  2

typedef struct _emv_int_regs
{
  void    *eepAddr;         // which eeprom veriable save this value
  tU16    u16MDRegAdd;      // modbus regsiter address
  tMDFunc rdWtVariable;     // attribute are bit0 = 1 -> RD, bit1 = 1 -> WD, bit2 = 1 -> WP
  tU16     attrib_ctrl;
} EMV_MD_REGS;// write to this veraible function

typedef struct _emv_3095fb_coil
{
  void    *eepAddr;         // which eeprom veriable save this value
  tU16    u16MDRegAdd;      // modbus regsiter address
  tMDFunc rdWtVariable;    // write to this veraible function
  tU16    attrib_ctrl;      // attribute are bit0 = 1 -> RD, bit1 = 1 -> WD, bit2 = 1 -> WP
} EMV_MD_3095FB_COIL;

typedef struct
{
  void     *eepAddr;         // which eeprom veriable save this value
  tU16     u16MDRegAdd;      // modbus regsiter address
  tMDFunc  rdWtVariable;    // write to this veraible function
  tU16     attrib_ctrl;      // attribute are bit0 = 1 -> RD, bit1 = 1 -> WD, bit2 = 1 -> WP
} EMV_MD_3095FB_FLOAT;

typedef struct _emv_coil_bank
{
  const EMV_MD_3095FB_COIL *coil_sec_ptr;
  tU16 bank_size;            // bank register has how many register
} COIL_BANK_DEF;

#define ASCII_CR         (tU8)0x0d
#define ASCII_LF         (tU8)0x0a
#define ASCII_COLON        ':'
#define ASCII_F            'F'
#define ASCII_A            'A'
#define ASCII_0            '0'

#define SHORT_MD_CMD_CNT    4
#define LONG_MD_CMD_CNT     5
enum
{
  u8ASCII_STATE_BEGIN,     // 0 looking for ':' to begin Ascii Frame
  u8ASCII_STATE_HI_NIBBLE, // 1 looking for high order nibble of ascii tU8
  u8ASCII_STATE_LOW_NIBBLE,// 2 looking for low order nibble of ascii tU8
  u8ASCII_STATE_LRC1,      // 3 waiting on LRC1
  u8ASCII_STATE_LRC2,      // 4 waiting on LRC2
  u8ASCII_STATE_CR,        // 5 waiting on CR
  u8ASCII_STATE_LF,        // 6 waiting on LF
};
enum
{
  u8RTU_STATE_ID,           //0+3 looking for modbus ID
  u8RTU_STATE_FC,           //1+3 looking for function code
  u8RTU_STATE_LDATA,        //2+3 waiting long request, after FC, the 5th byte is u8Data field count 
  u8RTU_STATE_SDATA,        //3+3 waiting short request, 4 u8Data filed after FC
  u8RTU_STATE_CRC1,         //4+3 waiting on CRC 1st byte
  u8RTU_STATE_CRC2,         //5+3 waiting on CRC 2nd byte
  u8RTU_STATE_BCNT,         //6+3 waiting on BSL byte count for field update firmware
};
// Rx msg u8Status literals
#define	RXMSG_TIMEOUT         (tU8)0xff  // message timed out
#define	RXMSG_ACTIVE          (tU8)0x02  // new tU8acters rxd
#define	RXMSG_SUCCESS         (tU8)10    // message is in destination
#define	RXMSG_CHECKSUM_ERRR   (tU8)11    // message is in destination

// MVS205 special
typedef tU8 (*MdProcess)(RxMsgStruc *rxStrucPtr, tU8 *u8DataPtr); 

typedef struct {
    tU8     u8SortMDStateNum;
    MdProcess MDStateFuncPtr;
} comm_receive_porcess;

#define MD_3095BROADCAST_ADDR (tU8)0   // when in 3095FB mode, the broadcast address is 0 
#define MD_205BROADCAST_ADDR  (tU8)240 // when in 205 mode, the broadcast address is 240
// when in 3095FB mode address is from 1 to 247
// when in 205 mode, address is from 1 to 237, 0 is unused
enum {
  MD_IDX_ADDRESS,       // 0 request buffer where saved transmitter Modbus Salve Address
  MD_IDX_FC,            // 1 request buffer where saved function code
  MD_IDX_MS_START_REG,  // 2 request buffer where saved high byte of start register
  MD_IDX_LS_START_REG,  // 3 request buffer where saved low byte of start register
  MD_IDX_MS_CNT_REGS,   // 4 request buffer where saved high byte of number registers
  MD_IDX_LS_CNT_REGS,   // 5 request buffer where saved low byte of number registers 
  MD_IDX_WT_DATE_SIZE,  // 6 request buffer where saved data bytes count when writing to registers
  MD_IDX_WT_REG_DATA,   // 7 request buffer where saved 1st byte data when writing to registers
};

#define MD_MVS205_REG_LIMIT   (tU16)110 // actual end register address is 108
#define MD_RD_REG_DATA_CNT    (tU8)2  // response read cmd buffer, the location has data byte counts
#define MD_RD_RSP_DATA_PRT    (tU8)3  // response read cmd buffer, start put data in here
#define MD_WT_MS_START_REG    (tU8)2  // response write cmd buffer, the high byte of start register
#define MD_WT_LS_START_REG    (tU8)3  // response write cmd buffer, the low byte of start register
#define MD_WT_REG_CNT_HIGH    (tU8)4  // response write cmd buffer, how many registers are written, high byte
#define MD_WT_REG_CNT_LOW     (tU8)5  // response write cmd buffer, how many registers are written, low byte

#define MD_FLOAT_SIZE         (tU8)4    // take 4 bytes for each floating data
#define MD_WT_RSP_SIZE        (tU8)6    // Modbus write command response size. it includes, address, FC, Reg(H,L),CNt(H,L)
#define MD_FC8_RSP_SIZE       (tU16)6   // Modbus request Function code 8, do nothing response data same as request
#define MD_FC6_RSP_SIZE       (tU16)8   // Modbus request Function code 6, response data is same as request data

#define MD_ILLEGAL_RSP_SIZE   (tU16)3  // Modbus error response frame size, it includes address, function code, error code
#define MD_ILLEGAL_FC         (tU8)1   // The Function code referenced, JT808 don't support it, or don't know what to do.
#define MD_ILLEGAL_ADDRESS    (tU8)2   // The address referenced in the data field isn't an allowable address
#define MD_ILLEGAL_DATA       (tU8)3   // The value reference in the data field is not allowed

#define MD_CMD6_5_DATA_AT     (tU8)4
#define MD_COIL_TRUE_VALUE    (tU16)0xff00
#define MD_COIL_FALSE_VALUE   (tU16)0x0000
#define MD_CHECK_COIL_TRUE    (tU8)0xff
#define MD_WT_COIL_SIZE       2
#define MD_COIL_READ_BITS     7
// 0 means to access one register
#define MD_DONE_ALL_REGS      0xffff  // count decrease to this value, it means access all registers request asked

#define MD95_ASCII_REG_START  31      // one less then doc register number
#define MD95_ASCII_REG_END    58      // one less then doc register number
#define MD95_U8TOU16_REG_ST   59
#define MD95_U8TOU16_REG_END  60
enum 
{
  REG95_INT_TYPE,     //0
  REG95_FL_TYPE,      //1
  REG_STRING_type,   //2
  REG_UNKNOW_TYPE,
//  REG95_INT_U8TOU16,  //3
}; // for set u8Reg3095Type

enum
{
  SP3095_GP,     // 3095FB use 0 as SP-GP
  SP3095_AP,     // 3095FB use 1 as SP-AP
};
#define DP3095_RANG250H2O   2   // 3095FB -250, +250inH2O range code is 2
#define DP3095_RANG830H2O   3   // 3095FB -830, +830inH2O range code is 3
#define SP3095_RANG800PSI   3   // 3095FB 0, 800PSI  range code is 3
#define SP3095_RANG3626PSI  4   // 3095FB 0, 3626PSI range code is 4
#define PT3095_RNAG1200F    2   // 3095FB -40, 1200F range code is 2


#define HW_REV_LIMIT_MAX            (tU8) 31
#define MFG_CODE_DEFAULT            (tU8) 38
#define HW_REVISION_DEFAULT         (tU8) 1
#define PVT_LABEL_DIST_DEFAULT      (tU8) 38
#define DAY_DEFAULT                 (tU8) 1
#define MONTH_DEFAULT               (tU8) 1
#define YEAR_DEFAULT                (tU8) 0
#define LOW_SIX_BITS                (BIT5 | BIT4 | BIT3 | BIT2 | BIT1 | BIT0)

#define RADIO_DELIMITER_CHAR        (tU8) 0x7e // delimiter, start mark
#define RADIO_HEADER_BYTES          (tU8) 5    // 0 count for lenght LSB
#define RADIO_EXCAPED_MARK          (tU8) 0x7d // following char is escaped, XOR with 0x20 to get ture Char
#define RADIO_CHAR_XOR_TO           (tU8) 0x20
#define RADIO_HEADER_LENGTH         (tU16) 8
#define RADIO_TX_LENGH_ADD          (tU16) 5
#define RADIO_TX_DATA_IDX           (tU16) 7
#define RADIO_API_TX_ID             (tU8) 0x01
#define RADIO_FRAM_ID               (tU8) 0x00 // id = 0 disable response frame
#define RADIO_DESTINA_ADDR_MSB      (tU8) 0xff // if = 0xffff is broadcast address
#define RADIO_DESTINA_ADDR_LSB      (tU8) 0xff
#define RADIO_TX_OPTION             (tU8) 0x04 // disable ACK
#define RADIO_ESCAPE_XON            (tU8) 0x11
#define RADIO_ESCAPE_XOFF           (tU8) 0x13
#define RADIO_TX_CKSUM_SUBTRACK     (tU8) 0xff
#endif //_DEFINE_MODBUS

