#ifndef DEF_TIMER_UTILITIES
#define DEF_TIMER_UTILITIES
//=============================================================================
// Header: Master Harder
// Date Time: 1/26/2013 7:16 AM
// Author: Xuedong.Liu
//
// Copyright (c) 2013  NewGate Instrument
//
//=============================================================================
// Description: Define timers constent and structure for LCD holding, sample PV
// rates, flash read/write/erase, char timerout, kick MOD.
//
//=============================================================================

// LCD holding time
#define ONE_SECOND_HOLD     (tU16)32768   // ACLK = 32768Hz, 1/32768 * 326768 = 1sec
#define TASK_SCHEDULE_TIME  (tU16)819     // ACLK = 32768Hz 8192/32768 = 250mSec, if do 1sec time task can use RTC.
#define USB_RTS_INCREAMENT 3            // RTS timer clock source is ACLK = 32768Hz, 1/32768 * 35 = 1.06mSec
#define USB_RTS_BASE_TIME (tU16)35 * USB_RTS_INCREAMENT  // 1.06 msec * 3 = 3.18mSec
#define WT_EEP_WAITE_T      (tU16)200     // ACLK = 32768Hz, 1/32768 * 200 = 6.1mSec, in daig works on 5.82msec
#define RADIO_INTER_CHAR_T  (tU16)110     // ACLK = 32768Hz, 3 chars 9600Baud, 3.125mSec < 110 * 1/32768 = 3.356mSec
#define RADIO_RTS_INCREAMENT      3

// use MSP internal code flash
#define FLASH_ERASE_TIME    WT_EEP_WAITE_T * 10

#define WAITE_ACK_USE_API   (tU16)200    // time use ACLK, 32768Hz, 1/32768 * 200 = 6.1mSec,
#define WAITE_READ_RAM_PRO  (tU16)400    // time use ACLK, 65535 -> about 2Sec, 1/32768 * 400 = 12.2mSec
#define EXCNG_RECEK         50           // at 1Mhz, 50counts = 50*1/1000000 = 50uSec

#define TIMER_PERIOD        1111         // cycle time is 1/(1/8Mhz * 1111) = 7200Hz
#define DUTY_CYCLE1         278          // 25% of 1111 = 278
#define DUTY_CYCLE2         833          // 75% of 1111 = 833


// IKICK cycle time, scope see 1.945KHz when it set at 236 the > 1.8KHz required, 505usec between rising edges
#define IKICK_DUTY_CYCLE     255//510         // ACLK = 922000/512 = 1800.78Hz

#define USE_LOW6BITS        (tU8)0x3F
#define USE_LOW2BITS        (tU8)0x03
#define USE_LOW4BITS        (tU8)0x0F
#define ASCII_SPACE_HEX     (tU8)0x20
#define ASCII_LOW_CASE_ST   (tU8)0x60
#define SET_BIT6_ONE        (tU8)0x40

// SPI speed 1MHz, timer clock source SMCLK 
#define REQ_CTRL_BUS        (tU16)9000    // about 1mSec, 9000 *1/8MHz = 9/8 = 1.125mSec
#define WAIT_DONE_READ      (tU16)40000   // timer 1/8M * 40000 = 40/8mSec = 5mSec,

#endif // DEF_TIMER_UTILITIES
