#ifndef EMV_EEPROM_FILE
#define EMV_EEPROM_FILE
//#pragma pack(1)
// JT808 Flash veriable stucture,
// the live data file is space holder, use RAM varaibles
// need add sensor co-efficients 128 page 3 pages/each
// total = 3 * 2 * 128 = 768 Bytes
// current is about = 28 * 32 = 896
// total about 1664 Bytes
typedef struct
{
    tF32  f32ExtCtrlmA;
    tU16  u16mACalSpan;
    tU16  u16mACalZero;
    //tU8   u8mAAction;
    //tU8   u8mAFail;
    tU8   u8FskRtsDelay;    // 0 = disable, 1 = 8mSec, 2 = 16 mSEc... n = n*8mSEc n < 255
    tU8   u8mAModeSource;   //bit0 - bit3 = source, bit4 - bit7 = mode
} __FSK__;

typedef struct
{
    tF32  f32HostLcdNum;
    tU8   u8HostLcdLow[6];
    tU8   u8HostLcdUp[6];
    tU8   u8LCDBitMask[2];
} __LCD__;

typedef struct
{
    tU8  u8ModbusRev;
    tU8  u8BsapAddr;
    tU8  u8ScollLcdTime;      //unit in sectU8  u8BsapAnyAddr;
    tU8  u8BsapGroup;
    tU8  u8ModbusAddr;
    tU8  u8DigiRtsTime;    // digital port RTS timer, 0 = diable, 1 = 8 msec, 2 = 16, 3 = 24....
    tU8  u8RadioTxChId;
    tU8  u8Water0Ctrl;
    tU16 u16DripPotAddr;
    tF32 f32BaudRate;      // RS485, RS232 baudrate or communication speed
} __PROTO__;

typedef struct
{
    tF32  f32PtUserUnitFactor;
    tF32  f32RtdDamping;
    tF32  f32RtdFailToValue;
    tF32  f32RtdLRV;
    tF32  f32RtdSpanTrim;

    tF32  f32RtdURV;
    tF32  f32RtdUserA;
    tF32  f32RtdUserB;
    tF32  f32RtdUserR0;
    tF32  f32RtdUserRef;
    tF32  f32RtdZeroOffset;
    tF32  f32RtdZeroTrim;

    tF32  f32ScalePtX1;
    tF32  f32ScalePtX2;
    tU16  u16FactorPt;
    tU16  u16OffsetPt;
    tU16  u16ScalePtInt;
    tU16  u16ScalePtY1;
    tU16  u16ScalePtY2;

//    tU8  u8PtUserUnitTx[6];
    tU8  u8StrucRevNum;
    //tU8  u8PtCtrl;
    //tU8  u8RtdUnits;
    //tU8  u8RtdMode;
} __RTD__;

// user changeable and configuable
typedef struct
{
    tU8  u8FlangeMtlCode;
    tU8  u8FlangeType;
    tU8  u8NumSeal;
    tU8  u8oRingMtl;
    tU8  u8RmtFluid;
    tU8  u8RmtIso;
    tU8  u8RmtSealType;
    tU8  u8VentDrn;
    tU8  u8XmtFluidCode;
    tU8  u8XmtIsoCode;
} __SNS_MTL__;

// user changeable and configuable
typedef struct
{
    tF32  f32DpDamping;
    tF32  f32DpLRV;
    tF32  f32DpSpanCal;
    tF32  f32DpSpanTrim;
    tF32  f32DpURV;
    tF32  f32DpUserUnitFactor;
    tF32  f32DpZeroTrim;
    tF32  f32ScaleDpX1;
    tF32  f32ScaleDpX2;
    tU16  u16FactorDp;            // used for board calibtaion done status
    tU16  u16OffsetDp;
    tU16  u16ScaleDpInt;
    tU16  u16ScaleDpY1;
    tU16  u16ScaleDpY2;
//    tU8  u8DpUserUnitTx[6];
    //tU8  u8DpMode;
    //tU8  u8DpUnits;
} __SNS_DP__;

// user changeable and configuable
typedef struct
{
    tF32  f32ScaleSpX1;
    tF32  f32ScaleSpX2;
    tF32  f32SpDamping;
    tF32  f32SpLRV;
    tF32  f32SpSpanCal;
    tF32  f32SpSpanTrim;
    tF32  f32SpURV;
    tF32  f32SpUserUnitFactor;
    tF32  f32SpZeroTrim;
    tU16  u16FactorSp;
    tU16  u16OffsetSp;
    tU16  u16ScaleSpInt;
    tU16  u16ScaleSpY1;
    tU16  u16ScaleSpY2;
//    tU8   u8SpUserUnitTx[6];
} __SNS_SP__;

typedef struct
{
    tF32  f32AdcCalFactor[4];    // for MSP ADC AI0,1, temp, voltage, it is factor of value/cnt, default = 1.0;
} __MSP_ADC__;

typedef struct
{
    tU16  SerialNumber[2];
    tU16  u16ConstPvTrim;
    tU16  u16IntScaleCode;
    //tU8   u8UserMessage[32];
    //tU8   u8ModelNumString[32];
    //tU8   u8UserDescrip[16];
    //tU8   u8SfwTagName[6];
    tU8   u8FwProdCode[6];
    tU8   u8Password[6];
    tU8   u8UserDate[4];
    tU8   u8XmtTypeCode;
    tU8   u8HwRev;
    tU8   u8NumPvs;
    tU8   u8XmtFlangeCode;
    tU8   u8XmtFactoryCode;
    tU16  u16SnsBlk[2];
    tU8   u8SenSeries[2];
    tU8   u8RtdUnits;
    tU8   u8DpUnits;
    tU8   u8SpUnits;
    tU8   u8FmtF32Code;
    tU8   u8RtdWireType;
    tU16  u16SysEnableCtrl;
} __XMT__;

// definition u16SysEnableCtrl
#define MA_FORWARD      BIT0   // Bit0 = 1 -> mA forware action, 0 -> mA Reverse action u8mAAction
#define MA_FAILURE      BIT1   // Bit1 = 1 -> FSK Failure, 0 -> FSK normal u8mAFail
#define MA_SQROOT       BIT2   // Bit2 = 1 -> mA sqaure root output, 0 -> linear output
#define BSAP_ANY_ADDR   BIT3   // Bit3 = 1 -> Xmitter response BSAP any address request, 0 -> only address match create response
#define HOST_PARA_2LCD  BIT4   // Bit4 = 1 -> host paramenter send to LCD, 0 -> host parament ignored, u8HostLcdEnable
#define PT_ONLY_MODE    BIT5   // Bit5 = 1 -> PT only mode, 0 -> normal xmitter, u8PtCtrl
#define PT_ENABLE_CTRL  BIT6   // Bit6 = 1 -> PT enabled, 0 -> PT disabled, u8RtdMode;
#define PT_FAIL2_ENABLE BIT7   // Bit7 = 1 -> PT faile-To-Value enable, 0 -> fail-to-Value disable, FailToMode
#define SP_ENBALE_CTRL  BIT8   // Bit8 = 1 -> SP enabled, 0 -> SP disabled, u8SpMode
// follwoing bits can move to RAM
//#define ADS_SNS1_GOOD   BIT9   // Bit9 = 1 -> snsor1 ads1218 is good,  0 -> sensor1 ads1218 does not connect
//#define ADS_SNS2_GOOD   BIT10  // Bit10 = 1 -> snsor2 ads1218 is good,  0 -> sensor2 ads1218 does not connect
#define SEN1_NEW        BIT11  // Bit11 = 1 -> sensor1 is new, 0 -> sensor1 is same as last power on
#define SEN2_NEW        BIT12  // Bit12 = 1 -> sensor2 is new, 0 -> sensor2 is same as last power on
//#define SEN1_ADC_PROC   BIT13  // Bit13 = 1 -> sensor1 is ADC in Process, 0 -> sensor1 ADC is low power,
//#define SEN2_ADC_PROC   BIT14  // Bit14 = 1 -> sensor2 is ADC in Process, 0 -> sensor2 ADC is low power,
#define RADIO_OUT       BIT15  // Bit15 = 1 -> Radio isnot working, need reinit, 0 -> Radio is working

#pragma pack(1)   //elimante space in odd address
// this sturcture can not be changed when use old sensor together
typedef struct
{
    tU16  SensorBlk;
    tU8   SensorSeries;
    tU8   unused_P1;
    tU8   SensorType;
    tU8   SensorDpRange;
    tU8   SensorSpRange;
    tU16  CompSystem;
    tU16  CompDateCode;
    tU8   unused_P2;
    tU8   MfgRevCode;
    tU16  MfgDateCode;
    tU8   pg1GapEvenAddr;
} __MFG_SNS_PG1__;
#pragma pack()
// FLASH_P1_USED number same as 3808 bcause check sum
#define FLASH_P1_USED       sizeof(__MFG_SNS_PG1__)

// this sturcture can not be changed when use old sensor together
typedef struct
{
    tF32  Coeff_Ax[6];
    tF32  Coeff_Bx[5];
    tF32  Coeff_Cx[4];
    tF32  Coeff_Dx[3];
    tF32  Coeff_Ex[2];
    tF32  Coeff_F0;
    tF32  Coeff_Gx[4];
    tF32  DpNormalization;
    tF32  SpCorrection;
    tF32  DpZeroFac;
    tF32  DpSpanFac;
    tF32  Coeff_A6;
    tF32  Coeff_F1;
} __MFG_SNS_DP__;
//FLASH_P2_USED number same as 3808 cause check sum
#define FLASH_P2_USED      sizeof(__MFG_SNS_DP__)

// this sturcture can not be changed when use old sensor together
typedef struct
{
    tF32  Coeff_Ax[6];
    tF32  Coeff_Bx[5];
    tF32  Coeff_Cx[4];
    tF32  Coeff_Dx[3];
    tF32  Coeff_Ex[2];
    tF32  Coeff_F0;
    tF32  SpNormalization;
    tF32  SpZeroFac;
    tF32  SpSpanFac;
} __MFG_SNS_SP__;
//FLASH_P4_USED number same as 3808 bcause check sum
#define FLASH_P3_USED        sizeof(__MFG_SNS_SP__)

// this sturcture can not be changed when use old sensor together
typedef struct
{
    tF32  BvCoeff[3];
    tF32  EstTempCoeff[3];
} __MFG_SNS_BV_ST__;
//FLASH_P4_USED number same as 3808 bcause check sum
#define FLASH_P4_USED        sizeof(__MFG_SNS_BV_ST__)
#define JT808_MAX_SNS    2
typedef struct
{
    __MFG_SNS_PG1__   mfgPg1[JT808_MAX_SNS];
    __MFG_SNS_DP__    mfgDp[JT808_MAX_SNS];
    __MFG_SNS_SP__    mfgSp[JT808_MAX_SNS];
    __MFG_SNS_BV_ST__ mfgSt[JT808_MAX_SNS];
} __MFG_SET__;
#define MFG_PAGE1_SIZE       sizeof(__MFG_SNS_PG1__)


#endif  // EMV_EEPROM_FILE
