#ifndef EMV_EEPROM_STRUCT
#define EMV_EEPROM_STRUCT
//=============================================================================
// Header: Serial EEPROM (FLASH) definitions, Serial RAM definitions
// Date Time: 4/26/2010 8:14 AM
// Author: Xuedong Liu
//
// Description:  this include file and its include are shard by two MSP430
//           it defind the CMD, Delay, informaiton structures.  modify in
//           one MSP430, need to verify the other MSP has no problem.
//           this file no hardware PIN definitions, it is in the each MSP
//           featureboard.h file, except Port 4 pin 0 & 1 receive definitions
//           and Port 4 pin 2 & 3 send definitions
//=============================================================================
//the Serial EEPROM is W25Q80 device,
// it has 15 of 64K block, each block has 15 of 4K sectors
// it can write in 0 to 256 Bytes/page, after write need 3 msec delay
// it need delay 200mSec for sector erase
// it need delay 1.5 sec for block erase.
// other detail see datasheet
//#pragma pack(1)
#include "eerpomFile.h"
// MSP430F5638 flash information
typedef struct
{
    tU8 u8Nameplate[120];               // user enter nameplate
    tU8 u8RtdUserUnitChar[8];           // user enter temperature unit name
} INFO56A_STRUC;

typedef struct
{
    tU8  u8UserDescrip[16];         // user description
    tU8  u8SoftwareTag[8];              // software tag
    tU8  u8UserMessage[32];             // user message 
    tU8  u8UserLogTag[32];              // user log tag
    tU8  u8DpUserUnitChar[8];           // DP user unit text
    tU8  u8SpUserUnitChar[8];           // SP user unit test
    tU8  u8Io5638Control;               // IO control
} INFO56B_STRUC;

typedef struct
{
    tU8 u8DpZeroCalDate[10];            // DP zero Cal date
    tU8 u8DpSpanCalDate[10];            // DP Span Cal date
    tU8 u8SpZeroCalDate[10];            // SP zero Cal date
    tU8 u8SpSpanCalDate[10];            // SP Span Cal date
    tU8 u8RtdZeroCalDate[10];           // Temperature zero Cal date
    tU8 u8RtdSpanCalDate[10];           // Temperature Span Cal date
} INFO56C_STRUC;

// INFO56D_STRUC is free

// MSP430F5438A flash information
typedef struct
{
    //__LCD__     lcd;                    // LCD
    __SNS_MTL__ snsMtlCfg[JT808_MAX_SNS];
    __PROTO__   comm;                   // communicaation protocols
    __RTD__     pt;                     // Temperature process
} INFOA_STRUC;

typedef struct
{
    __FSK__     fsk;                    // 4 to 20 mA current loop port
    __SNS_DP__  snsDpCfg[JT808_MAX_SNS];// use configuration paramenters
} INFOB_STRUC;

typedef struct
{
    __SNS_SP__ snsSpCfg[JT808_MAX_SNS];
    __MSP_ADC__ mspAdc;
} INFOC_STRUC;

typedef struct
{
    __XMT__     xmt;                    // trasnmitter or configuration paramenters
} INFOD_STRUC;

// do not move this structure away from ramDate
#define MSP2_COMM_BLOCK         4   // number block used, 0,1 block for 5438A send to 5638; 2, 3 for 5638 send to 5438A

#include "RamVarFile.h"

typedef struct
{
    __RAM_PT__       pt;
    __CAL__          cali;
    Calendar         rtcV;
    __DIAG__         diag;
    __RAM_XMT__      xmt;
    __RAM_CTRL__     ctrl;
    __RAM_DP__ dp[JT808_MAX_SNS];
    __RAM_SP__ sp[JT808_MAX_SNS];
    __RAM_ST__ st[JT808_MAX_SNS];
    __CHART_RECORD__ recChart;
    __API1_PLUNGER__ apiPlng;     // sturcture for plunger lift application
    __F5438A_PVs__   exchg8A[JT808_MAX_SNS];
    __F5638_PVS__    exchg6Pv;
}ramData;


// define u32PlungerCtlStatus in plunger lift application
#define ENABLE_PLUNGER_API      BIT15           // start aaplication of plunger lift
#define ENABLE_12VOUTPUT_ON     BIT14           // bit14 = 1 12V output on, bit14 = 0  12V ouput off
#define ENABLE_HSC_ON           BIT13           // bit13 = 1 use HSC as time count, bit13 = 0 not use HSC
#define ENABLE_32KCLK_CNT_ON    BIT12           // bit12 = 1 use MSP430 internal 32K clock as time counter
#define PLUNGER_ARRIVE_SET      BIT11           // bit11 = 1 status arrive switch changed, read clear this status
#define STATUS_12VOUT_SET       BIT10           // bit10 = 1 means 12V oputput on, 0 = off
#define PLUNGER_HIT_WATER       BIT9            // bit9 =  1 sensor sense plunger hit water
#define DO3_1OUTPUT             Bit7            // bit7 =  1 set DO3 to high, = 0 set to low
#define DO2_1OUTPUT             Bit6            // bit6 =  1 set DO2 to high, = 0 set to low
#define DO1_1OUTPUT             Bit5            // bit5 =  1 set DO1 to high, = 0 set to low
#define DO0_1OUTPUT             Bit4            // bit4 =  1 set DO0 to high, = 0 set to low

#define DI3_1INPUT              Bit3            // bit3 =  1 Status DI3 to high, = 0 status to low
#define DO2_1INPUT              Bit2            // bit2 =  1 status DI2 to high, = 0 status to low
#define DO1_1INPUT              Bit1            // bit1 =  1 status DI1 to high, = 0 status to low
#define DO0_1INPUT              Bit0            // bit0 =  1 status DI0 to high, = 0 status to low

#define MSP_EXCHG_BLK_SIZE      sizeof(__INFO_EXCHANG__)
#define RAM_VAR_SIZE            MSP_EXCHG_BLK_SIZE  // if use more than 1 block, need do times.

#define RAM_PT_SIZE             sizeof(__RAM_PT__)
#define RAM_CAL_SIZE            sizeof(__CAL__)                 // LATER DO CAL FIX ME
#define RAM_CALENDER_SIZE       sizeof(Calendar)
#define RAM_DIAG_SIZE           sizeof(__DIAG__)
#define RAM_XMT_SIZE            sizeof(__RAM_XMT__)
#define RAM_CRTL_SIZE           sizeof(__RAM_CTRL__)            // later do Control FIX ME
#define RAM_DP_SIZE             sizeof(__RAM_DP__)
#define RAM_SP_SIZE             sizeof(__RAM_SP__)
#define RAM_ST_SIZE             sizeof(__RAM_ST__)
#define RAM_EX6V_SIZE           sizeof(__F5638_PVS__)
#define RAM_EX8A_SIZE           sizeof(__F5438A_PVs__)
#define RAM_TOTAL_SIZE          sizeof(ramData)

#define EEPDATA_SIZE sizeof(eepData)
// MSP5438A info flash size
#define MSP_INFO_FALSH_SIZE  128-1
#define USED_INFOA_SIZE sizeof(INFOA_STRUC)
#define USED_INFOB_SIZE sizeof(INFOB_STRUC)
#define USED_INFOC_SIZE sizeof(INFOC_STRUC)
#define USED_INFOD_SIZE sizeof(INFOD_STRUC)
// MSP5638 info flash size
#define INFO_5638A_SIZE sizeof(INFO56A_STRUC)
#define INFO_5638B_SIZE sizeof(INFO56B_STRUC)
#define INFO_5638C_SIZE sizeof(INFO56C_STRUC)

// MSP infor flash address
#define MSP_INFOA_ADDR     0x001980
#define MSP_INFOB_ADDR     0x001900
#define MSP_INFOC_ADDR     0x001880
#define MSP_INFOD_ADDR     0x001800
// MSP infor flash segment erase time 23 to 32mSec
#define ERASE_SEG_DELAY    262          // erase MSP one segment delay time unit = 8mSec, 1/32768 * 1000 * 262 = 7.99mSec
// MSP infor flash program word time is from 85uSec

// flash W25Q80 Chip required
#define CURRENT_EEPREV     0x04         // next release set 3 if changes; each time updated eepData, +1 on this, never start from 0
#define DIAG_EEPDATA_SIZE  10
#define EMV_EEP_PAGE_SIZE  256          // W25Q80 256bytes/page
// 16 bits time MAX counts = 65,535
#define WT_FLASH_DELAY     100          // page prgram delay 3mSec, the timer counts = 1/32768 * 1000 * 100 = 3.0517 mSec
#define SEC_ERASE_DELAY    6554         // sector erase delay is 200mSec, the timer counts = 1/32768 * 1000 * 6554 = 200.01mSec
#define BLK_ERASE_DELAY    49152        // block erase delay is 1.5Sec, the timer counts = 1/32768 * 1000 * 49152 = 1500mSEc

// flash W25Q80 chip commmand
#define FLASH_WT_DATA      0x02         // write or program 1 to 256 bytes, fmt = CMD, Date
#define FLASH_RD_DATA      0x03         // read any bytes from flash, fmt = CMD, A24-A16, A15-A8, A7-A0, data
#define FLASH_WT_ENABLE    0x06         // write enable, fmt = CMD
#define FLASH_WT_DISABLE   0x04         // write disable, fmt = CMD
#define FLASH_ERASE_BLOCK  0xD8         // rease a block, fmt = CMD, A24-A16, A15-A8, A7-A0, W25Q80 1 block = 64K
#define FLASH_ERASE_SECTOR 0x20         // rease a sector, fmt = CMD, A24-A16, A15-A8, A7-A0, W25Q80 1 sector = 4K
#define FLASH_PWR_DOWN     0xB9         // low power mode, fmt = cmd,
#define FLASH_OUT_PWR_DOWN 0xAB         // release from low power mode, fmt = CMD
#define FLASH_READ_ID      0x90         // read mfg ID and device ID, fmt = CMD, 0, 0, 0, m7-m0 = 0xEF, Id7=ID0 = 0x13 for W25Q80

// flash allocation on W25Q80, using 24bits address, bit24-31 does not care
#define SYSBUFF_START_ADDR 0x000000   // systemBuffer start from this location
#define SECTOR_MAX_SIZE    0x1000       // 4K one sector in W25Q80
#define BLOCK_MAX_SIZE     0x010000   // 64K one block size in W25Q80
#define EACK_FW_NUM_BLK    4
#define FW_BLK_MAX_SIZE    0x3F000      // 252KB in W25Q80 < MSP430F5xxx family 256KB size

#define FW5438A_FW1_START  0x000000   // store the firmware 1 for MSP430F5438A
#define FW5438A_FW1_INFO   0x03F000   // start to store 5438A FW1 revision and information
#define FW5438A_FW2_START  0x040000   // store the firmware 2 for MSP430F5438A
#define FW5438A_FW2_INFO   0x07F000   // start to store 5438A FW2 revision and information
#define FW5638_FW1_START   0x080000   // store the firmware 1 for MSP430F5638
#define FW5638_FW1_INFO    0x08F000   // start to store 5638 FW1 revision and information
#define FW5638_FW2_START   0x0C0000   // store the firmware 2 for MSP430F5638
#define FW5638_FW2_INFO    0x0FF000   // start to store 5638 FW2 revision and information

#define RAM_EX_BLK1_START  0x000000   // 1st block start address
#define RAM_EX_BLK2_START  RAM_EX_BLK1_START + MSP_EXCHG_BLK_SIZE
#define RAM_EX_BLK3_START  RAM_EX_BLK2_START + MSP_EXCHG_BLK_SIZE  // time 2
#define RAM_EX_BLK4_START  RAM_EX_BLK3_START + MSP_EXCHG_BLK_SIZE  // time 3
#define RAM_OPERATIN_DATA  RAM_EX_BLK4_START + MSP_EXCHG_BLK_SIZE  // dynamice data where start

#define START_FLASH_ADDR   SYSBUFF_START_ADDR   // start address in configuration flash, is flash used W25Q80  24bits address,

// The Serial RAM is 23A1024 device.
// the mode defualt is Sequential mode, it can write/read any size of data
// the device start address is 0 , end address is 0x1FFFF
// it has 128KB RAM.
// RAM 23A1024
#define RAM_RD_DATA_CMD    0x03         // read the data from RAM any address, fmt = CMD, A24-A16, A15-A8, A7-A0, data; (A24-A17 doesn't care)
#define RAM_WT_DATA_CMD    0x02         // write the data to RAM any address, fmt = CMD, A24-A16, A15-A8, A7-A0, data; (A24-A17 doesn't care)
#define CHART_REC_ADDR     RAM_VAR_SIZE // chart record, the record data start from this location
#define RAM_MAX_SIZE       0x20000      // RAM chip has 128KB space can use, over write record is ok.

// MSP430F5438A send to MSP430F5638 msg bits define, send use bit3,4 receiv use bit0,1
//   MSP430F5438 Tx, toggle P10_6
#define TX_REQ5638DO_BLK1  0x04         // bit7-0 = xxxx,01xx -> x don't care bit
#define TX_REQ5638DO_BLK2  0x08         // bit7-0 = xxxx,10xx -> x don't care bit
#define TX_5438ADONE_REQ   0x0C         // bit7-0 = xxxx,11xx -> x don't care bit
#define TX_5438A_RX_REQ    0x00         // bit7-0 = xxxx,00xx -> x don't care bit
//   MSP430F5638 RX
#define RX_REQ5638DO_BLK1  0x01         // bit7-0 = xxxx,xx01 -> x don't care bit
#define RX_REQ5638DO_BLK2  0x02         // bit7-0 = xxxx,xx10 -> x don't care bit
#define RX_5438ADONE_REQ   0x03         // bit7-0 = xxxx,xx11 -> x don't care bit
#define RX_5438A_RX_REQ    0x00         // bit7-0 = xxxx,xx00 -> x don't care bit

// MSP430F5638 send to MSP430F5438A msg bits define, send use bit3,4 receiv use bit0,1
//   MSP430F5638 TX, toggle P5_3
#define TX_REQ5438DO_BLK3  0x04         // bit7-0 = xxxx,01xx -> x don't care bit
#define TX_REQ5438DO_BLK4  0x08         // bit7-0 = xxxx,10xx -> x don't care bit
#define TX_5638_DONE_REQ   0x0C         // bit7-0 = xxxx,11xx -> x don't care bit
#define TX_5638_RX_REQ     0x00         // bit7-0 = xxxx,00xx -> x don't care bit
//   MSP430F5438 Rx
#define RX_REQ5438DO_BLK3  0x01         // bit7-0 = xxxx,xx01 -> x don't care bit
#define RX_REQ5438DO_BLK4  0x02         // bit7-0 = xxxx,xx10 -> x don't care bit
#define RX_5638_DONE_REQ   0x03         // bit7-0 = xxxx,xx11 -> x don't care bit
#define RX_5638_RX_REQ     0x00         // bit7-0 = xxxx,xx00 -> x don't care bit

// fail save 2 MSP430s communication
#define REQ_2RX_REQ_TIMER  100          // MSP sends the request to get other MSP response received the request, timeout = 3mSec
#define RX_2DONE_TIMER     49152        // MSP recevied request to doen process request timeout = 1.5sec

#define SYS_CLK_500USEC    1048/1       // it is about 500usec using __delay_cycles when SCLK is SYSCLK_1MHZ
#define SYS_CLK_150USEC    150          // tested, delay cycle 150 is about 150 usec
#define SYS_CS_1ST_CLK     10           // normal take 5 or 10 usec
#define SYS_CLK_7MSEC      7000         // system clk = 1MHz = 1000000 * 0.007 = 7000, it is 7msec
#define TAG_NAME_SIZE      sizeof(systemBuffer.u8TagName)

// u8Type definition
enum
{
    NO_XCHG,            //0
    TYPE_INFOA,         //1
    TYPE_INFOB,         //2
    TYPE_INFOC,         //3
    TYPE_INFOD,         //4
    TYPR_RAM_PT,        //5        
    TYPE_CALENDER,      //6
    TYPE_DIAG,          //7
    TYPE_RAM_XMT,       //8
    TYPE_RAM_DP_SNS1,   //9
    TYPE_RAM_SP_SNS1,   //10 = A
    TYPE_RAM_ST_SNS1,   //11 = B
    TYPE_RAM_DP_SNS2,   //12 = C
    TYPE_RAM_SP_SNS2,   //13 = D
    TYPE_RAM_ST_SNS2,   //14 = E
    TYPE_MFG_PG1_SNS1,  //15 = F
    TYPE_MFG_PG1_SNS2,  //16 = 10
    TYPE_AP_PLNG_LIFT,  //17 = 11
    TYPE_EX8A_SNS1,     //18 = 12 this group from 4538A to 5638 each seconds
    TYPE_EX8A_SNS2,     //19 = 13 this group from 5438A to 5638 each seconds
    TYPE_EX6_PVS,       //20      this group from 5638 to 5438A each seconds
    TYPE_INFO5638A,     //21      after this when change do exchange, no change
    TYPE_INFO5638B,     //22      each MSP has same content copy locally
    TYPE_INFO5638C,     //23 
    TYPE_INFO5638D,     //24 
    
    END_NOW,            //25
};

// MSP430F5638 use following
// definition to u8Io5638Control;   IO control						
#define DISPLY_LED_ON   BIT0  // display LED control
#define HSC_FILTER_ON   BIT1  // HSC file control
#define EN_HS_AI_1SET   BIT2  // HS_AI enable control

// definition to u32Op5638Status;   Msp5638 operation status						
#define S_P_SHNT_1SET   BIT0  // solar power charge control
#define PLNGR_CLOSED    BIT1  // high speed switch indicator
#define HSC_FLT_ST_ON   BIT2  // HSC filter control status
#define HS_AI_ENABLED   BIT3  // HS_AI enable control status
#define DISP_LED_1SET   BIT4  // display LED control status
#define HSC_CLEARED     BIT5  // HSC counted cleat once

// MSP430F5438A use following

#endif  // EMV_EEPROM_STRUCT