#ifndef GLOBAL_EXTERN_FUNC_DEF
#define GLOBAL_EXTERN_FUNC_DEF
//=============================================================================
// Header: Global functions extern definition
// Date Time: 1/8/2013 3:08 PM
// Author: Xuedong Liu
//
// cross project to call the function. to sure the implement in one file.
// interrupt service functions are exclusive.
//=============================================================================
#include "basicsType.h"

// base MSP430 inits
extern void fbStartXT1(tU8 u8UsbClkOn, tU8 u8HiSpeedPress);
extern void fbPortInit(void);
extern void fbFuncPortInit(void);
extern void resetTaskScheduler(void);

extern void LcdLayer2Driver(void);
extern void LcdLayer1Driver(void);
extern void initMspAdc(void);
extern void cmdFbMspReset(void);
extern void useFeatureBoard(void);
extern void main(void);
extern void waste_time(tU16 count);
extern void startMspAdcSeq(void);
extern tU16 getLcdIdx(void);
extern void initChargeAndTime(void);
extern void ReadADCCAL(void);
extern void enableRtcTime(void);
extern void iniItsRtcTime(void);
//extern void correctRtcValue(void);
extern void sendJ6RtcToJ4(void);
extern tU8 setCalRtcResult(ACCESS_VER_INFO *rwVarInfo);
// user LCD display
extern tU8 wtLoLab(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtMLoLab(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtMHiLab(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtHiLab(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtMIUnit(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtHiUnit(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtLoUnit(ACCESS_VER_INFO *rwVarInfo);

// Radio interface
extern tU16 radioInterfaceFunc(COMM_ENV *portCtrl);
extern void batInCtrlOutDefault(void);
extern void batoutCtrlOutLow(void);
extern void initRadioState(void);
// Radio communication
extern void initRadio(void);
extern void CommunicationDriver(void);
extern void doneTxRadioMsg(void);
extern void setBatInstallStatus(tU8 Status);
// new radio init
#if 0
extern tU8 radioInterrupRxChar(tU8 u8RxData);
extern void RadioTimerInterruptDo(void);
extern void DoneRadioTxDo(void);
extern void doneRadioRxDo(void);
#endif

// chart recorder replacement
//extern void setupRTC(void);
extern tU16 chartRecordReplace(COMM_ENV *portCtrl);
extern void chartRecordWtRam(void);
extern void testLimitsRec(void);
extern void setChartFlag(tU8 flag);
extern tU8 readChartDmaFlag(void);
extern void u16ChartRdMidResponse(tU16 u16MsgLength, COMM_ENV *ptEnv);

extern tU8 checkPvChanges(RAM_DATA_PROC *inInfor);
extern tU8 setRtcTimer(RAM_DATA_PROC *inInfor);
extern tU8 calaInterval(RAM_DATA_PROC *inInfor);
extern tU8 rdCurrentRecFunc(RAM_DATA_PROC *inInfor);
extern tU8 rdDailyRecFunc(RAM_DATA_PROC *inInfor);
extern tU8 setRecodEvnt(RAM_DATA_PROC *inInfor);

// MSP430F5638 use as USB
extern void JtUsbInit(void);
extern void driversLookCommRxBuf(void);
extern void initDmaTxCtrl(tU8 *u8CommTxBuf, tU16 u16TxSize);
extern COMM_ENV *getUsbPortEnv(void);
extern void usbPtChangeProtocol(void);
extern void commonLookRxBuf(COMM_ENV *portEnv);

//Modbus communication protocol
extern void ModbusLayer1Driver(COMM_ENV *ptEnv);
extern void modbusLayer2Driver(void);
extern void systemInitMd(COMM_ENV *ptEnv);
extern tU8 wtfDummy(ACCESS_VER_INFO *rwVarInfo);
extern tU16 illegalRequestValue(COMM_ENV *portEnv);

// LCD communication, LCD coonects to MSP430F5638
extern void updateGlass(tDisplayData *pDisplayData);
extern void diagInitLcd(tBoolean bDiagnOn);
extern void initLcdRowNum(void);
extern void LcdDataCheck(tDisplayData *pDisplayData);

// timer
extern void initTimer(void);
extern void startTaskScheduler(void);
extern void startWaitOtherReadTimer(void);
extern void stopWaitOtherReadTimer(void);
extern void otherMspNoReadReTx(void);
extern void setReTxType(tU8 u8TxType);
extern void startExchgSleepTimer(void);
extern void stopExchgSleepTimer(void);

extern void radioTimerStart(tU16 u16TimerV, tU8 u8SetFlag);
extern void radioTimerStop(void);
extern void setupRadioDmaRxCtrl(void);

//utilities
extern tU16 u16BaspCCIT(tU8 *u8BuffPtr, tS16 s16Length, MSG_CRC16 *u16inCrc);
extern tU16 MdCRC16(tU8 *msg, tS16 tS16length, MSG_CRC16 *check);
extern tF32 applyDamping(CAL_PV_STRUC *inInfo);
extern tF32 applyTrims(CAL_PV_STRUC *inInfo);
extern tF32 applyScale(CAL_PV_STRUC *inInfo);
extern tU32 calcLive2RawCnt(CAL_PV_STRUC *inInfo);
extern tF32 convertPresUnitsStd(CAL_PV_STRUC *inInfo);
extern tF32 convertPtUnitsStd(CAL_PV_STRUC *inInfo);
extern void calcScaleSlopOffset(void);
extern void calcDpUnitchange (void);
extern void calcSpUnitchange (void);
extern void calcPtUnitchange (void);
extern void packAscii(tU8 *asciiSrc, tU8 *packedDest, tU8 asciiLength);
extern tU8 unpackAscii(tU8 *packedSrc, tU8 *asciiDest, tU8 packedLength);
extern void calTypePtsProcess(void);
extern tReturnStatus calErrorCheck(void);
extern tF32 averageF32Data(tU8 u8Type, tF32 f32Live);
extern tF32 takeAwayBigSmalF32Data(tU8 u8Type, tF32 f32Live);
//extern void setChartUnitChgEvet(void);
// RAM SPI MSP data exchange
extern void reqCtrlRamSpiBus(void);
extern void wtRamSpi(tU8 data);
extern void ramCsEnable(void);
extern void ramCsDisable(void);
extern void enableRamSpi(void);
extern void disableRamSpi(void);
extern void ramWtSpiData(RAM_SPI_ACCESS *wtCtrl);
extern void ramRdSpiData(RAM_SPI_ACCESS *rdCtrl);
extern void ctrlRamBusRxData(void);
extern void doneRequestRxRamData(void);
extern void txOrRxCtrlRamSpi(void);
extern void initExchgIdx(void);
extern void addOneTypeExchg(tU8 data);
extern tU8 getEchgType(void);
extern void lowRequestRxPin(void);
extern void highRequestRxPin(void);
extern void setExchgState(tU8 u8SetV);
extern tU8 getExchgState(void);

extern void ctrlRamBusTxData(void);
extern tU8 abbitritioRamSpiBus(tU8 u8flag);
extern void endUseRamSpi(void);
//MSP430F4538A functions
//extern tU8 doMspAdc1Cal(ACCESS_VER_INFO *rwVarInfo);

// SPI prots Flash SPI
extern void wtFlashSpi(tU8 data);
extern tU8 rdFlashSpi(void);
extern void eepGetEEpromData(tU32 addr, tU16 count, tU8 *data);
extern void eepWriteEEprom(tU32 addr, tS16 count, tU8 *data);
extern void reInitCalVaribles(void);
extern void flashCsEnable(void);
extern void flashCsDisbale(void);
extern void enableFlashSpi(void);
extern void disableFlashSpi(void);
extern void eepGetMspInfoData(tU8 *addr, tU16 count, tU8 *data);
extern void eepWtMspInfoData(tU8 *addr, tU16 count, tU8 *data);
extern void eepWtMspInfoAData(tU8 *addr, tU16 count, tU8 *data);
extern void dynamicWriteinfoA(void);
extern void dynamicWriteinfoB(void);
extern void dynamicWriteinfoC(void);
extern void dynamicWriteinfoD(void);
extern void eraseW25Q80Flash(tU32 addr);   // 4K section
extern void erase64kW25Q80Flash(tU32 addr);   // 64K Block
extern tU8 readQ80Status(void);

// exchange process function define
extern void chge5638CtrlItems(void);

//Firmware field update
extern void main_update (tU8 imgeCode);
extern tReturnStatus UpdateFwMain(BSL_HOST_CMD *cmdInPtr, EMV_BSL_RESPONSE *rspOutPtr);
extern void flashQ80PowerDown(void);
extern void flashQ80NormalOp(void);
extern void wrtieLowHiBuffToFlash(void);
extern void otherMspRequestFwUpdate(void);
extern void updateDoneClrNextRun(void);

extern tU8 dummy(ACCESS_VER_INFO *rwVarInfo);  // basp and modbus all used it

// 5638 control action
extern tU8 wt5638Ctrl(ACCESS_VER_INFO *rwVarInfo);
extern void turnOnOffDispLed(tU8 u8CtrlIn);
extern tU8 rdDpUnit2Bsap(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdSpUnit2Bsap(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdRtdUnit2Bsap(ACCESS_VER_INFO *rwVarInfo);

// indirect access veriable functions
extern tU8 rdFwRev(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtTageName(ACCESS_VER_INFO *rwVarInfo);
extern tU8 bdFwRev(ACCESS_VER_INFO *rwVarInfo);
extern tU8 ack00xxFmt(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdWtMdAddr(ACCESS_VER_INFO *rwVarInfo);
extern tU8 canDevType(ACCESS_VER_INFO *rwVarInfo);
extern tU8 byteLoHi(ACCESS_VER_INFO *rwVarInfo);
extern tU8 byteHiLo(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapUnits(ACCESS_VER_INFO *rwVarInfo, tU8 u8Type);
extern tU8 mapDpRang(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapFlageMtl(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapFlgType(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapDrinVnt(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapORng(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapRmtSealT(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapRmtFluid(ACCESS_VER_INFO *rwVarInfo);
extern tU8 mapRmtIso(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdASCII(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdWtPtUnit(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdWtSpUnit(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdWtDpUnit(ACCESS_VER_INFO *rwVarInfo);
extern tU8 changeRtsTime(ACCESS_VER_INFO *rwVarInfo);

extern tU8 wtRtdR0Cal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpZeroCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpSpanCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpOpUrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpOpLrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtSpOpUrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtSpOpLrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtPtOpUrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtPtOpLrv(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtSpZeroCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtSpSpanCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtPtZeroCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtPtSpanCal(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpY1(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpY2(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpFac(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpOffst(ACCESS_VER_INFO *rwVarInfo);
extern tU8 set485baud(ACCESS_VER_INFO *rwVarInfo);
extern tU8 set232baud(ACCESS_VER_INFO *rwVarInfo);
extern tU8 checkPressureUnitCode(tU8 u8UnitCode);
extern tU8 checkRtdUnitCode(tU8 u8UnitCode);
extern tU8 wtDpDampingV(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtSpDampingV(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtRtdDampingV(ACCESS_VER_INFO *rwVarInfo);

extern tU8 wtFlashTestEnable(ACCESS_VER_INFO *rwVarInfo);

extern tU8 wtDpX1(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtDpX2(ACCESS_VER_INFO *rwVarInfo);
extern void calcDpScaleSlopOffset(void);
extern tU8 getDpRawCntLo(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getDpRawCntHi(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getSpRawCntLo(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getSpRawCntHi(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getPtRawCntLo(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getPtRawCntHi(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getStRawCntLo(ACCESS_VER_INFO *rwVarInfo);
extern tU8 getStRawCntHi(ACCESS_VER_INFO *rwVarInfo);
extern tU16 illegalRequestValue(COMM_ENV *portEnv);

// other features
extern void batteryChargeOnOff(void);
extern tU8 doStatus4(ACCESS_VER_INFO *rwVarInfo);
extern tU8 doStatus3(ACCESS_VER_INFO *rwVarInfo);
extern tU8 doStatus1(ACCESS_VER_INFO *rwVarInfo);
extern tU8 rdWtDigiIOReg(ACCESS_VER_INFO *rwVarInfo);
extern tU8 wtCtlIOReg(ACCESS_VER_INFO *rwVarInfo);
//extern void initCalOffset(void);
extern tU8 calBatVolt(ACCESS_VER_INFO *rwVarInfo);
extern tU8 calSolarVolt(ACCESS_VER_INFO *rwVarInfo);
extern tU8 calMspTempInC(ACCESS_VER_INFO *rwVarInfo);

//BASP communication protocol
extern void BaspLayer1Driver(COMM_ENV *ptEnv);
extern void BASPLayer2Driver(void);
extern void systemInitBSAP(COMM_ENV *ptEnv);
extern tU8 rdbDummy(tU8 *u8InRdbStruc, tU8 *u8OutRdbStruc, tReturnStatus *errCode);
extern tU8 u8ExtendedRdb(tU8 *u8InRdbStruc, tU8 *u8OutRdbStruc, tReturnStatus *errCode);
extern tU8 u8RdbRdMsdAddr(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
//extern tU8 u8RdbRdSlct(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbRdSlctSignal(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbRdName(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbRdListStart(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbRdBlnAddr(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8P2pRdWtFunc(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbRdIdPoll(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbWtMsdAddr(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbWtName(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbWtListStart(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);
extern tU8 u8RdbWtListNext(tU8 *u8InRdbFunc, tU8 *u8OutRerByte, tReturnStatus *errCode);

#endif //GLOBAL_EXTERN_FUNC_DEF
