#ifndef GLOBAL_EXTERN_VAR_DEF
#define GLOBAL_EXTERN_VAR_DEF
//=============================================================================
// Header: Share global volatile varibale extern definition
// Date Time: 2/2/2013 3:08 PM
// Author: Xuedong Liu
//
//  all shared global variables are in here, to save modigy the data crosee
//  the project.
//=============================================================================

// debug trace
extern  tU8 u8DebugTrace[TRACE_BUFFER_SIZE], TracePtr;

// type definitions
extern  ramData sysRamData;
extern  ram5638Data sysRam56D;
extern  INFOA_STRUC infoA;
extern  INFOB_STRUC infoB;
extern  INFOC_STRUC infoC;
extern  INFOD_STRUC infoD;
extern  INFO56A_STRUC info5638A;
extern  INFO56B_STRUC info5638B;
extern  INFO56C_STRUC info5638C;
extern INFO56D_STRUC info5638D;  // D is free
extern  __MFG_SET__ sysBuf;
extern  tU16  u8UserLcdLab[9][4];
extern  tU16  u8UserLcdUnit[9][3];

extern  tU8 u8MDRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE],
  u8BASPRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE],
  u8HARTRxTxTempBuf[EMV_NUM_COMM][MAX_MSG_SIZE],
  u8CommInbuf[EMV_NUM_COMM][RX_BUF_SIZE];       // interrupt input buffer

extern  tU8 u8UsedPort[TOTAL_FLAGE_ARRAY],      // bit0 = 1 USB MSP430F5438A, bit3 = 1 USB MSP430F5638
  u8Layer2TaskScheduler,                        // process flag, these flag happen in timer interval
  u8Layer1TaskScheduler,                        // interface flag, need interface to do the work when flag is set
  u8OtherTaskScheduler,                         // interface flag, communication has complete request, or process need data is ready
  u8DoDiagErrorProcess;                         // interface flag, timer related, start timer or timeout flags
extern  tU8 u8MdReplyAddress;

extern  tU16
  u16FlashTest,
  u16FlashTestStop;

extern  tF32 f3FskActualRtsDelay;
extern  tF32 f32StackEndVal;

extern const FWVersionInfor BuildFwInfo;
extern RxMsgStruc //rxStrucPtrMD[EMV_NUM_COMM],     // Input Buffer and Message Control Structure for modbus
  rxStrucPtrBASP;   // Input Buffer and Message Control Structure for BASP

extern const  tU8 HT_MESSAGE_DEFAULT[SIZEOF_STRING24];
extern const  tU8 HT_TAG_DEFAULT[SIZEOF_STRING6];
extern const  tU8 HT_DESCRIPTOR_DEFAULT[SIZEOF_STRING12];
extern const  tU8 HT_FINAL_ASSEMBLY_NUMBER_DEFAULT[SIZEOF_U24];
extern const  tU8 HT_SERIAL_NUMBER_DEFAULT[SIZEOF_U24];

extern const  COMM_RTS_TIMER_FUNC commStopCharTimer[EMV_NUM_COMM];

// external variable declarations, becasue EMV has one communication at any give time
#define u8MDResponseBuf  u8MDRxTxTempBuf
#define u8MDRequest      u8MDRxTxTempBuf
#define u8HartRxTxBuf    u8HARTRxTxTempBuf
#define u8BaspRxTxBuf    u8BASPRxTxTempBuf

// for field firmware update
extern  tU8 LockedStatus, u8LastSecNum, u8MakeEvenAddr;
extern  tU32 nextBlockAdd;
extern  tReturnStatus EraseStatus;
extern  MSG_CRC16 flashSecInfoCrc;
extern const  COMM_DAM_TX commTxDma[EMV_NUM_COMM];

extern tU16 u16MspAdcCnt[6];

// MSP430 temperature or FB temperature
extern tF32 IntDegF;
extern tF32 IntDegC;
// MSP430 battery voltage or FB voltage
extern  tF32 Vcc;

// sensor 1218 flash
//extern SNScontrol SNS;

#ifdef __JT808_MSP430F5638__
extern const tU8 u8LcdChar[EMV_NUM_CHARS],
  u8LcdNum[EMV_NUM_NUMERICAL],
  u8MonthChar[NUMBER_MONTH_ANNUAL][EACH_MONTH_CHARS];
extern tU8 u8NumTimeInt;
extern WirelessEnv WLPro;
extern tU8 I2cStateReg;
extern tU8 u8FlashStatus;   // W25Q80 status
#endif

// BASP define
extern tU8 bEBaspOn, bBaspGlobalOn, u8BaspHeaderCnt;

// for chart replacement
#define LENGTH_M6TO_M4      64
extern Calendar currentTime;
extern Calendar recordIntervalTime;
extern CHART_PROCESS_STRUC chartRecEnv;
extern tU8 u8M6toM4Temp[LENGTH_M6TO_M4];
extern CHART_A_RECORD showCurrent, curentRecord, showDaily, dailyRecord;
extern tU16  u16PassOverChartEnvt;

#define CHART_EVT_LEGNTH    sizeof(tU16)       // passover chart event size
#define RTC_LENGTH          sizeof(Calendar)   // rtc and intervcal size
#define LOW_CUT_OFF_LENGTH  LENGTH_M6TO_M4 //16  // 4x4 = 16 floating point/each variable, total 4 varibles
extern tU8 u8WtPreRecordBytes[A_RECORD_LENGTH];   // max length of bytes for once record, if it is 4 PVs is MAX

// for radio
//extern RADIO_ENV_STRUC   RadioProcEnv;
extern WirelessApiStruc  WirelessApiMsg;

#endif //GLOBAL_EXTERN_VAR_DEF
