#ifndef MSP5638_CLK_SVS_H
#define MSP5638_CLK_SVS_H
//=============================================================================
// Header: Feature Board MSP430F5638 Harder
// Date Time: 1/26/2013 2:28:00PM
// Author: Xuedong.Liu
//
// Description: define MSP430F5638 in JT808
//
//=============================================================================

// MSP430F5638 PORT MAP DEFINITIONS
// port 1
#define P1_0_5438_REQ_RAM_DAT_EX_IN     BIT0
#define P1_1_REQ_READ_IN                BIT1  //P1_1_5438_RAM_DATA_READY_IN 
#define P1_2_5438A_DR_FLASH_BUS_IN      BIT2
#define P1_3_REQ_READ_IN                BIT3
#define P1_4_5438A_ACK_FLASH_REQ_IN     BIT4
#define P1_5_5438A_ACK_RAM_REQ_IN       BIT5
#define P1_6_PLNGR_ARRIVE_IN            BIT6
#define P1_7_NOT_USED_OUT               BIT7

// port 2
#define P2_0_PROX_EN_OUT                BIT0
#define P2_1_USB0_SPI_FLASH_SIMO_FUNC   BIT1
#define P2_2_USB0_SPI_FLASH_SOMI_FUNC   BIT2
#define P2_3_USB0_SPI_FLASH_CLK_FUNC    BIT3
#define P2_4_USA0_UART_RADIO_TX_FUNC    BIT4
#define P2_5_USA0_UART_RADIO_RX_FUNC    BIT5
#define P2_6_RADIO_CD_NI                BIT6
#define P2_7_NOT_USED_OUT               BIT7
#define P2_OUT_LOW                      P2_0_PROX_EN_OUT                 +\
                                        P2_7_NOT_USED_OUT
#define PT2_FUNC_INPUT                  P2_5_USA0_UART_RADIO_RX_FUNC     +\
                                        P2_6_RADIO_CD_NI  
#define PT2_FUNC_OUTPUT                 P2_4_USA0_UART_RADIO_TX_FUNC
#define PT2_INPUT_PULLUP                P2_2_USB0_SPI_FLASH_SOMI_FUNC    +\
                                        P2_1_USB0_SPI_FLASH_SIMO_FUNC    +\
                                        P2_3_USB0_SPI_FLASH_CLK_FUNC     +\
                                        P2_6_RADIO_CD_NI                 +\
                                        P2_4_USA0_UART_RADIO_TX_FUNC     +\
                                        P2_5_USA0_UART_RADIO_RX_FUNC  

// port 3
#define P3_0_HSC_CLK_IN                 BIT0
#define P3_1_RADIO_BAUD_DETECT_IN       BIT1
#define P3_2_HSC_IN                     BIT2
#define P3_3_NOT_USED_OUT               BIT3
#define P3_4_SMCLK_DEBUG                BIT4
#define P3_5_NOT_USED_OUT               BIT5
#define P3_6_5638_FLASH_CS_OUT          BIT6   // when use it change to output
#define P3_7_5638_RAM_CS_OUT            BIT7   // when use it change to output
#define P3IN_PULLUP                     P3_1_RADIO_BAUD_DETECT_IN       +\
                                        P3_6_5638_FLASH_CS_OUT          +\
                                        P3_7_5638_RAM_CS_OUT
#define P3OUT_PINS                      P3_3_NOT_USED_OUT               +\
                                        P3_5_NOT_USED_OUT
#define P3_FUNC_IN_PINS                 P3_0_HSC_CLK_IN                 +\
                                        P3_2_HSC_IN

                                          // port 4
#define P4_0_5438A_USE_FLASH_IN         BIT0
#define P4_1_MSP_USE_RAM_IN             BIT1
#define P4_2_5638_USE_FLASH_OUT         BIT2
#define P4_3_MSP_USE_RAM_OUT            BIT3
#define P4_4_5638_DR_FLASH_BUS_OUT      BIT4
#define P4_5_5638_REQ5438AREAD_OUT      BIT5  
#define P4_6_5638_ACK_FLASH_REQ_OUT     BIT6
#define P4_7_OTX_RAM_DATA_OUT           BIT7
#define P4IN_PINS                       P4_0_5438A_USE_FLASH_IN     +\
                                        P4_1_MSP_USE_RAM_IN
#define P4OUT_PINS                      P4_2_5638_USE_FLASH_OUT     +\
                                        P4_3_MSP_USE_RAM_OUT        +\
                                        P4_4_5638_DR_FLASH_BUS_OUT  +\
                                        P4_5_5638_REQ5438AREAD_OUT  +\
                                        P4_6_5638_ACK_FLASH_REQ_OUT +\
                                        P4_7_OTX_RAM_DATA_OUT

// port 5
#define P5_0_ADC_REF_PLUSE_FUNC         BIT0
#define P5_1_ADC_REF_MINUS_FUNC         BIT1
#define P5_2_NOT_USED_OUT               BIT2
#define P5_3_5638_DONE_READ_OUT         BIT3   // P5_3_5638_REQ_RAM_DATA_EX_OUT
#define P5_4_5638_REQ_READ_OUT          BIT4   // P5_4_5638_WT_RAM_DONE_OUT
#define P5_5_HSC_FLT_OUT               BIT5
#define P5_6_NOT_USED_OUT               BIT6
#define P5_7_NOT_USED_OUT               BIT7
#define P5OUT_PINS                      P5_2_NOT_USED_OUT               +\
                                        P5_3_5638_DONE_READ_OUT   +\
                                        P5_4_5638_REQ_READ_OUT       +\
                                        P5_5_HSC_FLT_OUT               +\
                                        P5_6_NOT_USED_OUT               +\
                                        P5_7_NOT_USED_OUT

// port 6
#define P6_0_SP_SHNT_OUT                BIT0
#define P6_1_A1_SP_VOLT_IN              BIT1
#define P6_2_ACLK_DEBUG                 BIT2    // LED connect to it
#define P6_3_A3_BATT_VOLT_IN            BIT3
#define P6_4_RADIO_SLEEP_OUT            BIT4    // readio sleep is output, 
#define P6_5_RADIO_RTS_OUT              BIT5
#define P6_6_RADIO_RST_OUT              BIT6    // reset low is active
#define P6_7_HS_AI_FUNC                 BIT7
#define P6OUT_PINS_LOW                  P6_6_RADIO_RST_OUT        +\
                                        P6_0_SP_SHNT_OUT        +\
                                        P6_5_RADIO_RTS_OUT
#define P6OUT_PINS_HIGH                 P6_4_RADIO_SLEEP_OUT
#define P6_FUNC_IN                      P6_1_A1_SP_VOLT_IN      +\
                                        P6_3_A3_BATT_VOLT_IN    +\
                                        P6_7_HS_AI_FUNC         
                                        
// port 7
// p7.0, p7.1 does not exsit; p7.2, p7.3 crystal for USB port
#define P7_4_EN_HS_AI_OUT               BIT4                // low enable HS_AI
#define P7_5_A13_VCM_IN                 BIT5
#define P7_6_NOT_USED_OUT               BIT6
#define P7_7_NOT_USED_OUT               BIT7
#define P7OUT_PINS_LOW                  P7_6_NOT_USED_OUT   +\
                                        P7_7_NOT_USED_OUT
// port8
#define P8_0_DISP_LED_OUT               BIT0
#define P8_1_UCA1_SPI_RAM_Clk_FUNC      BIT1    // when use it changes to function pin
#define P8_2_UCA1_SPI_RAM_SIMO_FUNC     BIT2    // when use it changes to  function pin
#define P8_3_UCA1_SPI_RAM_SOMI_FUNC     BIT3    // when use it changes to  function pin
#define P8_4_CPU_LED_OUT                BIT4            // LED connect to it
#define P8_5_UCB1SDA_LCD_FUNC           BIT5
#define P8_6_UCB1SCL_LCD_FUNC           BIT6
#define P8_7_LCD_PWR_OUT                BIT7
#define P8OUT_PINS_LOW                  P8_0_DISP_LED_OUT   +\
                                        P8_4_CPU_LED_OUT
#define P8IN_PULLUP                     P8_1_UCA1_SPI_RAM_Clk_FUNC  +\
                                        P8_2_UCA1_SPI_RAM_SIMO_FUNC +\
                                        P8_3_UCA1_SPI_RAM_SOMI_FUNC
#define P8OUT_FUNC                      P8_5_UCB1SDA_LCD_FUNC   +\
                                        P8_6_UCB1SCL_LCD_FUNC
// port 9
#define P9_0_ID_B0_IN                   BIT0
#define P9_1_ID_B1_IN                   BIT1
#define P9_2_ID_B2_IN                   BIT2
#define P9_3_ID_B3_IN                   BIT3
#define P9_4_ID_B4_IN                   BIT4
#define P9_5_ID_B5_IN                   BIT5
#define P9_6_ID_B6_IN                   BIT6
#define P9_7_ID_B7_IN                   BIT7

// for MSP ADC12 calculation
#define     R93   249.0f        // k ohms
#define     R95   249           // same as R93
#define     R100  33.2f         // k ohms
#define     R102  249           // k ohms
#define     VCNTS_BATT_V        146.025f  // (R93 + R100) / R100 = (33.2+249)/33.2 = 8.5 , 4096 3.3Vref; (4096/3.3)/8.5 = 146.0249
#define     REF3BD_VCNTS_BATT_V 620.6061  // 4096/3.3/2 = 620.6061, 4096/6.6 = 620.6061
#define     VCNTS_SOLAR_V       620.6061f // (R95 + R102)/R95 = (249 * 2)/249 = 2, 4096 3.3V ref
#define     ADC_RUN_INTERVAL    30 // was -> 60   // need less then 1Byte or 255
#define     INTERVALS_A_DAY     86400/ADC_RUN_INTERVAL     // 3600 seconds/hr * 24 hr/day = 86400 seconds/day, need less than 1U32 

#define     DEAL_BATTERY        3.6f      // deal battery is below 2.6V

#endif //MSP5638_CLK_SVS_H

