#ifndef MSP_CLK_SVS_H
#define MSP_CLK_SVS_H
//=============================================================================
// Header: Feature Board MSP430F5438A Harder
// Date Time: 1/26/2013 2:32 PM
// Author: Xuedong.Liu
//
//=============================================================================
// Description: This is used in MSP clock, SVS, and VCORE init. EMV alwasy use
//              MSP430F5438A
//
//=============================================================================
#define EMV_LPM_ON        LPM3_bits //LPM0_bits //LPM3_bits

typedef enum
{
  F5438 = 0,
  F5438A
}device_t;

enum mspMode
{
  NORNAL_MODE = 0,              // 0
  LPM3_MODE,                    // 1
  LOOK_COMM_DATA,               // 2
  PROCESS_MD_REQUEST,           // 3
  PROCESS_BASP_REQUEST,         // 4
  PROCESS_HART_REQUEST,         // 5
  DEBUG_MODE,                   // 6 debug mode
  CONFIG_MODE,                  // 7
  UPDATE_SENSOR_MODE,           // 8
  UPDATE_LCD_MODE,              // 9
  SEND_LCD_DATA,                // A
  CALC_VCC_BD_TEMP,             // B
  WRITE_PROCESS_MODE,           // C
};

// for queue task
#define NO_TASK_IN_LPM3           0
#define SCHEDULER_IN_QUEUE     BIT0
#define LCD_UPDATE_IN_QUEUE    BIT1
#define MSP_ADC_IN_QUEUE       BIT2
#define SENSOR_UPDATE_IN_QUEUE BIT3
#define CHAR_INUSBPT_IN_QUEUE  BIT4
#define CHAR_IN_FSKPT_QUEUE    BIT5

// for timeout condition
#define LCD_DRIVE_TIMEOUT      BIT0
#define MSP_ADC_TIMEOUT        BIT1
#define SEMSOR_TIMEOUT         BIT2
#define COMMUSB_TIMEOUT        BIT3
#define COMM_FSK_TIMEOUT       BIT4

// for sensor upper layer code use
#define TOP_SENSOR_ID         0u
#define BTM_SENSOR_ID         1u
#define TOTAL_SENSORS         2u

enum setHardwareVersion
{
  VERSION_UNKNOW,       //0
  VERSION_EMV_JT808,    //1
  VERSION_EMV_JT400,    //2
  VERSION_TWO_SENSORS,  //3
  VERSION_NO_RTD,       //4
  VERSION_EXTENED_RTD,  //5
  VERSION_END,          //6
};

enum defProductIdCode
{
  UNKOWN_PRODUCT_ID,
  JTI_PRODUCT_ID,
  END_PRODUCT_ID,
};

#define HART_COMM               1
#define RADIO_USBTYPE           2
#define MAX_MSG_SIZE            (tU16)256     // was 253
#define CRC_LRC_BYTES           (tU16)2
#define u8INIT_CHAR_LOCATION    (tU8)0

// u8DriverStatus bits, layer1 driver defines
#define MSG_MEET_MD_STD         BIT3
#define MSG_MEET_BASP_STD       BIT4
#define MSG_MEET_HART_STD       BIT5

// u8TxStatus bits, layer 2 or 3 drivers defines, when it is zero, TX is waiting for request
#define TX_PROCESS_REQUEST      BIT0
#define TX_RESPONE_READY        BIT1
#define TX_WAIT_LAST_CHAR       BIT2
#define REPEAT_TX               BIT3

enum _floatFromat
{
  FL32_ABCD_FMT = 0,  // default Modbus format
  FL32_CDAB_FMT,
  FL32_DCBA_FMT,      // internal MSP cpu format
  FL32_BADC_FMT,
};

// MSP430F5438A port map
#define MSP_PT_ALL_PINS_IN              0x00
#define MSP_PT_ALL_PINS_DIGI_IO         0x00
#define MSP_PT_ALL_PINS_OUTPUT_LOW      0x00
#define CLEAR_PORT_INT                  0x00
#define MSP_CS_ALL_PINS                 0xFF    // select port all pints
#define MSP_ALL_INT_LOW2HI              0x00    // interrupt edge selection, low->Hi
#define FLASH_SPI_CLK                   1000000
#define SPICLK                          500000
#define RAM_SPICLK                      1000000  // was 10,000,000
#define LOW_SPICLK                      5000   // cystal is 4.9mHz, spec, 4 times slower is the mini limit = 4/4.9 = 0.816mHz
#define BAUD_RATE                       9600    // Radio ports default baud rate
#define FSK_BAUD_RATE                   1200    // port default baud rate
#define OUT_TOP_SNS_CS                  BIT4    // ouput -> top sensor chip select -> top ADS1218
#define OUT_BOT_SNS_CS                  BIT5    // ouput -> bottom sensor chip select -> bottom ADS1218

typedef struct _crc16
{
  //Error[Pm093]: use of union - overlapping storage shall not be used (MISRA C 2004 rule 18.4)
  union
  {
    tU16 word;
    tU8  byte[2];
  } crc;
  tU8 crc_l;           // Low order byte of current CRC
  tU8 crc_h;           // High order byte of current CRC
} MSG_CRC16;

typedef struct
{
  tU16 u16AdcGainFactor;
  tU16 u16AdcOffset;
  tU16 u16AdcRef15Factor;
  tU16 u16AdcRef15Temp30;
  tU16 u16AdcRef15Temp85;
  tU16 u16AdcRef25Factor;
  tU16 u16AdcRef25Temp30;
  tU16 u16AdcRef25Temp85;
} sTlvAdcCalData;

typedef void (*kernalDo)(void);

typedef struct
{
  tU8 u8SearchKey;
  tU8 u8EvenAddr;         // unused
  kernalDo doFunc;
} KERNEL_DEFINE_FUNC;

typedef struct
{
  tU8 *u8OldUnit;
  tU8 *u8NowUnit;
  kernalDo doUnitChange;
} UNIT_CHECK_CHANGE;

#define MSP_OPERATION_LOW_LIMIT -40.0f  // unit is C
#define MSP_OPERATION_HIGH_LIMIT 85.0f  // unit is C

//*****************************************************************************
//Desired Timeout for XT1 initialization
//*****************************************************************************
#define UCS_XT1_TIMEOUT 50000

//*****************************************************************************
//Desired Timeout for XT2 initialization
//*****************************************************************************
#define UCS_XT2_TIMEOUT 50000

//*****************************************************************************
//XT1 Crystal Frequency being used
//*****************************************************************************
#define UCS_XT1_CRYSTAL_FREQUENCY    32768
#define UCS_MCLK_SMCLK_SPEED         1000 //1000 = 1,000K //8000 = 8,000 KHz
#define UCS_RATIO_MCLK_OV_REF        32 //1,000,000/32768 = 30.517 244   // 8,000,000/32768 = 244.14, 25,000,000/32768 = 762.9
//*****************************************************************************
//XT2 Crystal Frequency being used
//*****************************************************************************
#define UCS_XT2_CRYSTAL_FREQUENCY   0

// number ADC result buffer size
#define   Num_of_Results   8

// each 25mSec increase by 1
enum
{
    TASK_1ST_RUN,  // counter = 0
    TASK_2ND_RUN,
    TASK_3RD_RUN,
    TASK_4TH_RUN,
    TASK_5TH_RUN = 4,  // counter = 4
    TASK_RADIO_TX = 20,
    LAST_TASK = 40,     // 25mSec * 40 = 1sec
};

#endif //MSP_CLK_SVS_H

