/* comm.h - communication data structure definitions for 'C' programs
 *
 * This file contains driver data structure definitions for 'C' programs.
 *
 *	ANY CHANGES TO THESE DEFINITIONS SHOULD BE FOLLOWED BY THE COMPLETE
 *	REGENERATION OF THE SYSTEM FROM SOURCE CODE. THERE IS NO OTHER WAY TO
 *	INSURE THAT ALL AFFECTED EXECUTABLE CODE HAS BEEN UPDATED BY THE NEW
 *	DEFINITIONS.
 *
 *
 * PROGRAMMER
 *
 * REVIEWER
 *
 * REVISION HISTORY:
 *
 *======================================================================*/

#ifndef	_COMM_H
#define	_COMM_H


#define	GLOBAL_HDR	12u	    /* number of bytes in global msg header		    */
#define	LOCAL_HDR	          7u	    /* number of bytes in local msg header		    */
#define	MAXFC		255u	    /* max number of message exchange function codes*/
#define	MAXNODE		127u	    /* maximum number of slave nodes		        */


/* **************************************************************************
 *
 *  M I S C E L L A N E O U S   D E F I N E S
 *
 */
#define	ACK		0x86u		/* ACK message function code.		*/
#define	ALIVE		0x04u		/* SNST dead/alive node bit.		*/
#define	ALLOCATE	          0x80u		/* Buffer allocate bit - buf status byte*/

#define	BUFSIZE		0x14u		/* Message word area byte size.		*/
#define	BUSY_SIGNAL	0xF5u		/* Driver status - busy signal.		*/
#define	CTRL_RESPONSE	0x40u		/* Global msg ctrl byte bit for rsp/rqst*/
#define	CTRL_COMMERR	0x80u		/* Global msg ctrl byte bit for comm error   */
#define	DEVRST		0x04u		/* MTOS RIO device reset.		*/

#define	DCDOFF		0xF2u		/* DCD off, msg not sent		*/
#define	ERRADDR		0xF4u		/* illegal Node Address Error		*/
#define	ERRCOMM		0x80u		/* node status bit for COMM error	*/
#define	ERRECOVERY	0xF1u 		/* error recovery, message turn around code  */
#define	ERREXCHG	          0xF5u		/* illegal exchange in slave request message */
#define	ERRLIU		0xF7u		/* LIU comm error			*/
#define	ERRNAK		0xFCu		/* NAK of request message - no slave buffers */
#define	ERRNOWAIT	          0xF4u		/* no wait packets on exchange		*/
#define	ERRNOSEQ	          0xF3u		/* no wait packets with this sequence number */
#define	ERRNRT		0xFBu		/* mismatch of node routing table vers nums  */
#define	ERRSEQ		0xF9u		/* bad protocol sequencing of messages	*/
#define	ERRSERNUM	          0xFAu		/* bad serial number in response message*/
#define	ERRSLAV		0xF6u		/* NO slave line config'ed, msg to go up*/
#define	ERRTIMOUT	          0xFDu		/* timeout of request message		*/
#define	ERRXCHG		0x40u		/* node status bit for error exchange	*/
#define	ERRPARMS	          0xFFu		/* bad svc parameters error		*/
#define	ERROVRFLW	          0xFEu		/* receive buffer overflow error	*/
#define	ERRCRC		0xF8u		/* crc error	*/

#define	FOR_US		0x04u		/* this message is for this node	*/

#define	GBL		0x80u		/* global address AND mask		*/
#define	GLOBAL		0x7Fu		/* global address mask			*/
#define	GLOB_MSG	          0x01u		/* global msg flag value for global msg	*/
#define	GOOD_RETURN	   0u		/* good return from driver		*/
#define	LOCL_MSG	          0x00u		/* global message flag value for LOCAL msg   */


//#define	NAK		0x95u		/* no acknowledgement			*/
#define	NODATAXMT	          0x87u		/* no data to transmit message function code */
#define	DIALUPACK	          0x81u		/* dial up ack function code */
#define	NORMALIZE	          32000u 		/* count limit to normalize statistics tables*/
#define	NOT_FOUND	          0xFFu		/* not found	*/
#define	NOT_FOR_US	0x05u 		/* this message is a passthru msg/not for us */
#define	NO_RESPONSE	0x7Fu		/* SNST no response mask		*/
#define	NRT_BIT		0x40u		/* SNST Node Routing Table needed bit	*/
#define	NRTMSG		0x88u		/* node routing table message function code  */
#define	NRTREQ		0x89u		/* node routing table request function code  */

#define	POLL		0x85u		/* poll message function code		*/

#define	RETRY_2		    2u		/* number of message retransmits	*/
#define	SLAVE		    0u 		/* slave unit and device #		*/

#define	TIME_SYNC	          0x20u		/* SNST Node Routing Tabl time sync needed bit*/
#define	TIME_SYNC_PRIORITY  0x80u		/* Time sync message priority		*/
#define	TIMESTAT	          0xFCu		/* time out status code			*/
//#endif
// wireless communication
#define CMD_ModeIn          "+++"
#define CND_ModeExit        "ATCN"
#define CMD_SetHostAddrLow  "ATDL"
#define CMD_Write           "ATWR"
#define CMD_PullUp          "ATPR"
#define CMD_CtsCtrl         "ATD7"
#define CMD_RSSI            "ATP0"
#define CMD_SetMyAddr       "ATMY"
#define CMD_SleepMode       "ATSM"
#define CMD_API_mode        "ATAP"
#define CMD_AckFailure      "ATEA"
#define CMD_RFThreshold     "ATCA"
#define CMD_PortSpeed       "ATBD"
#define CMD_RestoreDefaults "ATRE"
#define CMD_PowerLevel      "ATPL"
#define CMD_FirmWareVersion "ATVR"  //look the dataline monitor for the version
#define CMD_Enter           0x0du

// state not over 255, add state before STATE_END, WL= Wireless
enum {
    WL_RESEVE_STATE,
    WL_BUSY_STATE,      // radio is in send data out
    WL_IDLE_STATE,      // ready to send data out
    WL_STATE_END,
};

//status not over 255, add status code before DripPotStatus_end
enum {
  DripPotStatus_ok,
  DripPotStatus_error,

  DripPotStatus_end,
};
#define RADIO_MESSAGE_REV    1  // define u8MessID value

typedef struct {
  tU8 u8DeviceAddress;
  tU8 u8MessID;
  CHART_A_RECORD chatMessage;
  tU8  u8DpUnitCode;
  tU8  u8SpUnitCode;
  tU8  u8RtdUnitCode;
  tU8  u8FreeEvenStruc;
  tF32 f32Ai_0_Val;
  tF32 f32Ai_1_Val;
  tF32 f32VoltBatVal;
  tF32 f32VoltSolarVal;
  tF32 f32BdTemperatur;
  tF32 f32HscVal; 
  tU16 u16Dio_status;
  tU16 u16DevStatus;
  tU32 u32TxChartRecInterval;
  tU32 u32RadioSenderID;        // board serial number  infoD.xmt.u8SerialNumber[4]
  tU8  u8MsgCheckSum;
} JT400RadioMessageStruc;

#pragma pack(1)
typedef struct {
    unsigned char   StartDelimiter;       //see MAXStream OEM RF Modules manual
    unsigned int    Length;               //see MAXStream OEM RF Modules manual
    unsigned char   ApiID;                //see MAXStream OEM RF Modules manual
    unsigned char   FrameID;              //see MAXStream OEM RF Modules manual
    unsigned int    Receiv_ch_id;         //see MAXStream OEM RF Modules manual
    unsigned char   Options;              //see MAXStream OEM RF Modules manual
    JT400RadioMessageStruc OurMsg;          //see MAXStream OEM RF Modules manual
    unsigned char   CheckSum;             //see MAXStream OEM RF Modules manual
}  WirelessApiStruc;
#pragma pack()

#define MessLength  (tU8)sizeof(JT400RadioMessageStruc)
#define WirelessCharSize MessLength + 8u   //5 start from ApiID to OurMsg
#define RADIO_MSG_LENTH  sizeof(WirelessApiStruc) //37  // should 37 bytes

enum {
  CALC_WT_LEVEL,
  CALC_TOPSNS_DATA,
  CALC_BTMSNS_DATA,
};

#define SEND_CH_ID_DEF        6u    //sender wireless channel id (adderss) default = 6 ASCII
#define WIRELESS_SLEEPMODE    '1'
#define API_MODE              '2'   //return to default mode as MASStream setup, change this to '0'
#define DRIP_MY_ADDRESS_DEF   3u    //default drip pot my address 1100
#define STARTDELIMITER        0x7Eu
#define API_ID                0x01u
#define OPTIONS               0x04u
#define RECEIV_CH_ID_DEF      0x10u  //receiver channel id (address) default = 0x10
#define START_FRAME_ID        0x01u
#define END_FRAME_ID          0xFEu
#define ESCAPE                0x7Du
#define XON                   0x11u
#define XOFF                  0x13u
#define XOR_WITH              0x20u
#define CELLINGSUM            0xFFu
#define API_EXTRA_CHAR        0x05u
#define SAMPLE_RATE_DEF       1u    //default sampling rate one/10second
#define TRANSMIT_RATE_DEF     2u    //default transmit rate one/100second
#define AVERAGE_SAMPLES_DEF   10u
#define POWER_LEVEL           '4'  //default is ASCII 4
#define PULL_UP_DISABLE       '0'
#define CTS_CTRL_DISABLE      '0'
#define PT115200RATE          '7'
#define MAXWAIT_STATUS         3u
#define TX_STATUS_SIZE         7u
#define TX_STATUS_START_PNT    0u
#define TX_STATUS_API_ID_PNT   3u
#define TXStatusApiID         0x89u
#define TX_STATUS_VALUE_PNT    5u
#define TX_PK_ID_O_ESCAPE      4u
#define TX_STATUS_SUCCESS     0x00u
#define TX_DMA_START          1
#define TX_RADIO_DONE         2
//#define WL_RETRY_NUM           2u

//wireless environments
typedef struct {
  tU8  SChID[6];       //sender channal ID, max hex 0xffff, decimal ASCII 65536
  tU8  SleepMode_v;    //wireless sleep mode, reference datasheet
  tU8  API_mode;       //set wireless API mode, 1,2,3.  reference datasheet
  tU8  NexState;       //wireless state virable
  tU8  line;           //init or BASP changes wireless ID (address) re-init, which line idx
  tU8  AverageNum;     //Average on number of 1, 2, 3, ... 10
  tU8  endSNScal;      //BOOL, synchronize Sensor sampling data and wireless sending data
  tU8  u8RxStatus;     // what kind status received
  tU8 evenAddr;        // unused  
} WirelessEnv;

typedef void (*radioRdWt)(void);
#define tRadioFunc  radioRdWt

typedef struct {
 tU8 WL_cmd[4];
 tU8 Parameter[5];
 //tU8 evenAddr;        // unused
 tU16 CMD_LENGTH;
} wireless_cmd;

// Radio Tx done process
typedef struct {
  tRadioFunc txFunc;
  tU8    u8ThisState;
  tU16   u16RxTimer;
  tU8    u8RxDoneState;
} TxDmaProc;

// Radio Done Rx process
typedef struct {
  tRadioFunc rxFunc;  
  tU8    u8ThisState;
  tU8    u8GoState;
} RxCharProc;

// Radio standar process
typedef struct {
  tRadioFunc TxFunc;  
  tU16   u16setTimer;
  tU8    u8ThisState;
  tU8    u8NextDoState;
  tU8    u8TimeOutState;
  tU8    u8RxBytes;
} RadioNormalProc;

// Radio timer out process
typedef struct {
  tRadioFunc timerFunc;  
  tU8    u8ThisState;
  tU8    u8TxDoneState;
  tU8    u8RxBytes;
} RadioTimerProc;


// define u8RadioDoneTxState
enum { // DMA TX done state
  Wait1Sec_OK,
  waitCharTimer,
};

// define u8RadioDoneRxState
enum { // DMA TX done state
  ACK_IN_CMD,
  OK_Default,
};

// define u8RadioNormalState
enum { // DMA TX done state
  RESET_DEFAULT,
  SET_MY_ADDR,
};
// define u8RadioTimerOutState
enum { // timerout state
  TxIn_CMD_MOD,     // = 0 send +++ in CMD state
  STOP_PROCESS,     // = 1 end all process state
};  // defined Radio Tx/Rx Idx

#define NO_TIMER_ON   0
#define QUIET_1SEC    49152  // wait 1 second
#define QUIET_2SEC    32768  // wait 2 second 16384 + 32768 = 49152
#define CHAR_LongT    100    //9600 baud 1msec/char, wait 3mSec, 32768 * 0.003 = 98, 100/32768 =  
#define INITIAL_STATE 0xFF

#define OK_BYTES              2
#define OK_VALUE              'OK'
#define RADIO_RX_BUFF_SIZE    16
//EXTFUNC void WirelessSleepMode(void);

#define WirelessEnter_CMD_Time  2u   // is about 2 * 1/32768 = 2 * 30 = 60uSec
#define WirelessRetry_Interval   (WirelessEnter_CMD_Time * 6u)

/*
 **************************************************************************
 *
 *	COMMUNICATIONS RELATED Prototypes
 *
 **************************************************************************
*/

extern void Get_p2p_analogs(void *dest);	/* 5 fp values for 3508 comm */
extern void Get_p2p_units(void *dest);		/* 4 fp values for 3508 comm */
extern void RX_StateProcess (void);

extern unsigned comm_errs;                     // Receive Character error count
#define WirelessCmdRxOK  "OK"
#define CmdRxSuccess  0

//--- message ASCII command codes
#define Aques      '?'
#define Apound     '#'
#define Aless      '<'
#define Agrtr      '>'
#define Asemi      ';'
#define Acolon     ':'
#define Aaster     '*'
#define Aexclam    '!'
#define Aequal     '='
#define Aamper     '&'

// --- ASCII characters
#define Aone       '1'
#define Azero      '0'
#define Aseven     '7'
#define Anine      '9'
#define Aleftbr    '['
#define Aspace     ' '
#define Acret      0x0D
#define Aplus      '+'
#define Aminus     '-'
#define Apoint     '.'
#define A_A        'A'
#define A_E        'E'
#define A_H        'H'
#define A_L        'L'
#define A_N        'N'
#define A_O        'O'
#define A_R        'R'
#define A_S        'S'
#define A_W        'W'
#define A_Y        'Y'
#define DEFDIG      8

// time in units of 62.5 ms interrupts
#define QTRSEC      4             // 250 / 62.5
#define HALFSEC     8             //500 / 62.5
#define ONESEC      2 * HALFSEC
#define FIVESEC     5 * ONESEC
#define TENSEC      10 * ONESEC
#define ONEMIN      60 * ONESEC
//--- write message types
#define MT_WRAX     10    // write coef or zero or full scale
#define MT_WRPWM    11    // write PWM
#define MT_WRCAL    12    // write Calibration code

//--- message types
enum {
   MT_NULL,              //  0     //no message - do nothing
   LC_DripPotAdd,
   LC_MsgLength,
   LC_DripPotStatus,
   LC_UnitCode,
   LC_WaterLevel,
   LC_WaterChange,
   LC_UppRead,
   LC_LowRead,
   LC_DiStatus,
   LC_MsgCheckSum,
};

// in message DataSource, DataType define
enum {
  FloatData,  //0 DataType is 4 bytes
  ByteData,   //1 DataType is 1 byte
  IntData,    //2 DataType is 2 btyes
};

typedef struct {
 int MsgTypeIndex;
 tU8 *NameString;    // char
 tU8 *DataSource_pt; // char
 tU8 DataType;       //BYTE
} LocalMsg;

// --- serial comm error codes
#define RADIO_NOERR       '0'
#define RADIO_CKSERR      '1'    // checksum error
#define CMDERR             2     // invalid command
#define ZFSERR             3     // full scale write out of order
#define BUERR              4     // invalid base unit code

#define MSGREQ     BIT0  // process message request
#define PASS       0u
#define FAIL       -1u

#define Dummy       0u

// start of the radio interface
// CMD Code definitions
enum {
  UNUSED_RADIO_CMD,           //0x00
  RD_RADIO_TX_MSG,            //0x01
  SET_RADIO_START,            //0x02
  SET_RADIO_TX_TIMER,         //0x03
  RD_RADIO_STATUS,            //0x04
  RD_RADIO_TX_INTERVAL,       //0x05
  RD_RADIO_RX_DESTINAT_ID,    //0x06
  START_RADIO_API_INIT,       //0x07
};

// define radio status
#define RADIO_TX_ON           BIT0
#define RADIO_API_INIT_DONE   BIT1
#define RADIO_CHIP_UNINSTALL  BIT2
#define BAT_POWR_UNINSTALL    BIT3
#define USER_OPERATE_RADIO    BIT4
#define TX_MSG_FLASH_LCD      BIT5
#define START_INIT_RADIO      BIT6
#define Tx_RADIO_DATA         BIT7

#define MAX_INIT_LOOP         3

#define CHECK_RADIO_TX_T      8    // 8 scope see is 1.000S at 8MHz
                                   // 9 scope see is 1.128S at 8Mhz
 
typedef struct _RADIOCMD
{
 tU8 u8CmdLength;
 tU8 u8CmdCode;
 tU8 *u8CmdDataPtr;
} RADIO_HOST_CMD;

typedef struct _RADIOResponse
{
 tU8 u8ChartRspLength;
 tU8 u8ChartRspID;
 tU8 u8ChartRspCode;
 tU8 u8EvenAddr;                // unused
 tU8 *u8ChartRspDataPtr;
} RADIO_PRO_RESP;

// BSL function call
typedef tU8 (*radioFunc)(RADIO_HOST_CMD *cmdInPtr, RADIO_PRO_RESP *rspOutPtr);

typedef struct {
  tU8       u8RadioCmdCode;
  tU8       u8EvenAddr;        // unused
  radioFunc radioFuncPtr;
} RADIO_FACE_USER;

// end of the radio interface
#endif
