#ifndef DEFINE_UTILITY
#define DEFINE_UTILITY
//=============================================================================
// Header: define static structure for systems utility function 
// DateTime: 8/30/2013 11:50:32 AM
// Author: Xuedong Liu
//
// Copyright (c) 2013  NewGate Instrument
//
//=============================================================================
// type definitions
#define CNT3095_LO_LIMIT     0
#define CNT3095_HI_LIMIT     16777215    // 0x1000000-1 -> 24 bits A/D

static const P_UNIT_CONVERT_TABLE presConvTable[] =  // convert to PSI
{
  {U_inH2OAt68F,      27.729761f},    //U_inH2OAt68F to PSI
  {U_inHgAt0C,        2.0360258f},    //U_inHgAt0C to PSI
  {U_ftH20At68F,      2.3108134f},    //U_ftH20At68F to PSI
  {U_mmH20At68F,      704.33564f},    //U_mmH20At68F to PSI
  {U_mmHgAt0C,        51.715073f},    //U_mmHgAt0C to PSI
  {U_psi,             1.0f},          //U_psi to PSI
  {U_bars,            0.06894757f},   //U_bars to PSI
  {U_milliBars,       68.94757f},     //U_milliBars to PSI
  {U_gramPerSqCm,     70.306955f},    //U_gramPerSqCm to PSI
  {U_kiloGramPerSqCm, 0.070306955f},  //U_kiloGramPerSqCm to PSI
  {U_pascals,         6894.757f},     //U_pascals to PSI
  {U_kiloPascals,     6.894757f},     //U_kiloPascals to PSI
  {U_torr,            51.715073f},    //U_torr to PSI
  {U_atm,             0.068045961f},  //U_atm to PSI
  {U_inH2OAt60F,      27.707271f},    //U_inH2OAt60F to PSI
  {U_megaPascals,     0.006894757f},  //U_megaPascals to PSI
  {U_inH20At4C,       27.680671f},    //U_inH20At4C to PSI
  {U_mmH20At4C,       703.08891f},    //U_mmH20At4C to PSI
};
#define P_CONV_TABLE_SIZE     lengthof(presConvTable)

static const PT_UNIT_CONVERT_TABLE ptConvTable[]=  // convert to Celsius
{
    {U_celsius,     1.0f,   1.0f,   0.0f},      // U_celsius to Celsius
    {U_fahrenheit,  5.0f,   9.0f,   32.0f},     // U_fahrenheit to Celsius
    {U_rankine,     5.0f,   9.0f,   491.67f},   // U_rankine to Celsius
    {U_kelvin,      1.0f,   1.0f,   273.15f},   // U_kelvin to Celsius
#if 0
    {delisle,       2.0f,   3.0f,   100.0f},    // delisle to Celsius, may use in user define unit
    {Newton,        100.0f, 33.0f,  0.0f},      // Newton to Celsius, may use in user define unit
    {Reaumur,       5.0f,   4.0f,   0.0f},      // Reaumur to Celsius, may use in user define unit
    {Remer,         40.0f,  21.0f,  7.5f},      // Remer to Celsius, may use in user define unit
#endif
};
#define PT_CONV_TABLE_SIZE      lengthof(ptConvTable)

#define LINK_DP_UNIT_CHANGE     11
#define LINK_SP_UNIT_CHANGE     11
#define LINK_PT_UNIT_CHANGE     12

#endif // #ifndef DEFINE_UTILITY

