//=============================================================================
// Header: JTI808 1st application -> pluger lift
// Date Time: 9/20/2013 8:30 AM
// Author: Xuedong.Liu
//
// Description: manage the ADC on AC pressure, Enable or disable the circuts
//     around this function, ceate report when there is need.   sensor the
//     pruger arrive, and control progure lease, If it is passible calculate
//     water amount, arriver time, repeat time etc.
//
//=============================================================================

// constant definitions, type definitions
#include "masterHeader.h"

// global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

// local static variables
tU32 u32MemCtrlReg;       // local variable to memory the plunger lift control register setting
//PLUNGER_API_ENV plngApi;   // environment for plunger lift

// function prototype
void plngInitState(void);
void plngFallState(void);
void plngRiseState(void);
void plngTopState(void);

// global & local function implementation
void modigyCtrlStatusReg(tU32 u32InReg)
{
  tU8 i;
  tU32 u32SetClear;
  for (i = 0; i < 32; i++)
  {
    u32SetClear = 1 << i;
    if((u32InReg & u32SetClear) == u32SetClear)
    {
      u32MemCtrlReg |= u32SetClear;                // set bit to 1
    }
    else
    {
      u32MemCtrlReg &= (tU32)~u32SetClear;         // clear bit to 0
    }
  }
}

tU8 wtPlngCtrl(ACCESS_VER_INFO *rwVarInfo)
{
  tU32 u32Temp = *(tU32*)rwVarInfo->eepVarAddr;

  modigyCtrlStatusReg(u32Temp);  // modify local register

  return rwVarInfo->u8RspBufPtr;
}

//=============================================================================
// end file by xuedong
//=============================================================================

