//=============================================================================
// Header: JT808 feature board kernel
// Date Time: 1/13/2013 1:33:00PM
// Author: Xuedong.Liu
//
//=============================================================================
//constant definitions, type definitions
#include "masterHeader.h"

//global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

// local function prototype definitions:
static void lowPowerMode3(void);
static void notDoneLayer2Func(void);
static void notDonelayer1Funcs(void);
static void notDoneOtherTaskFunc(void);
static void notDoneDiagErrFunc(void);
static void initInterActiveFlags(void);
static void masterResetSys(void);
static void initSystemBuffer(void);
static void initSystemRamVars(void);
static void startUSB(void);
//static void unplugUSB(void);
static void doCallTask(tU8 u8SechValu, tU8 u8LayerV);
static void actualDo(tU8 u8LayerV, tU8 u8idx);

// local static variables
static  tU8   u8index, u8PwrOnDoOnce = NO;
// flag u8Layer2TaskScheduler to do functions
static const KERNEL_DEFINE_FUNC layer2TaskFuncs[] =
{
  { TX_RAM_DATA,              0, ctrlRamBusTxData},     //b0 = free
  { PRO_LCD_UPDATE_REQ,       0, LcdLayer2Driver},      //b1 = start LCD driver
  { CHARGE_BAT_HS_AI,         0, batteryChargeOnOff},   //b2 =
  { SEND_DATA_2RADIO,         0, CommunicationDriver},  //b3 = start radio Tx message
  { RD_RAM_DATA_DONE,         0, doneRequestRxRamData}, //b4 =
  { USB_MD_REQ_READY,         0, modbusLayer2Driver},   //b5 = process the host Modbus request, format the response,
  { NOT_USE_BIT6,             0, notDoneLayer2Func},    //b6 = start to read RAM data
  { DONE_TX_RADIO_MSG,        0, doneTxRadioMsg},       //b7 = DoneRadioTxDo}, //radio done Tx whole message
};

// flag u8Layer1TaskScheduler to do functions
static const KERNEL_DEFINE_FUNC layer1TaskFuncs[] =
{
  { USB_RECEIVED_CHARS,       0, driversLookCommRxBuf}, //b0 = start look the chars after USB Rx char(s),
  { RS485_BASP_REQ_READY,     0, BASPLayer2Driver},     //b1 =
  { START_MSP_ADC,            0, startMspAdcSeq},       //b2 =
  { READ_OTHER_RAM_DATA,      0, ctrlRamBusRxData},     //b3 =
  { INTERF_SEND_LCD_CTRL1,    0, LcdLayer1Driver},      //b4 = send data to I2C LCD driver
  { RADIO_CHAR_TIMEOUT,       0, notDonelayer1Funcs},   //b5 =RadioTimerInterruptDo}, //
  { RADIO_RECEIVED_CHARS,     0, notDonelayer1Funcs},   //b6 =doneRadioRxDo}, //
  { NOT_USE_BIT7,             0, notDonelayer1Funcs},   //b7 = //{ TIMEOUT_RETRY_TX,      waitSpiBusTimeoutRetry},   //b7 =
};

// flag u8OtherTaskScheduler to do functions
static const KERNEL_DEFINE_FUNC otherTaskFuncs[] =
{
  { NOT_USE_BIT0,             0, notDoneOtherTaskFunc}, //b0 =
  { NOT_USE_BIT1,             0, notDoneOtherTaskFunc}, //b1 =
  { NOT_USE_BIT2,             0, notDoneOtherTaskFunc}, //b2 =
  { NOT_USE_BIT3,             0, notDoneOtherTaskFunc}, //b3 =
  { DYNAMIC_WT_IMFOA,         0, dynamicWriteinfoA},    //b4 = write data to MSP430F5438A info flash A,   DYNAMIC_WT_IMFOA,      dynamicWriteinfoA
  { DYNAMIC_WT_IMFOB,         0, dynamicWriteinfoB},    //b5 = write data to MSP430F5438A info flash B,   DYNAMIC_WT_IMFOB,      dynamicWriteinfoB
  { DYNAMIC_WT_IMFOC,         0, dynamicWriteinfoC},    //b6 = write data to MSP430F5438A info flash C,   DYNAMIC_WT_IMFOC,      dynamicWriteinfoC
  { DYNAMIC_WT_IMFOD,         0, dynamicWriteinfoD},    //b7 = write data to MSP430F5438A info flash D,   DYNAMIC_WT_IMFOD,      dynamicWriteinfoD
};

// flag u8DoDiagErrorProcess to do functions
const KERNEL_DEFINE_FUNC processDiagErrFuncs[] =
{
  {NOT_USE_BIT0,              0, notDoneDiagErrFunc},   //b0 ->
  {CHECK_CHART_RECORD,        0, notDoneDiagErrFunc},   //b1 -> this MSP only does read not do the write in chart operation
  {NOT_USE_BIT2,              0, notDoneDiagErrFunc},   //b2 ->
  {NOT_USE_BIT3,              0, notDoneDiagErrFunc},   //b3 ->
  {NOT_USE_BIT4,              0, notDoneDiagErrFunc},   //b4 ->
  {CHART_WRITE_RAM_OP,        0, notDoneDiagErrFunc},   //b5 -> this MSP only does read not do the write in chart operation
  {FLASH_WT_ERASE_CK,         0, wrtieLowHiBuffToFlash},//b6 ->
  {UPDATE_FW_PAGE_PROG,       0, notDoneDiagErrFunc}, //main_update},          //b7 ->
};

// global & local function implementation
static void notDoneLayer2Func(void)
{
  // clear the flag, not implement what to do yet
  u8Layer2TaskScheduler &= (tU8)~layer2TaskFuncs[u8index].u8SearchKey;
}
static void notDonelayer1Funcs(void)
{
  // clear the flag, not implement what to do yet
  u8Layer1TaskScheduler &= (tU8)~layer1TaskFuncs[u8index].u8SearchKey;
}
static void notDoneOtherTaskFunc(void)
{
  // clear the flag, not implement what to do yet
  u8OtherTaskScheduler &= (tU8)(~layer1TaskFuncs[u8index].u8SearchKey);
}
static void notDoneDiagErrFunc(void)
{
  // clear the flag, not implement what to do yet
  u8DoDiagErrorProcess &= (tU8)~processDiagErrFuncs[u8index].u8SearchKey;
}

static void masterResetSys(void)
{
    // power on read flash data, pass them over to other MSP
    eepGetMspInfoData((tU8 *)MSP_INFOA_ADDR, INFO_5638A_SIZE, (tU8 *)&info5638A);
    eepGetMspInfoData((tU8 *)MSP_INFOB_ADDR, INFO_5638B_SIZE, (tU8 *)&info5638B);
    eepGetMspInfoData((tU8 *)MSP_INFOC_ADDR, INFO_5638C_SIZE, (tU8 *)&info5638C);
    eepGetMspInfoData((tU8 *)MSP_INFOD_ADDR, USED_INFOD_SIZE, (tU8 *)&info5638D);  // it is free for 2014-10-09now
    __no_operation();  // for debug
    __no_operation();  // for debug

    if (info5638C.u8StrucRevNum != CURRENT_EEPREV)
    {
        initSystemBuffer();// the feature board is new

        // write back to power cycle save,
        eepWtMspInfoAData((tU8 *)MSP_INFOA_ADDR, INFO_5638A_SIZE, (tU8 *)&info5638A);
        __no_operation();  // for debug
        eepWtMspInfoData((tU8 *)MSP_INFOB_ADDR, INFO_5638B_SIZE, (tU8 *)&info5638B);
        __no_operation();  // for debug
        eepWtMspInfoData((tU8 *)MSP_INFOC_ADDR, INFO_5638C_SIZE, (tU8 *)&info5638C);
        __no_operation();  // for debug
        eepWtMspInfoData((tU8 *)MSP_INFOD_ADDR, INFO_5638C_SIZE, (tU8 *)&info5638D);
        __no_operation();  // for debug
    }
          
    info5638D.u8Fw5638Rev[0] =
    info5638D.u8Fw5638Rev[1] = 0;
    info5638D.u8Fw5638Rev[3] = BuildFwInfo.u8VerBeta;
    info5638D.u8Fw5638Rev[2] = BuildFwInfo.u8VerMinor;

    info5638D.u8HardwareId = P9IN; 
#if 0
    GPIO_getInputPinValue(
             __MSP430_BASEADDRESS_PORT9_R__,
             GPIO_PORT_P9,
             MSP_CS_ALL_PINS);
#endif
    initSystemRamVars();
    // nothing to do
    __no_operation();  // for debug
}

//==============================================================================
// FUNCTION:        lowPowerMode3
//
// DESCRIPTION:     Enters LPM3 and waits for interrupts either communication
//                  port, time for get sensor data, time for update LCD.
//==============================================================================
static void lowPowerMode3(void)
{
  tU8 temp;

  temp = u8Layer2TaskScheduler | u8Layer1TaskScheduler |
      u8OtherTaskScheduler | u8DoDiagErrorProcess;
  if(temp == 0)
  {
    switch(USB_connectionState())
    {
      case ST_USB_DISCONNECTED:
        if(temp == 0)
        {
          __no_operation();
          __bis_SR_register(EMV_LPM_ON + GIE); // Enter LPM3
          __no_operation();
        }
        else
        {
          __no_operation();
        }
        break;
      case ST_USB_CONNECTED_NO_ENUM:
          __no_operation();
          break;
      case ST_ENUM_ACTIVE:
          __no_operation();
          __bis_SR_register(EMV_LPM_ON + GIE); // Enter LPM0
          __no_operation();
          break;
      case ST_ENUM_SUSPENDED:
          __no_operation();
          break;
      case ST_ENUM_IN_PROGRESS:
          __no_operation();
          break;
      case ST_NOENUM_SUSPENDED:
          __no_operation();
          break;
      case ST_ERROR:
          __no_operation();
          break;
      default:;
    }
  }
}

//==============================================================================
// FUNCTION:        initInterActiveFlags
//==============================================================================
static void initInterActiveFlags(void)
{
    memset(u8UsedPort, ALL_FLAGS_ZERO, TOTAL_FLAGE_ARRAY); // bit0 = 1 USB MSP430F5438A, bit3 = 1 USB MSP430F5638
    u8Layer2TaskScheduler = ALL_FLAGS_ZERO;  // process flag, these flag happen in timer interval
    u8Layer1TaskScheduler = ALL_FLAGS_ZERO;  // interface flag, need interface to do the work when flag is set
    u8OtherTaskScheduler  = ALL_FLAGS_ZERO;  // interface flag, communication has complete request, or process need data is ready
    u8DoDiagErrorProcess  = ALL_FLAGS_ZERO;  // interface flag, timer related, start timer or timeout flags
}

static void initSystemBuffer(void)
{
  tU8 u8ZeroDate[10] = {0,0,0,0,0,0,0,0,0,0};
  tU8 u8FfDate[10] = {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
  memmove(info5638D.u8RtdUserUnitChar, "       ", 8);
  info5638D.u8StrucRevNum = CURRENT_EEPREV;
  info5638D.u32RadioTxInterval = RECEIV_CH_ID_DEF; //48600;  // is about 1 day, use it as radio destinatino address
  info5638D.f32LowCutOff[0] = 1.0f;
  info5638D.f32LowCutOff[1] = 2.0f;   
  info5638D.f32LowCutOff[2] = 1.0f;
  //info5638D.f32LowCutOff[3] = 0.0f;
  info5638D.u8HardwareId = P9IN; 
  
  memset (info5638B.u8UserDescrip, 0x20, 16);
  memmove(info5638B.u8UserDescrip, "JT400", 5);
  memmove(info5638B.u8DpUserUnitChar, "       ", 8);
  memmove(info5638B.u8SpUserUnitChar, "       ", 8);
  info5638B.u8Io5638Control = 0;

  if((memcmp(info5638C.u8DpZeroCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8DpZeroCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8DpZeroCalDate, "2015/10/10", 10);
  }
  if((memcmp(info5638C.u8DpSpanCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8DpSpanCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8DpSpanCalDate, "2015/10/10", 10);
  }
  if((memcmp(info5638C.u8SpZeroCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8SpZeroCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8SpZeroCalDate, "2015/10/10", 10);
  }
  if((memcmp(info5638C.u8SpSpanCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8SpSpanCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8SpSpanCalDate, "2015/10/10", 10);
  }
  if((memcmp(info5638C.u8RtdZeroCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8RtdZeroCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8RtdZeroCalDate, "2015/10/10", 10);
  }
  if((memcmp(info5638C.u8RtdSpanCalDate, u8ZeroDate, 10) == 0) ||
     (memcmp(info5638C.u8RtdSpanCalDate, u8FfDate, 10) == 0))
  {
    memmove(info5638C.u8RtdSpanCalDate, "2015/10/10", 10);
  }
  
  
  info5638B.f32OffsetBatV      = 0.0f;          // battery offset
  info5638B.f32OffsetSolarV    = 0.0f;          // Solar Volt offset
  info5638B.f32MspBdTempOffset = 0.0f;          // bd temeprature offset
  info5638B.f32SlopBatV = 1.0f;
 
  info5638A.u16LcdControlBits = 127;            // set lowest 7 bits to 1
  info5638A.u16LcdCtrlHiWord = 0;               // set to zero
  info5638A.u16LcdHoldTime = 3;                 // set holding time to 3
  for(tU8 i = 0; i < 9; i++)
  {
    memset (info5638A.u8VarLabel[i], 0x20, 7);
  }
  for(tU8 i = 0; i < 9; i++)
  {
    memset (info5638A.u8UserDefUnit[i], 0x20, 6);
  }
  
  info5638C.u8StrucRevNum = CURRENT_EEPREV;
}

static void initSystemRamVars(void)
{
  sysRam56D.exchg6Pv.u32Op5638Status = 0;
  sysRamData.diag.u16FramingErr = 0x0F00;  // input init to input high
  sysRamData.diag.u8RadioStatus = BAT_POWR_UNINSTALL + RADIO_CHIP_UNINSTALL;
}

static void startUSB(void)
{
  //XT2_Start(XT2DRIVE_0); 
  
  SetVCore(3);

  SFRIE1 &= ~OFIE;
  Init_FLL_Settle(16000, 488); //(8000, 244);
  SFRIFG1 = 0;
  SFRIE1 |= OFIE;

    USB_init();               //Init USB
    //Enable various USB event handling routines
    USB_setEnabledEvents(kUSB_allUsbEvents);
#if 0
        kUSB_VbusOnEvent + kUSB_VbusOffEvent + kUSB_receiveCompletedEvent
        + kUSB_dataReceivedEvent + kUSB_UsbSuspendEvent + kUSB_UsbResumeEvent +
        kUSB_UsbResetEvent);
#endif
    //See if we're already attached physically to USB, and if so, connect to it
    //Normally applications don't invoke the event handlers, but this is an exception.
    if (USB_connectionInfo() & kUSB_vbusPresent)
    {
        USB_handleVbusOnEvent();
    }
}
#if 0
static void unplugUSB(void)
{
  //XT2_Stop(); 
  
  SetVCore(1);              // was 1
  
  SFRIE1 &= ~OFIE;
  Init_FLL_Settle(8000, 244);
  SFRIFG1 = 0;
  SFRIE1 |= OFIE; 
}
#endif

static void actualDo(tU8 u8LayerV, tU8 u8idx)
{
  //tU8 u8task;
  switch(u8LayerV)
  {
     case 1:       // layer2TaskFuncs function
        layer2TaskFuncs[u8idx].doFunc();
        //u8task = 1;
        __no_operation();
        break;
     case 2:       // layer1TaskFuncs function
        layer1TaskFuncs[u8idx].doFunc();
        //u8task = 2;
        __no_operation();
        break;
     case 3:       // otherTaskFuncs function
        otherTaskFuncs[u8idx].doFunc();
        //u8task = 3;
        __no_operation();
        break;
     case 4:       // processDiagErrFuncs function
        processDiagErrFuncs[u8idx].doFunc();
        //u8task = 4;
        __no_operation();
        break;
     default:
        break;
  } 
       
  __no_operation();

}
         
static void doCallTask(tU8 u8SechValu, tU8 u8LayerV)
{
  tU8 u8LookFlag, i;
  while (u8SechValu != 0)
  {
      for (i = 0; i < 8; i++)
      {
          u8LookFlag = 1 << i;
          if((u8SechValu & u8LookFlag) == u8LookFlag)
          {
              break;
          }
      }
      switch(u8LookFlag)
      {
           case (1 << 0):       // bit 0 set
                actualDo(u8LayerV, 0);
                __no_operation();
                break;
           case (1 << 1):       // bit 1 set
                actualDo(u8LayerV, 1);
                __no_operation();
                break;
           case (1 << 2):       // bit 2 set
                actualDo(u8LayerV, 2);
                __no_operation();
                break;
           case (1 << 3):       // bit 3 set
                actualDo(u8LayerV, 3);
                __no_operation();
                break;
           case (1 << 4):       // bit 4 set
                actualDo(u8LayerV, 4);
                __no_operation();
                break;
           case (1 << 5):       // bit 5 set
                actualDo(u8LayerV, 5);
                __no_operation();                                
                break;
           case (1 << 6):       // bit 6 set
                actualDo(u8LayerV, 6);
                __no_operation();
                break;
           case (1 << 7):       // bit 7 set
                actualDo(u8LayerV, 7);
                __no_operation();
                break;
           default:
                break;
      }
      u8SechValu &= (tU8)~u8LookFlag;
  }
}
//==============================================================================
// FUNCTION:        useFeatureBoard
//
// DESCRIPTION:     call parts init and loop in while (1). This is the main function.
//==============================================================================
void useFeatureBoard( void )
{
    tU8  u8temp; 

    memset((void *)&u8DebugTrace, 0x00, TRACE_BUFFER_SIZE);  // init debug trace buffer
    TracePtr = 0;                                            // init debug trace pointer

    fbPortInit();             // init MSP430F5438A 11 ports
    SetVCore(3);              // was 3
    fbStartXT1(1, 1);         // was ->(1, 1) this is USB clock setup ACLK, MCLK, SMCLK, DCO
    
    fbFuncPortInit();         // after port I/O, FUNC init and clock init, does function I/O init
    
#if 1
    startUSB();
#endif
    
    initLcdRowNum();
    initTimer();              // the main clock changed init LCD holding time, init IKICK output, interval to sample FB volts and MSP temperature
    initChargeAndTime();      // turn on charge and set count down time
    initMspAdc();             // init A/D converting always on, for MSP temp and VCC
    ReadADCCAL();
    
    initExchgIdx();           // init the data exchange type array, and idx
    JtUsbInit();              // 5638 init it for USB communication

    masterResetSys();

    // to look the tasks
    u8index = u8temp = 0;
    initInterActiveFlags();   // init system flags

    doneTxRadioMsg();         // sleep radio
    initRadioState();         // init radio
    diagInitLcd(OFF);         // when need diag LCD or debug LCD add it in

    info5638D.u8HardwareId = P9IN; 
#if 0
    // the loop keep other MSP camplete powr on init, 
    // it keeps the data exchange working. 
    for(tU8 lp = 0; lp < 100; lp++)  // tested 10, 50 all not work
    {
      waste_time(60000);
    }
#else
    __enable_interrupt();       // enable all interrupts
#endif
  
    
  while (1)                     // main loop
  {
    if(infoD.u8StrucRevNum == 0x00)   // 5438A side CURRENT_EEPREV value, 5438A is EEPROM varible to 5638 is RAM veriable
    {
      waste_time(6000);      
    }
    else
    {
      if(u8PwrOnDoOnce != YES)
      {  
        addOneTypeExchg(TYPE_INFO5638A);
        addOneTypeExchg(TYPE_INFO5638B);
        addOneTypeExchg(TYPE_INFO5638C);
        addOneTypeExchg(TYPE_INFO5638D);
        u8PwrOnDoOnce = YES;

        //Initialize WDT module in timer interval mode,
        //with ACLK as source at an interval of 1HZ or 1 second.
        WDT_intervalTimerInit(__MSP430_BASEADDRESS_WDT_A__,
            WDT_CLOCKSOURCE_ACLK,
            WDT_CLOCKDIVIDER_512K); //WDT_CLOCKDIVIDER_32K);    // 32K  1 seond, 

        //Enable Watchdog Interupt
        SFR_enableInterrupt(__MSP430_BASEADDRESS_SFR__,
            WDTIE);        
      }
    }

    // reset WDT
    WDT_resetTimer(__MSP430_BASEADDRESS_WDT_A__);

    // do the HSC filter      
    if((sysRamData.diag.u16XmtStatus[1] & HSC_USE_FILTER) == HSC_USE_FILTER)
    {
      // filter is enabled
      GPIO_setOutputHighOnPin(
        __MSP430_BASEADDRESS_PORT5_R__,
        GPIO_PORT_P5,
        P5_5_HSC_FLT_OUT);
    }
    else
    {
      // filter is disabled
      GPIO_setOutputLowOnPin(
        __MSP430_BASEADDRESS_PORT5_R__,
        GPIO_PORT_P5,
        P5_5_HSC_FLT_OUT);
    }

    // read HSC input
    sysRam56D.exchg6Pv.u32HsCnts = TA1R; 
            
    if (u8Layer2TaskScheduler != ALL_FLAGS_ZERO)
    {
      doCallTask(u8Layer2TaskScheduler, 1);
      u8temp++;
    }

    if (u8Layer1TaskScheduler != ALL_FLAGS_ZERO)
    {
      doCallTask(u8Layer1TaskScheduler, 2);
      u8temp++;
    }

    if (u8OtherTaskScheduler != ALL_FLAGS_ZERO)
    {
      u8temp++;
      doCallTask(u8OtherTaskScheduler, 3);
    }

    if (u8DoDiagErrorProcess != ALL_FLAGS_ZERO)
    {
      u8temp++;
      doCallTask(u8DoDiagErrorProcess, 4);
    }

    if (u8temp != ALL_FLAGS_ZERO)
    {
      //cannot sleep, EMV has at least one thing to do
      u8temp = 0;
      u8index++;
      if (u8index >= SHIFT_8BITS)
      {
        u8index = 0;
      }
    }
    else
    {
       lowPowerMode3();
       __no_operation();
    }
  }
}

//=============================================================================
// end file by xuedong
//=============================================================================
