//=============================================================================
// Header: RdWtVariableMdbus.c
// Date Time: 1/1/2013 9:32:43 AM
// Author: Xuedong.Liu
//
// Copyright (c) 2013  NewGate Instrument
//
//=============================================================================
//
// Description: when Modbus read or write variable need to run addtional logical
//     This file define those functions.  when BASP or HART read or write to same
//     variable, they could call the function in here.
//=============================================================================

//constant definitions, type definitions
#include "masterHeader.h"

//global volatile variables
#include "externGlobalVar.h"

//global function prototypes definitions
#include "externFunc.h"

void zeroCalProcess(tU16 u16InCalType, tU16 u16InCalPts);
void allSpanCalProcess(tU16 u16InCalType, tU16 u16InCalPts);
void calTypePtsProcess(void);
tReturnStatus calErrorCheck(void);
tU8 wtModbusCalCommon(ACCESS_VER_INFO *rwVarInfo);


//==============================================================================
//
// FUNCTION:        wtTageName
//
// DESCRIPTION:     when tage name is write to systemBuffer.u8TagName, this function
//                  been called.  It checks the xmitter mode change between 3095
//                  and 205. if it is change mode, the tage name will not save
//                  to flash,  but mode change will saved in flash.  if it is ture user
//                  tage name information. It will write to flash.  the flash is
//                  for power cycle, the setting are avalibale to user
//
//
//==============================================================================
tU8 rdFwRev(ACCESS_VER_INFO *rwVarInfo)
{
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr++] =
   infoD.xmt.u8FwProdCode[4];
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr++] =
   infoD.xmt.u8FwProdCode[5];
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr++] =
   info5638A.u8Fw5638Rev[2];
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr++] =
   info5638A.u8Fw5638Rev[3];
  
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtTageName(ACCESS_VER_INFO *rwVarInfo)
{
    // write last two tage name field, save
    //infoD.xmt.u8SfwTagName[5] = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];
    //rwVarInfo->u8RspBufPtr++;
    //infoD.xmt.u8SfwTagName[4] = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];
    //rwVarInfo->u8RspBufPtr++;

    //u8StartInterface |= INTERF_WRITE_FLASH;

    return rwVarInfo->u8RspBufPtr;
}

tU8 wtCtlIOReg(ACCESS_VER_INFO *rwVarInfo)
{
    // do like this; it can cross reference on other MSP
    (void)doMspAdc1Cal(rwVarInfo);
    return rwVarInfo->u8RspBufPtr;  
}

tU8 bdFwRev(ACCESS_VER_INFO *rwVarInfo)
{
  // read variable
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = BuildFwInfo.u8VerMajor;
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = BuildFwInfo.u8VerMinor;
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}

tU8 ack00xxFmt(ACCESS_VER_INFO *rwVarInfo)
{
  // response 3095 host in format->1st byte is 0x00; 2nd byte is register value
  // read variable
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = 0x00;
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = *((tU8 *)rwVarInfo->eepVarAddr);
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}
tU8 rdWtMdAddr(ACCESS_VER_INFO *rwVarInfo)
{
  // response 3095 host in format->1st byte is 0x00; 2nd byte is register value
  // read variable
  if (rwVarInfo->u8FuncCode == MD_CMD_FC03)
  {
    // read Modbus address
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = 0x00;
    rwVarInfo->u8RspBufPtr++;
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = *((tU8 *)rwVarInfo->eepVarAddr);
    rwVarInfo->u8RspBufPtr++;
  }
  else
  {
    // write Modbus address
    // skip unused byte
    rwVarInfo->u8RspBufPtr++;
    *((tU8 *)rwVarInfo->eepVarAddr) = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];

    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 rdWtDigiIOReg(ACCESS_VER_INFO *rwVarInfo)
{
  // do like this; it can cross reference on other MSP
  (void)doMspAdc1Cal(rwVarInfo);
  return rwVarInfo->u8RspBufPtr;
}

tU8 mapDpRang(ACCESS_VER_INFO *rwVarInfo)
{
  union {
    tU8  u8ToU8[2];
    tU16 u16Data;
  }fmtU16;
  // read varibale
  fmtU16.u16Data = sysBuf.mfgPg1[0].SensorDpRange;

  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = fmtU16.u8ToU8[1];
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = fmtU16.u8ToU8[0];
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}

tU8 rdASCII(ACCESS_VER_INFO *rwVarInfo)
{
  // send byte 0 then send byte 1
  union {
    tU8  u8ToU8[2];
    tU16 u16Data;
  }fmtU16;

  fmtU16.u16Data = *((tU16 *)rwVarInfo->eepVarAddr);

  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = fmtU16.u8ToU8[1];
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = fmtU16.u8ToU8[0];
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}


tU8 comm95WtCrossRef(DO_CROSS_REF *do3095Ref)
{
  tU8 u8idx, u8OutCode, u8LkV = *do3095Ref->u8LookValue;
  for (u8idx = 0; u8idx < do3095Ref->u8TableSize; u8idx++)
  {
    if (u8LkV == do3095Ref->lkTable[u8idx].u83095Code)
    {
      // found matching 3095 system unit
      u8OutCode = do3095Ref->lkTable[u8idx].u8SysCode;
      break;
    }
  }
  if ( u8idx >= do3095Ref->u8TableSize)
  {
    u8OutCode = RMT_UNKNOW;
  }
  if ((do3095Ref->lkTable == dpUnit3095System) &&
      (u8OutCode == RMT_UNKNOW))
  {
    // no matching found, set to 3095 default system code
    u8OutCode = U_inH2OAt60F;
  }
  return u8OutCode;
}

tU8 comm95RdCrossRef(DO_CROSS_REF *do3095Ref)
{
  tU8 u8idx, u8OutCode, u8LkV = *do3095Ref->u8LookValue;
  for (u8idx = 0; u8idx < do3095Ref->u8TableSize; u8idx++)
  {
    if (u8LkV == do3095Ref->lkTable[u8idx].u8SysCode)
    {
      // found system item
      u8OutCode = do3095Ref->lkTable[u8idx].u83095Code;
      break;
    }
  }
  if ( u8idx >= do3095Ref->u8TableSize)
  {
    u8OutCode = RMT_UNKNOW;
  }
  if ((do3095Ref->lkTable == dpUnit3095System) &&
      (u8OutCode == RMT_UNKNOW))
  {
    // return 3095 default
    u8OutCode = DEFAULT95_DP_UNIT;
    // system internal set to U_inH2OAt60F match with 3095 default
    infoD.xmt.u8DpUnits = U_inH2OAt60F;
  }

  // for read -> return data
  u8MDResponseBuf[do3095Ref->inOutInfo->portEnv->u8PortID][do3095Ref->inOutInfo->u8RspBufPtr] = 0x00;
  do3095Ref->inOutInfo->u8RspBufPtr++;
  u8MDResponseBuf[do3095Ref->inOutInfo->portEnv->u8PortID][do3095Ref->inOutInfo->u8RspBufPtr] = u8OutCode;
  do3095Ref->inOutInfo->u8RspBufPtr++;

  return do3095Ref->inOutInfo->u8RspBufPtr;
}

tU8 mapFlageMtl(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = flangeMtl3095System;
  inRef.u8TableSize = FLANGE_MTL_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapFlgType(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = flangeType3095System;
  inRef.u8TableSize = FLANGE_TYPE_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapDrinVnt(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = drainVent3095System;
  inRef.u8TableSize = DRAINVENT_TYPE_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapORng(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = oRingMtl3095System;
  inRef.u8TableSize = ORING_MTL_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapRmtSealT(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = remoteSealT3095System;
  inRef.u8TableSize = REMOTE_SEAL_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapRmtFluid(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = rmtSealFuildT3095System;
  inRef.u8TableSize = REMOTE_SEALFILL_FUILD_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 mapRmtIso(ACCESS_VER_INFO *rwVarInfo)
{
  DO_CROSS_REF inRef;

  inRef.u8LookValue = (tU8 *)rwVarInfo->eepVarAddr;
  inRef.lkTable = rmtSealIsoMtl3095System;
  inRef.u8TableSize = RMT_SEALISO_MTL_SIZE;
  inRef.inOutInfo = rwVarInfo;

  return (comm95RdCrossRef(&inRef));
}

tU8 canDevType(ACCESS_VER_INFO *rwVarInfo)
{
    // read variable
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = 0x00;
    rwVarInfo->u8RspBufPtr++;
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = SP3095_GP;
    rwVarInfo->u8RspBufPtr++;
    return rwVarInfo->u8RspBufPtr;
}

tU8 byteLoHi(ACCESS_VER_INFO *rwVarInfo)
{
  union {
    tU8  u8ToU8[2];
    tU16 u16Data;
  }formatU16;
  // read variable
  formatU16.u16Data = *((tU16 *)rwVarInfo->eepVarAddr);
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = formatU16.u8ToU8[1];
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = formatU16.u8ToU8[0];
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}

tU8 byteHiLo(ACCESS_VER_INFO *rwVarInfo)
{
  union {
    tU8  u8ToU8[2];
    tU16 u16Data;
  }formatU16;
  // read variable
  formatU16.u16Data = *((tU16 *)rwVarInfo->eepVarAddr);
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = formatU16.u8ToU8[0];
  rwVarInfo->u8RspBufPtr++;
  u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = formatU16.u8ToU8[1];
  rwVarInfo->u8RspBufPtr++;
  return rwVarInfo->u8RspBufPtr;
}

tU8 doStatus4(ACCESS_VER_INFO *rwVarInfo)
{
  // do like this; it can cross reference on other MSP
  (void)doMspAdc1Cal(rwVarInfo);
  return rwVarInfo->u8RspBufPtr;
}

tU8 rdWtDpUnit(ACCESS_VER_INFO *rwVarInfo)
{
#if 0
  tU8 u8AckCnt;
  sysRamData.dp[0].u8DpOldUnits = *((tU8 *)rwVarInfo->eepVarAddr);

  u8AckCnt = mapUnits(rwVarInfo, PRESS_TYPE_UNIT_MAP);            // system unit changed and saved
  if (rwVarInfo->u8FuncCode == MD_CMD_FC16)
  {
    //u8interfaceTimer |= CALC_DP_UNIT_CHANGE;    // ask for unit conversion calcuation
  }
  return u8AckCnt;
#endif
  return rwVarInfo->u8RspBufPtr;
}

tU8 rdWtSpUnit(ACCESS_VER_INFO *rwVarInfo)
{
#if 0
  tU8 u8AckCnt;
  //sysRamData.dp[0].u8SpOldUnits = *((tU8 *)rwVarInfo->eepVarAddr);

  u8AckCnt = mapUnits(rwVarInfo, PRESS_TYPE_UNIT_MAP);            // system unit changed and saved
  if (rwVarInfo->u8FuncCode == MD_CMD_FC16)
  {
    //u8interfaceTimer |= CALC_SP_UNIT_CHANGE;   // ask for unit conversion calcuation
  }
  return u8AckCnt;
#endif
  return rwVarInfo->u8RspBufPtr;
}

tU8 mapUnits(ACCESS_VER_INFO *rwVarInfo, tU8 u8Type)
{
  DO_CROSS_REF inRef;

  tU8 u8WtTemp = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];
  tU8 u8ByteCnt, u8VarValue = *((tU8 *)rwVarInfo->eepVarAddr);
  if (rwVarInfo->u8FuncCode == MD_CMD_FC03)
  {
    // read unit code, convert unit from system to 3095
    inRef.u8LookValue = &u8VarValue;
    if (u8Type == PRESS_TYPE_UNIT_MAP)
    {
      inRef.lkTable = dpUnit3095System;
      inRef.u8TableSize = DP_UNIT_SIZE;
    }
    else
    {
      inRef.lkTable = ptUnit3095System;
      inRef.u8TableSize = PT_UNIT_SIZE;
    }
    inRef.inOutInfo = rwVarInfo;
    u8ByteCnt = comm95RdCrossRef(&inRef);
  }
  else
  {
    // write unit code
    // skip high byte
    rwVarInfo->u8RspBufPtr++;
    // low byte is user selected 3095 unit
    u8WtTemp = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];
    // convert unit from 3095 to system
    inRef.u8LookValue = &u8WtTemp;
    if (u8Type == PRESS_TYPE_UNIT_MAP)
    {
      inRef.lkTable = dpUnit3095System;
      inRef.u8TableSize = DP_UNIT_SIZE;
    }
    else
    {
      inRef.lkTable = ptUnit3095System;
      inRef.u8TableSize = PT_UNIT_SIZE;
    }
    inRef.inOutInfo = rwVarInfo;
    // update internal veriables
    *((tU8 *)rwVarInfo->eepVarAddr) = comm95WtCrossRef(&inRef);

    // write one byte unit code to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
    rwVarInfo->u8RspBufPtr++;
    u8ByteCnt = rwVarInfo->u8RspBufPtr;
  }
  return u8ByteCnt;
}

tU8 mdRdWtByte(ACCESS_VER_INFO *rwVarInfo)
{
  tU8 u8WtTemp;
  tU8 u8VarValue = *((tU8 *)rwVarInfo->eepVarAddr);
  if (rwVarInfo->u8FuncCode == MD_CMD_FC03)
  {
    // read unit code
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = 0;
    rwVarInfo->u8RspBufPtr++;
    u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr] = u8VarValue;
    rwVarInfo->u8RspBufPtr++;
  }
  else
  {
    // write unit code
    // skip high byte
    rwVarInfo->u8RspBufPtr++;
    // low byte is data
    u8WtTemp = u8MDResponseBuf[rwVarInfo->portEnv->u8PortID][rwVarInfo->u8RspBufPtr];
    if (u8WtTemp != u8VarValue)
    {
      // update internal veriables
      *((tU8 *)rwVarInfo->eepVarAddr) = u8WtTemp;
      // write one byte temperatur unit code to EEPROM
      //u8StartInterface |= INTERF_WRITE_FLASH;
    }
    rwVarInfo->u8RspBufPtr++;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 rdWtPtUnit(ACCESS_VER_INFO *rwVarInfo)
{
#if 0
  tU8 u8AckCnt;
  //sysRamData.dp[0].u8SpOldUnits = *((tU8 *)rwVarInfo->eepVarAddr);

  u8AckCnt = mapUnits(rwVarInfo, TEMPERATURE_TYPE_UNIT_MAP);   // system unit changed and saved
  if (rwVarInfo->u8FuncCode == MD_CMD_FC16)
  {
    //u8interfaceTimer |= CALC_SP_UNIT_CHANGE;                   // ask for unit conversion calcuation
  }
#endif
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpOpUrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= sysRamData.dp[0].f32DpURL)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= infoB.snsDpCfg[0].f32DpLRV))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpOpLrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= infoB.snsDpCfg[0].f32DpURV)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= sysRamData.dp[0].f32DpLRL))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}
tU8 wtSpOpUrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= sysRamData.sp[0].f32SpURL)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= infoC.snsSpCfg[0].f32SpLRV))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtSpOpLrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= infoC.snsSpCfg[0].f32SpURV)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= sysRamData.sp[0].f32SpLRL))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtPtOpUrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= sysRamData.pt.f32PtURL)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= infoA.pt.f32RtdLRV))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtPtOpLrv(ACCESS_VER_INFO *rwVarInfo)
{
  if ((*(tF32 *)rwVarInfo->eepVarAddr <= infoA.pt.f32RtdURV)
    && (*(tF32 *)rwVarInfo->eepVarAddr >= sysRamData.pt.f32PtLRL))
  {
    // write data to EEPROM
    //u8StartInterface |= INTERF_WRITE_FLASH;
  }
  return rwVarInfo->u8RspBufPtr;
}
typedef struct {
  tU16 u16CalPtCd;                  // this field can be tU8, use tU16 to keep even address
  volatile tF32 *f32CalPtV;
  volatile tF32 *f32Trim;
  tF32 f32BetaLow;
  tF32 f32BetaHi;
  tF32 f32MinSpan;
//  tF32 *f32MinSpanFrom;
} calPoint;
#define MAX_CAL_TPS         4       // EMV support max calibration type is 3 -> DP, SP, PT
#define MAX_CAL_PTS         5       // EMV support max Calibreation points is 5 -> zero, mid1,2, 3, span

typedef struct {
  tU16  u16CalType;                 // this field can be tU8, use tU16 to keep even address
  tF32 volatile *f32Live;
  calPoint defPt[MAX_CAL_PTS];
} calDevVar;

tF32 f32DpZeroCal = 0.0f, f32SpZeroCal = 0.0f, f32PtCalZero = -40.0f, f32PtCalSpan = 750.0f;

const volatile calDevVar definedCal[MAX_CAL_TPS] =
{
  // [0] = DP calibration points
  {sysCalTypeDp, &sysRamData.dp[0].f32DpUndampUntrim,
    {
      {sysCalPtZero, &f32DpZeroCal, &infoB.snsDpCfg[0].f32DpZeroTrim, CALI_ZERO_LOW_LIMIT, CALI_ZERO_HI_LIMIT, CALI_NON_SPAN_REQ},
      {sysCalPtSpan, &infoB.snsDpCfg[0].f32DpSpanCal, &infoB.snsDpCfg[0].f32DpSpanTrim, CALI_SPAN_LOW_LIMIT, CALI_SPAN_HI_LIMIT, CALI_MIN_SPAN_SET},
    },
  },
  // [1] = SP calibration points
  {sysCalTypeSp, &sysRamData.sp[0].f32SpUndampUntrim,
    {
      {sysCalPtZero, &f32SpZeroCal, &infoC.snsSpCfg[0].f32SpZeroTrim, CALI_ZERO_LOW_LIMIT, CALI_ZERO_HI_LIMIT, CALI_NON_SPAN_REQ},
      {sysCalPtSpan, &infoC.snsSpCfg[0].f32SpSpanCal, &infoC.snsSpCfg[0].f32SpSpanTrim, CALI_SPAN_LOW_LIMIT, CALI_SPAN_HI_LIMIT, CALI_MIN_SPAN_SET},
    },
  },
  // [2] = PT calibration points

  {sysCalTypePt, &sysRamData.pt.f32PtUndampUntrim,
    {
      {sysCalPtZero, &f32PtCalZero, &infoA.pt.f32RtdZeroTrim, CALI_ZERO_LOW_LIMIT, CALI_ZERO_HI_LIMIT, CALI_NON_SPAN_REQ},
      {sysCalPtSpan, &f32PtCalSpan, &infoA.pt.f32RtdSpanTrim, CALI_SPAN_LOW_LIMIT, CALI_SPAN_HI_LIMIT, CALI_MIN_SPAN_SET},
    },
  },
  // [3] = R0 Cal
  {sysCalTypeR0, &infoA.pt.f32RtdUserRef,
    {
      {sysCalPtZero, &f32PtCalZero, &infoA.pt.f32RtdZeroTrim, CALI_ZERO_LOW_LIMIT, CALI_ZERO_HI_LIMIT, CALI_NON_SPAN_REQ},
/*placehold*/  {sysCalPtSpan, &f32PtCalSpan, &infoA.pt.f32RtdSpanTrim, CALI_SPAN_LOW_LIMIT, CALI_SPAN_HI_LIMIT, CALI_MIN_SPAN_SET},
   }
  },
};

void calTypePtsProcess(void)
{
  tU16 u16InCalType = sysRamData.cali.u16ExecuteCal,  // u16ExecuteCal modified from 1 based
       u16InCalPts = sysRamData.cali.u16SetCalType;   // u16SetCalType modified from 1 based

  //u8interfaceTimer &= (tU8)~CALIB_PROCESS_ON;
  if (u16InCalType == sysCalTypeR0)
  {
//    rtdCalR0();
  }
  else if (u16InCalPts == sysCalPtZero)
  {
    // do zero calibration
    zeroCalProcess(u16InCalType, u16InCalPts);
  }
  else
  {
    // do all span calibration
    allSpanCalProcess(u16InCalType, u16InCalPts);
  }
}

tReturnStatus calErrorCheck(void)
{
  tReturnStatus error = RS_good;
  tU16 u16InCalType = sysRamData.cali.u16ExecuteCal,  // u16ExecuteCal modified from 1 based
       u16InCalPts = sysRamData.cali.u16SetCalType;   // u16SetCalType modified from 1 based
  tF32 f32TagV = sysRamData.cali.f32CalSetVal,
       f32LiveV = *definedCal[u16InCalType].f32Live;

  tF32 f32PrsntError;
  if (u16InCalType == sysCalTypeR0)
  {
    // make sure not error return
    f32PrsntError = 0.0f;
  }
  else if (u16InCalPts != sysCalPtZero)
  {
    // if it is not zero, it is span calibrate
    f32PrsntError = (f32LiveV - f32TagV) /f32TagV;
  }
  else
  {
    f32PrsntError = f32TagV;  // compare with 0
  }
  // check target-live vs cal band low limit
  if (f32PrsntError < definedCal[u16InCalType].defPt[u16InCalPts].f32BetaLow)
  {
    error = RS_appliedProcessTooSmall;
  }
  // check target-live vs cal band Hi limit
  else if (f32PrsntError > definedCal[u16InCalType].defPt[u16InCalPts].f32BetaHi)
  {
    error = RS_appliedProcessTooLarge;
  }
  else
  {
    error = RS_good;
  }
  return error;
}

void zeroCalProcess(tU16 u16InCalType, tU16 u16InCalPts)
{
  tF32 f32LiveV = *definedCal[u16InCalType].f32Live,
       f32CalInputV = *definedCal[u16InCalType].defPt[u16InCalPts].f32CalPtV;

  *definedCal[u16InCalType].defPt[u16InCalPts].f32Trim = f32CalInputV - f32LiveV;

  // write zero cal and zero trim to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
}

void allSpanCalProcess(tU16 u16InCalType, tU16 u16InCalPts)
{
  tF32 f32TagV = sysRamData.cali.f32CalSetVal,
       f32LiveV = *definedCal[u16InCalType].f32Live,
       f32ZeroTrim = *definedCal[u16InCalType].defPt[0].f32Trim,
       f32temp;

  f32temp = f32TagV /(f32LiveV + f32ZeroTrim);
  f32ZeroTrim = f32TagV - (f32temp * f32LiveV);
  *definedCal[u16InCalType].defPt[0].f32Trim = f32ZeroTrim;

  // add this cal trim with old trim
  *definedCal[u16InCalType].defPt[u16InCalPts].f32Trim = f32temp;

  // write zero cal and zero trim to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
}

tU8 wtModbusCalCommon(ACCESS_VER_INFO *rwVarInfo)
{
  if (calErrorCheck() != RS_good)
  {
    sysRamData.diag.u16XmtStatus[0] |= (tU16)PV_OUT_LIMITS;
    return illegalRequestValue(rwVarInfo->portEnv);
  }
  else
  {
    //u8interfaceTimer |= CALIB_PROCESS_ON;
  }
  // not use addtional mwssage bytes
  return rwVarInfo->u8RspBufPtr;
}
// R0 Calibration
tU8 wtRtdR0Cal(ACCESS_VER_INFO *rwVarInfo)
{
  sysRamData.cali.u16ExecuteCal = sysCalTypeR0;      // board R0
  sysRamData.cali.u16SetCalType = sysCalPtZero;      // Zero
  // systemBuffer.f32CalSetVal at this time is RTD real resistor value
  // user input is ohms, no need unit conversion
  sysRamData.cali.f32CalSetVal = *(tF32*)rwVarInfo->eepVarAddr;
  return wtModbusCalCommon(rwVarInfo);
}

// DP zero & span trims calculation
tU8 wtDpZeroCal(ACCESS_VER_INFO *rwVarInfo)
{
  sysRamData.cali.u16ExecuteCal = sysCalTypeDp;        // DP
  sysRamData.cali.u16SetCalType = sysCalPtZero;        // Zero
  infoB.snsDpCfg[0].f32DpZeroTrim = DEFAULT_ZERO_OFFSET; // set to default
  // zero is 0.0, does not need unit conversion
  sysRamData.cali.f32CalSetVal = *(tF32*)rwVarInfo->eepVarAddr;
  return wtModbusCalCommon(rwVarInfo);
}

tU8 wtDpSpanCal(ACCESS_VER_INFO *rwVarInfo)
{
  CAL_PV_STRUC getTargetV;
  sysRamData.cali.u16ExecuteCal = sysCalTypeDp;  // DP
  sysRamData.cali.u16SetCalType = sysCalPtSpan;  // Span
  infoB.snsDpCfg[0].f32DpSpanTrim = DEFAULT_SPAN_TRIM;
  // at which value did calibration
  *definedCal[sysCalTypeDp].defPt[sysCalPtSpan].f32CalPtV = *(tF32*)rwVarInfo->eepVarAddr;
  // convert unit taget value to sensor unit value
  getTargetV.u8InUnit = infoD.xmt.u8DpUnits;
  //getTargetV.u8OutUnit = systemBuffer.u8DpDefaultUnit;
  getTargetV.f32NewValue = *(tF32*)rwVarInfo->eepVarAddr;
  sysRamData.cali.f32CalSetVal = convertPresUnitsStd(&getTargetV);
  return wtModbusCalCommon(rwVarInfo);
}
// SP zero & span trim calculation
tU8 wtSpZeroCal(ACCESS_VER_INFO *rwVarInfo)
{
  sysRamData.cali.u16ExecuteCal = sysCalTypeSp;  // SP
  sysRamData.cali.u16SetCalType = sysCalPtZero;  // Zero
  infoC.snsSpCfg[0].f32SpZeroTrim = DEFAULT_ZERO_OFFSET;
  // zero is 0.0, does not need unit conversion
  sysRamData.cali.f32CalSetVal = *(tF32*)rwVarInfo->eepVarAddr;
  return wtModbusCalCommon(rwVarInfo);
}
tU8 wtSpSpanCal(ACCESS_VER_INFO *rwVarInfo)
{
  CAL_PV_STRUC getTargetV;
  sysRamData.cali.u16ExecuteCal = sysCalTypeSp;  // SP
  sysRamData.cali.u16SetCalType = sysCalPtSpan;  // Span
  infoC.snsSpCfg[0].f32SpSpanTrim = DEFAULT_SPAN_TRIM;
  // at which value did calibration
  *definedCal[sysCalTypeDp].defPt[sysCalPtSpan].f32CalPtV = *(tF32*)rwVarInfo->eepVarAddr;
  // convert unit taget value to sensor unit value
  getTargetV.u8InUnit = infoD.xmt.u8SpUnits;
  //getTargetV.u8OutUnit = systemBuffer.u8SpDefaultUnit;
  getTargetV.f32NewValue = *(tF32*)rwVarInfo->eepVarAddr;
  sysRamData.cali.f32CalSetVal = convertPresUnitsStd(&getTargetV);
  return wtModbusCalCommon(rwVarInfo);
}

// Pt zero & span trim calculation
tU8 wtPtZeroCal(ACCESS_VER_INFO *rwVarInfo)
{
  CAL_PV_STRUC getTargetV;
  sysRamData.cali.u16ExecuteCal = sysCalTypePt;  // PT
  sysRamData.cali.u16SetCalType = sysCalPtZero;  // Zero
  infoA.pt.f32RtdZeroTrim = DEFAULT_ZERO_OFFSET;
  // convert unit taget value to sensor unit value
  getTargetV.u8InUnit = infoD.xmt.u8RtdUnits;
  //getTargetV.u8OutUnit = systemBuffer.u8PtDefaultUnit;
  getTargetV.f32NewValue = *(tF32*)rwVarInfo->eepVarAddr;
  sysRamData.cali.f32CalSetVal = convertPtUnitsStd(&getTargetV);
  return wtModbusCalCommon(rwVarInfo);
}
tU8 wtPtSpanCal(ACCESS_VER_INFO *rwVarInfo)
{
  CAL_PV_STRUC getTargetV;
  sysRamData.cali.u16ExecuteCal = sysCalTypePt;  // PT
  sysRamData.cali.u16SetCalType = sysCalPtSpan;  // Span
  infoA.pt.f32RtdSpanTrim = DEFAULT_SPAN_TRIM;
  // at which value did calibration
  *definedCal[sysCalTypeDp].defPt[sysCalPtSpan].f32CalPtV = *(tF32*)rwVarInfo->eepVarAddr;
  // convert unit taget value to sensor unit value
  getTargetV.u8InUnit = infoD.xmt.u8RtdUnits;
  //getTargetV.u8OutUnit = systemBuffer.u8PtDefaultUnit;
  getTargetV.f32NewValue = *(tF32*)rwVarInfo->eepVarAddr;
  sysRamData.cali.f32CalSetVal = convertPtUnitsStd(&getTargetV);
  return wtModbusCalCommon(rwVarInfo);
}

// scaling calculation
void calcScaleSlopOffset(void)
{
#if 0
  tF32 f32TempX;
  tU16 u16TempY;

  //u8ProCycleRequest &= (tU8)~PRO_CALC_PV_SCALES;                     // clear flag

  // DP Scaling factor calcuation
  u16TempY = (infoB.snsDpCfg[0].u16ScaleDpY2 - infoB.snsDpCfg[0].u16ScaleDpY1);// y2 -y1
  f32TempX = (infoB.snsDpCfg[0].f32ScaleDpX2 - infoB.snsDpCfg[0].f32ScaleDpX1);// x2 - x1
  f32TempX = u16TempY/f32TempX;                                      // (y2-y1)/(x2-x1)  -> count/O_PV
  infoB.snsDpCfg[0].u16FactorDp = (tU16)f32TempX;                         // = slope

  f32TempX = -(f32TempX * infoB.snsDpCfg[0].f32ScaleDpX1);                // slop * (0 - x1)
  f32TempX = f32TempX + infoB.snsDpCfg[0].u16ScaleDpY1;                   // b = -slop * x1 + y1 -> count
  //infoB.snsDpCfg[0].u16OffsetDP = (tU16)f32TempX;                         // offset
  // SP Scaling factor calcuation
  u16TempY = (infoC.snsSpCfg[0].u16ScaleSpY2 - infoC.snsSpCfg[0].u16ScaleSpY1);// y2 -y1
  f32TempX = (infoC.snsSpCfg[0].f32ScaleSpX2 - infoC.snsSpCfg[0].f32ScaleSpX1);// x2 - x1
  f32TempX = u16TempY/f32TempX;                                      // (y2-y1)/(x2-x1)  -> count/O_PV
  infoC.snsSpCfg[0].u16FactorSp = (tU16)f32TempX;                         // = slope

  f32TempX = -(f32TempX * infoC.snsSpCfg[0].f32ScaleSpX1);                // slop * (0 - x1)
  f32TempX = f32TempX + infoC.snsSpCfg[0].u16ScaleSpY1;                   // b = -slop * x1 + y1 -> count
  //infoC.snsSpCfg[0].u16OffsetSP = (tU16)f32TempX;                         // offset
  // PT Scaling factor calcuation
  u16TempY = (infoA.pt.u16ScalePtY2 - infoA.pt.u16ScalePtY1);// y2 -y1
  f32TempX = (infoA.pt.f32ScalePtX2 - infoA.pt.f32ScalePtX1);// x2 - x1
  f32TempX = u16TempY/f32TempX;                                      // (y2-y1)/(x2-x1)  -> count/O_PV
  infoA.pt.u16FactorPt = (tU16)f32TempX;                         // = slope

  f32TempX = -(f32TempX * infoA.pt.f32ScalePtX1);                // slop * (0 - x1)
  f32TempX = f32TempX + infoA.pt.u16ScalePtY1;                   // b = -slop * x1 + y1 -> count
  infoA.pt.u16OffsetPt = (tU16)f32TempX;                         // offset
#endif
}

tU8 wtDpY1(ACCESS_VER_INFO *rwVarInfo)
{
  // do scale factor and offset calculation
  //u8ProCycleRequest |= PRO_CALC_PV_SCALES;                           // set flag to calculate scale factor
  // write y1 (2byte) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpY2(ACCESS_VER_INFO *rwVarInfo)
{
  // do scale factor and offset calculation
  //u8ProCycleRequest |= PRO_CALC_PV_SCALES;
  // write y2 (2byte) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpFac(ACCESS_VER_INFO *rwVarInfo)
{
  // write factor (2bytes) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpOffst(ACCESS_VER_INFO *rwVarInfo)
{
  // write offset (2 bytes) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtFlashTestEnable(ACCESS_VER_INFO *rwVarInfo)
{
  //set internal veraibles
  u16FlashTest = *(tU16 *)rwVarInfo->eepVarAddr;
  if (u16FlashTest == YES)
  {
    //u16FlashTestStop = NO;
  }
  return rwVarInfo->u8RspBufPtr;
}

tU8 wtDpX1(ACCESS_VER_INFO *rwVarInfo)
{
  // do scale factor and offset calculation
  //u8ProCycleRequest |= PRO_CALC_PV_SCALES;
  // write x1 (4bytes) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}
tU8 wtDpX2(ACCESS_VER_INFO *rwVarInfo)
{
  // do scale factor and offset calculation
  //u8ProCycleRequest |= PRO_CALC_PV_SCALES;
  // write x2 (4bytes) to EEPROM
  //u8StartInterface |= INTERF_WRITE_FLASH;
  return rwVarInfo->u8RspBufPtr;
}

tU8 getDpRawCntLo(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getDpRawCntHi(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getSpRawCntLo(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getSpRawCntHi(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getPtRawCntLo(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getPtRawCntHi(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getStRawCntLo(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}
tU8 getStRawCntHi(ACCESS_VER_INFO *rwVarInfo)
{
  return(byteHiLo(rwVarInfo)); // actually is lo then hi byte on comm line
}

void chge5638CtrlItems(void)
{
  if((info5638B.u8Io5638Control & DISPLY_LED_ON) == DISPLY_LED_ON)
  {
    // turn on LED
  }
  else
  {
    // turn off LED
  }
  if((info5638B.u8Io5638Control & HSC_FILTER_ON) == HSC_FILTER_ON)
  {
    // set HSC filter to 1
  }
  else
  {
    // set HSC filter to 0
  }
  if((info5638B.u8Io5638Control & EN_HS_AI_1SET) == EN_HS_AI_1SET)
  {
    // set EN_HS_AI to 1
  }
  else
  {
    // set EN_HS_AI to 0
  }
}

